/*
 * @(#)TreeWalker.java            1.2              12 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

import java.util.Hashtable;
import net.percederberg.mib.asn1.node.Node;

/**
 * The abstract class implementing a tree walker interface.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.net
 */
public abstract class TreeWalker extends Object {

   /**
    * A hashtable to store input values for the nodes.
    */
   private Hashtable in = null;

   /**
    * A hashtable to store output values from the nodes.
    */
   private Hashtable out = null;

   /**
    * Returns the input value for a given node.
    *
    * @param  node     a parse tree node
    * @return the value for this node
    */
   protected Object getIn(Node node) {
      if (in == null || node == null) {
         return null;
      }
      return in.get(node);
   }

   /**
    * Returns the output value from a given node.
    *
    * @param  node     a parse tree node
    * @return the value for this node
    */
   protected Object getOut(Node node) {
      if (out == null || node == null) {
         return null;
      }
      return out.get(node);
   }

   /**
    * Sets the input value for a given node.
    *
    * @param  node     a parse tree node
    * @param  value    the input value
    */
   public void setIn(Node node, Object value) {
      if (node == null) {
         return;
      }
      if (in == null) {
         in = new Hashtable();
      }
      if (value != null) {
         in.put(node, value);
      } else {
         in.remove(node);
      }
   }

   /**
    * Sets the output value for a given node.
    *
    * @param  node     a parse tree node
    * @param  value    the output value
    */
   public void setOut(Node node, Object value) {
      if (node == null) {
         return;
      }
      if (out == null) {
         out = new Hashtable();
      }
      if (value != null) {
         out.put(node, value);
      } else {
         out.remove(node);
      }
   }
}

