/*
 * Asn1Analyzer.java
 * 
 * THIS FILE HAS BEEN GENERATED AUTOMATICALLY. DO NOT EDIT!
 * 
 * This work is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This work is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * As a special exception, the copyright holders of this library give
 * you permission to link this library with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also meet,
 * for each linked independent module, the terms and conditions of the
 * license of that module. An independent module is a module which is
 * not derived from or based on this library. If you modify this
 * library, you may extend this exception to your version of the
 * library, but you are not obligated to do so. If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 * Copyright (c) 2004 Per Cederberg. All rights reserved.
 */

package net.percederberg.mibble.asn1;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

/**
 * A class providing callback methods for the parser.
 * 
 * @author   Per Cederberg, <per at percederberg dot net>
 * @version  2.2
 */
public abstract class Asn1Analyzer extends Analyzer {

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enter(Node node) throws ParseException {
        switch (node.getId()) {
        case Asn1Constants.DOT:
            enterDot((Token) node);
            break;
        case Asn1Constants.DOUBLE_DOT:
            enterDoubleDot((Token) node);
            break;
        case Asn1Constants.TRIPLE_DOT:
            enterTripleDot((Token) node);
            break;
        case Asn1Constants.COMMA:
            enterComma((Token) node);
            break;
        case Asn1Constants.SEMI_COLON:
            enterSemiColon((Token) node);
            break;
        case Asn1Constants.LEFT_PAREN:
            enterLeftParen((Token) node);
            break;
        case Asn1Constants.RIGHT_PAREN:
            enterRightParen((Token) node);
            break;
        case Asn1Constants.LEFT_BRACE:
            enterLeftBrace((Token) node);
            break;
        case Asn1Constants.RIGHT_BRACE:
            enterRightBrace((Token) node);
            break;
        case Asn1Constants.LEFT_BRACKET:
            enterLeftBracket((Token) node);
            break;
        case Asn1Constants.RIGHT_BRACKET:
            enterRightBracket((Token) node);
            break;
        case Asn1Constants.MINUS:
            enterMinus((Token) node);
            break;
        case Asn1Constants.LESS_THAN:
            enterLessThan((Token) node);
            break;
        case Asn1Constants.VERTICAL_BAR:
            enterVerticalBar((Token) node);
            break;
        case Asn1Constants.DEFINITION:
            enterDefinition((Token) node);
            break;
        case Asn1Constants.DEFINITIONS:
            enterDefinitions((Token) node);
            break;
        case Asn1Constants.EXPLICIT:
            enterExplicit((Token) node);
            break;
        case Asn1Constants.IMPLICIT:
            enterImplicit((Token) node);
            break;
        case Asn1Constants.TAGS:
            enterTags((Token) node);
            break;
        case Asn1Constants.BEGIN:
            enterBegin((Token) node);
            break;
        case Asn1Constants.END:
            enterEnd((Token) node);
            break;
        case Asn1Constants.EXPORTS:
            enterExports((Token) node);
            break;
        case Asn1Constants.IMPORTS:
            enterImports((Token) node);
            break;
        case Asn1Constants.FROM:
            enterFrom((Token) node);
            break;
        case Asn1Constants.MACRO:
            enterMacro((Token) node);
            break;
        case Asn1Constants.INTEGER:
            enterInteger((Token) node);
            break;
        case Asn1Constants.REAL:
            enterReal((Token) node);
            break;
        case Asn1Constants.BOOLEAN:
            enterBoolean((Token) node);
            break;
        case Asn1Constants.NULL:
            enterNull((Token) node);
            break;
        case Asn1Constants.BIT:
            enterBit((Token) node);
            break;
        case Asn1Constants.OCTET:
            enterOctet((Token) node);
            break;
        case Asn1Constants.STRING:
            enterString((Token) node);
            break;
        case Asn1Constants.ENUMERATED:
            enterEnumerated((Token) node);
            break;
        case Asn1Constants.SEQUENCE:
            enterSequence((Token) node);
            break;
        case Asn1Constants.SET:
            enterSet((Token) node);
            break;
        case Asn1Constants.OF:
            enterOf((Token) node);
            break;
        case Asn1Constants.CHOICE:
            enterChoice((Token) node);
            break;
        case Asn1Constants.UNIVERSAL:
            enterUniversal((Token) node);
            break;
        case Asn1Constants.APPLICATION:
            enterApplication((Token) node);
            break;
        case Asn1Constants.PRIVATE:
            enterPrivate((Token) node);
            break;
        case Asn1Constants.ANY:
            enterAny((Token) node);
            break;
        case Asn1Constants.DEFINED:
            enterDefined((Token) node);
            break;
        case Asn1Constants.BY:
            enterBy((Token) node);
            break;
        case Asn1Constants.OBJECT:
            enterObject((Token) node);
            break;
        case Asn1Constants.IDENTIFIER:
            enterIdentifier((Token) node);
            break;
        case Asn1Constants.INCLUDES:
            enterIncludes((Token) node);
            break;
        case Asn1Constants.MIN:
            enterMin((Token) node);
            break;
        case Asn1Constants.MAX:
            enterMax((Token) node);
            break;
        case Asn1Constants.SIZE:
            enterSize((Token) node);
            break;
        case Asn1Constants.WITH:
            enterWith((Token) node);
            break;
        case Asn1Constants.COMPONENT:
            enterComponent((Token) node);
            break;
        case Asn1Constants.COMPONENTS:
            enterComponents((Token) node);
            break;
        case Asn1Constants.PRESENT:
            enterPresent((Token) node);
            break;
        case Asn1Constants.ABSENT:
            enterAbsent((Token) node);
            break;
        case Asn1Constants.OPTIONAL:
            enterOptional((Token) node);
            break;
        case Asn1Constants.DEFAULT:
            enterDefault((Token) node);
            break;
        case Asn1Constants.TRUE:
            enterTrue((Token) node);
            break;
        case Asn1Constants.FALSE:
            enterFalse((Token) node);
            break;
        case Asn1Constants.PLUS_INFINITY:
            enterPlusInfinity((Token) node);
            break;
        case Asn1Constants.MINUS_INFINITY:
            enterMinusInfinity((Token) node);
            break;
        case Asn1Constants.MODULE_IDENTITY:
            enterModuleIdentity((Token) node);
            break;
        case Asn1Constants.OBJECT_IDENTITY:
            enterObjectIdentity((Token) node);
            break;
        case Asn1Constants.OBJECT_TYPE:
            enterObjectType((Token) node);
            break;
        case Asn1Constants.NOTIFICATION_TYPE:
            enterNotificationType((Token) node);
            break;
        case Asn1Constants.TRAP_TYPE:
            enterTrapType((Token) node);
            break;
        case Asn1Constants.TEXTUAL_CONVENTION:
            enterTextualConvention((Token) node);
            break;
        case Asn1Constants.OBJECT_GROUP:
            enterObjectGroup((Token) node);
            break;
        case Asn1Constants.NOTIFICATION_GROUP:
            enterNotificationGroup((Token) node);
            break;
        case Asn1Constants.MODULE_COMPLIANCE:
            enterModuleCompliance((Token) node);
            break;
        case Asn1Constants.AGENT_CAPABILITIES:
            enterAgentCapabilities((Token) node);
            break;
        case Asn1Constants.LAST_UPDATED:
            enterLastUpdated((Token) node);
            break;
        case Asn1Constants.ORGANIZATION:
            enterOrganization((Token) node);
            break;
        case Asn1Constants.CONTACT_INFO:
            enterContactInfo((Token) node);
            break;
        case Asn1Constants.DESCRIPTION:
            enterDescription((Token) node);
            break;
        case Asn1Constants.REVISION:
            enterRevision((Token) node);
            break;
        case Asn1Constants.STATUS:
            enterStatus((Token) node);
            break;
        case Asn1Constants.REFERENCE:
            enterReference((Token) node);
            break;
        case Asn1Constants.SYNTAX:
            enterSyntax((Token) node);
            break;
        case Asn1Constants.BITS:
            enterBits((Token) node);
            break;
        case Asn1Constants.UNITS:
            enterUnits((Token) node);
            break;
        case Asn1Constants.ACCESS:
            enterAccess((Token) node);
            break;
        case Asn1Constants.MAX_ACCESS:
            enterMaxAccess((Token) node);
            break;
        case Asn1Constants.MIN_ACCESS:
            enterMinAccess((Token) node);
            break;
        case Asn1Constants.INDEX:
            enterIndex((Token) node);
            break;
        case Asn1Constants.AUGMENTS:
            enterAugments((Token) node);
            break;
        case Asn1Constants.IMPLIED:
            enterImplied((Token) node);
            break;
        case Asn1Constants.DEFVAL:
            enterDefval((Token) node);
            break;
        case Asn1Constants.OBJECTS:
            enterObjects((Token) node);
            break;
        case Asn1Constants.ENTERPRISE:
            enterEnterprise((Token) node);
            break;
        case Asn1Constants.VARIABLES:
            enterVariables((Token) node);
            break;
        case Asn1Constants.DISPLAY_HINT:
            enterDisplayHint((Token) node);
            break;
        case Asn1Constants.NOTIFICATIONS:
            enterNotifications((Token) node);
            break;
        case Asn1Constants.MODULE:
            enterModule((Token) node);
            break;
        case Asn1Constants.MANDATORY_GROUPS:
            enterMandatoryGroups((Token) node);
            break;
        case Asn1Constants.GROUP:
            enterGroup((Token) node);
            break;
        case Asn1Constants.WRITE_SYNTAX:
            enterWriteSyntax((Token) node);
            break;
        case Asn1Constants.PRODUCT_RELEASE:
            enterProductRelease((Token) node);
            break;
        case Asn1Constants.SUPPORTS:
            enterSupports((Token) node);
            break;
        case Asn1Constants.VARIATION:
            enterVariation((Token) node);
            break;
        case Asn1Constants.CREATION_REQUIRES:
            enterCreationRequires((Token) node);
            break;
        case Asn1Constants.BINARY_STRING:
            enterBinaryString((Token) node);
            break;
        case Asn1Constants.HEXADECIMAL_STRING:
            enterHexadecimalString((Token) node);
            break;
        case Asn1Constants.QUOTED_STRING:
            enterQuotedString((Token) node);
            break;
        case Asn1Constants.IDENTIFIER_STRING:
            enterIdentifierString((Token) node);
            break;
        case Asn1Constants.NUMBER_STRING:
            enterNumberString((Token) node);
            break;
        case Asn1Constants.MODULE_DEFINITION:
            enterModuleDefinition((Production) node);
            break;
        case Asn1Constants.MODULE_IDENTIFIER:
            enterModuleIdentifier((Production) node);
            break;
        case Asn1Constants.MODULE_REFERENCE:
            enterModuleReference((Production) node);
            break;
        case Asn1Constants.TAG_DEFAULT:
            enterTagDefault((Production) node);
            break;
        case Asn1Constants.MODULE_BODY:
            enterModuleBody((Production) node);
            break;
        case Asn1Constants.EXPORT_LIST:
            enterExportList((Production) node);
            break;
        case Asn1Constants.IMPORT_LIST:
            enterImportList((Production) node);
            break;
        case Asn1Constants.SYMBOLS_FROM_MODULE:
            enterSymbolsFromModule((Production) node);
            break;
        case Asn1Constants.SYMBOL_LIST:
            enterSymbolList((Production) node);
            break;
        case Asn1Constants.SYMBOL:
            enterSymbol((Production) node);
            break;
        case Asn1Constants.ASSIGNMENT_LIST:
            enterAssignmentList((Production) node);
            break;
        case Asn1Constants.ASSIGNMENT:
            enterAssignment((Production) node);
            break;
        case Asn1Constants.MACRO_DEFINITION:
            enterMacroDefinition((Production) node);
            break;
        case Asn1Constants.MACRO_REFERENCE:
            enterMacroReference((Production) node);
            break;
        case Asn1Constants.MACRO_BODY:
            enterMacroBody((Production) node);
            break;
        case Asn1Constants.MACRO_BODY_ELEMENT:
            enterMacroBodyElement((Production) node);
            break;
        case Asn1Constants.TYPE_ASSIGNMENT:
            enterTypeAssignment((Production) node);
            break;
        case Asn1Constants.TYPE:
            enterType((Production) node);
            break;
        case Asn1Constants.DEFINED_TYPE:
            enterDefinedType((Production) node);
            break;
        case Asn1Constants.BUILTIN_TYPE:
            enterBuiltinType((Production) node);
            break;
        case Asn1Constants.NULL_TYPE:
            enterNullType((Production) node);
            break;
        case Asn1Constants.BOOLEAN_TYPE:
            enterBooleanType((Production) node);
            break;
        case Asn1Constants.REAL_TYPE:
            enterRealType((Production) node);
            break;
        case Asn1Constants.INTEGER_TYPE:
            enterIntegerType((Production) node);
            break;
        case Asn1Constants.OBJECT_IDENTIFIER_TYPE:
            enterObjectIdentifierType((Production) node);
            break;
        case Asn1Constants.STRING_TYPE:
            enterStringType((Production) node);
            break;
        case Asn1Constants.BIT_STRING_TYPE:
            enterBitStringType((Production) node);
            break;
        case Asn1Constants.BITS_TYPE:
            enterBitsType((Production) node);
            break;
        case Asn1Constants.SEQUENCE_TYPE:
            enterSequenceType((Production) node);
            break;
        case Asn1Constants.SEQUENCE_OF_TYPE:
            enterSequenceOfType((Production) node);
            break;
        case Asn1Constants.SET_TYPE:
            enterSetType((Production) node);
            break;
        case Asn1Constants.SET_OF_TYPE:
            enterSetOfType((Production) node);
            break;
        case Asn1Constants.CHOICE_TYPE:
            enterChoiceType((Production) node);
            break;
        case Asn1Constants.ENUMERATED_TYPE:
            enterEnumeratedType((Production) node);
            break;
        case Asn1Constants.SELECTION_TYPE:
            enterSelectionType((Production) node);
            break;
        case Asn1Constants.TAGGED_TYPE:
            enterTaggedType((Production) node);
            break;
        case Asn1Constants.TAG:
            enterTag((Production) node);
            break;
        case Asn1Constants.CLASS:
            enterClass((Production) node);
            break;
        case Asn1Constants.EXPLICIT_OR_IMPLICIT_TAG:
            enterExplicitOrImplicitTag((Production) node);
            break;
        case Asn1Constants.ANY_TYPE:
            enterAnyType((Production) node);
            break;
        case Asn1Constants.ELEMENT_TYPE_LIST:
            enterElementTypeList((Production) node);
            break;
        case Asn1Constants.ELEMENT_TYPE:
            enterElementType((Production) node);
            break;
        case Asn1Constants.OPTIONAL_OR_DEFAULT_ELEMENT:
            enterOptionalOrDefaultElement((Production) node);
            break;
        case Asn1Constants.VALUE_OR_CONSTRAINT_LIST:
            enterValueOrConstraintList((Production) node);
            break;
        case Asn1Constants.NAMED_NUMBER_LIST:
            enterNamedNumberList((Production) node);
            break;
        case Asn1Constants.NAMED_NUMBER:
            enterNamedNumber((Production) node);
            break;
        case Asn1Constants.NUMBER:
            enterNumber((Production) node);
            break;
        case Asn1Constants.CONSTRAINT_LIST:
            enterConstraintList((Production) node);
            break;
        case Asn1Constants.CONSTRAINT:
            enterConstraint((Production) node);
            break;
        case Asn1Constants.VALUE_CONSTRAINT_LIST:
            enterValueConstraintList((Production) node);
            break;
        case Asn1Constants.VALUE_CONSTRAINT:
            enterValueConstraint((Production) node);
            break;
        case Asn1Constants.VALUE_RANGE:
            enterValueRange((Production) node);
            break;
        case Asn1Constants.LOWER_END_POINT:
            enterLowerEndPoint((Production) node);
            break;
        case Asn1Constants.UPPER_END_POINT:
            enterUpperEndPoint((Production) node);
            break;
        case Asn1Constants.SIZE_CONSTRAINT:
            enterSizeConstraint((Production) node);
            break;
        case Asn1Constants.ALPHABET_CONSTRAINT:
            enterAlphabetConstraint((Production) node);
            break;
        case Asn1Constants.CONTAINED_TYPE_CONSTRAINT:
            enterContainedTypeConstraint((Production) node);
            break;
        case Asn1Constants.INNER_TYPE_CONSTRAINT:
            enterInnerTypeConstraint((Production) node);
            break;
        case Asn1Constants.COMPONENTS_LIST:
            enterComponentsList((Production) node);
            break;
        case Asn1Constants.COMPONENTS_LIST_TAIL:
            enterComponentsListTail((Production) node);
            break;
        case Asn1Constants.COMPONENT_CONSTRAINT:
            enterComponentConstraint((Production) node);
            break;
        case Asn1Constants.COMPONENT_VALUE_PRESENCE:
            enterComponentValuePresence((Production) node);
            break;
        case Asn1Constants.COMPONENT_PRESENCE:
            enterComponentPresence((Production) node);
            break;
        case Asn1Constants.VALUE_ASSIGNMENT:
            enterValueAssignment((Production) node);
            break;
        case Asn1Constants.VALUE:
            enterValue((Production) node);
            break;
        case Asn1Constants.DEFINED_VALUE:
            enterDefinedValue((Production) node);
            break;
        case Asn1Constants.BUILTIN_VALUE:
            enterBuiltinValue((Production) node);
            break;
        case Asn1Constants.NULL_VALUE:
            enterNullValue((Production) node);
            break;
        case Asn1Constants.BOOLEAN_VALUE:
            enterBooleanValue((Production) node);
            break;
        case Asn1Constants.SPECIAL_REAL_VALUE:
            enterSpecialRealValue((Production) node);
            break;
        case Asn1Constants.NUMBER_VALUE:
            enterNumberValue((Production) node);
            break;
        case Asn1Constants.BINARY_VALUE:
            enterBinaryValue((Production) node);
            break;
        case Asn1Constants.HEXADECIMAL_VALUE:
            enterHexadecimalValue((Production) node);
            break;
        case Asn1Constants.STRING_VALUE:
            enterStringValue((Production) node);
            break;
        case Asn1Constants.BIT_OR_OBJECT_IDENTIFIER_VALUE:
            enterBitOrObjectIdentifierValue((Production) node);
            break;
        case Asn1Constants.BIT_VALUE:
            enterBitValue((Production) node);
            break;
        case Asn1Constants.OBJECT_IDENTIFIER_VALUE:
            enterObjectIdentifierValue((Production) node);
            break;
        case Asn1Constants.NAME_VALUE_LIST:
            enterNameValueList((Production) node);
            break;
        case Asn1Constants.NAME_VALUE_COMPONENT:
            enterNameValueComponent((Production) node);
            break;
        case Asn1Constants.NAME_OR_NUMBER:
            enterNameOrNumber((Production) node);
            break;
        case Asn1Constants.NAME_AND_NUMBER:
            enterNameAndNumber((Production) node);
            break;
        case Asn1Constants.DEFINED_MACRO_TYPE:
            enterDefinedMacroType((Production) node);
            break;
        case Asn1Constants.DEFINED_MACRO_NAME:
            enterDefinedMacroName((Production) node);
            break;
        case Asn1Constants.SNMP_MODULE_IDENTITY_MACRO_TYPE:
            enterSnmpModuleIdentityMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_OBJECT_IDENTITY_MACRO_TYPE:
            enterSnmpObjectIdentityMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_OBJECT_TYPE_MACRO_TYPE:
            enterSnmpObjectTypeMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_NOTIFICATION_TYPE_MACRO_TYPE:
            enterSnmpNotificationTypeMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_TRAP_TYPE_MACRO_TYPE:
            enterSnmpTrapTypeMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_TEXTUAL_CONVENTION_MACRO_TYPE:
            enterSnmpTextualConventionMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_OBJECT_GROUP_MACRO_TYPE:
            enterSnmpObjectGroupMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_NOTIFICATION_GROUP_MACRO_TYPE:
            enterSnmpNotificationGroupMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_MODULE_COMPLIANCE_MACRO_TYPE:
            enterSnmpModuleComplianceMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_AGENT_CAPABILITIES_MACRO_TYPE:
            enterSnmpAgentCapabilitiesMacroType((Production) node);
            break;
        case Asn1Constants.SNMP_UPDATE_PART:
            enterSnmpUpdatePart((Production) node);
            break;
        case Asn1Constants.SNMP_ORGANIZATION_PART:
            enterSnmpOrganizationPart((Production) node);
            break;
        case Asn1Constants.SNMP_CONTACT_PART:
            enterSnmpContactPart((Production) node);
            break;
        case Asn1Constants.SNMP_DESCR_PART:
            enterSnmpDescrPart((Production) node);
            break;
        case Asn1Constants.SNMP_REVISION_PART:
            enterSnmpRevisionPart((Production) node);
            break;
        case Asn1Constants.SNMP_STATUS_PART:
            enterSnmpStatusPart((Production) node);
            break;
        case Asn1Constants.SNMP_REFER_PART:
            enterSnmpReferPart((Production) node);
            break;
        case Asn1Constants.SNMP_SYNTAX_PART:
            enterSnmpSyntaxPart((Production) node);
            break;
        case Asn1Constants.SNMP_UNITS_PART:
            enterSnmpUnitsPart((Production) node);
            break;
        case Asn1Constants.SNMP_ACCESS_PART:
            enterSnmpAccessPart((Production) node);
            break;
        case Asn1Constants.SNMP_INDEX_PART:
            enterSnmpIndexPart((Production) node);
            break;
        case Asn1Constants.INDEX_VALUE_LIST:
            enterIndexValueList((Production) node);
            break;
        case Asn1Constants.INDEX_VALUE:
            enterIndexValue((Production) node);
            break;
        case Asn1Constants.INDEX_TYPE:
            enterIndexType((Production) node);
            break;
        case Asn1Constants.SNMP_DEF_VAL_PART:
            enterSnmpDefValPart((Production) node);
            break;
        case Asn1Constants.SNMP_OBJECTS_PART:
            enterSnmpObjectsPart((Production) node);
            break;
        case Asn1Constants.VALUE_LIST:
            enterValueList((Production) node);
            break;
        case Asn1Constants.SNMP_ENTERPRISE_PART:
            enterSnmpEnterprisePart((Production) node);
            break;
        case Asn1Constants.SNMP_VAR_PART:
            enterSnmpVarPart((Production) node);
            break;
        case Asn1Constants.SNMP_DISPLAY_PART:
            enterSnmpDisplayPart((Production) node);
            break;
        case Asn1Constants.SNMP_NOTIFICATIONS_PART:
            enterSnmpNotificationsPart((Production) node);
            break;
        case Asn1Constants.SNMP_MODULE_PART:
            enterSnmpModulePart((Production) node);
            break;
        case Asn1Constants.SNMP_MODULE_IMPORT:
            enterSnmpModuleImport((Production) node);
            break;
        case Asn1Constants.SNMP_MANDATORY_PART:
            enterSnmpMandatoryPart((Production) node);
            break;
        case Asn1Constants.SNMP_COMPLIANCE_PART:
            enterSnmpCompliancePart((Production) node);
            break;
        case Asn1Constants.COMPLIANCE_GROUP:
            enterComplianceGroup((Production) node);
            break;
        case Asn1Constants.COMPLIANCE_OBJECT:
            enterComplianceObject((Production) node);
            break;
        case Asn1Constants.SNMP_WRITE_SYNTAX_PART:
            enterSnmpWriteSyntaxPart((Production) node);
            break;
        case Asn1Constants.SNMP_PRODUCT_RELEASE_PART:
            enterSnmpProductReleasePart((Production) node);
            break;
        case Asn1Constants.SNMP_MODULE_SUPPORT_PART:
            enterSnmpModuleSupportPart((Production) node);
            break;
        case Asn1Constants.SNMP_VARIATION_PART:
            enterSnmpVariationPart((Production) node);
            break;
        case Asn1Constants.SNMP_CREATION_PART:
            enterSnmpCreationPart((Production) node);
            break;
        }
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exit(Node node) throws ParseException {
        switch (node.getId()) {
        case Asn1Constants.DOT:
            return exitDot((Token) node);
        case Asn1Constants.DOUBLE_DOT:
            return exitDoubleDot((Token) node);
        case Asn1Constants.TRIPLE_DOT:
            return exitTripleDot((Token) node);
        case Asn1Constants.COMMA:
            return exitComma((Token) node);
        case Asn1Constants.SEMI_COLON:
            return exitSemiColon((Token) node);
        case Asn1Constants.LEFT_PAREN:
            return exitLeftParen((Token) node);
        case Asn1Constants.RIGHT_PAREN:
            return exitRightParen((Token) node);
        case Asn1Constants.LEFT_BRACE:
            return exitLeftBrace((Token) node);
        case Asn1Constants.RIGHT_BRACE:
            return exitRightBrace((Token) node);
        case Asn1Constants.LEFT_BRACKET:
            return exitLeftBracket((Token) node);
        case Asn1Constants.RIGHT_BRACKET:
            return exitRightBracket((Token) node);
        case Asn1Constants.MINUS:
            return exitMinus((Token) node);
        case Asn1Constants.LESS_THAN:
            return exitLessThan((Token) node);
        case Asn1Constants.VERTICAL_BAR:
            return exitVerticalBar((Token) node);
        case Asn1Constants.DEFINITION:
            return exitDefinition((Token) node);
        case Asn1Constants.DEFINITIONS:
            return exitDefinitions((Token) node);
        case Asn1Constants.EXPLICIT:
            return exitExplicit((Token) node);
        case Asn1Constants.IMPLICIT:
            return exitImplicit((Token) node);
        case Asn1Constants.TAGS:
            return exitTags((Token) node);
        case Asn1Constants.BEGIN:
            return exitBegin((Token) node);
        case Asn1Constants.END:
            return exitEnd((Token) node);
        case Asn1Constants.EXPORTS:
            return exitExports((Token) node);
        case Asn1Constants.IMPORTS:
            return exitImports((Token) node);
        case Asn1Constants.FROM:
            return exitFrom((Token) node);
        case Asn1Constants.MACRO:
            return exitMacro((Token) node);
        case Asn1Constants.INTEGER:
            return exitInteger((Token) node);
        case Asn1Constants.REAL:
            return exitReal((Token) node);
        case Asn1Constants.BOOLEAN:
            return exitBoolean((Token) node);
        case Asn1Constants.NULL:
            return exitNull((Token) node);
        case Asn1Constants.BIT:
            return exitBit((Token) node);
        case Asn1Constants.OCTET:
            return exitOctet((Token) node);
        case Asn1Constants.STRING:
            return exitString((Token) node);
        case Asn1Constants.ENUMERATED:
            return exitEnumerated((Token) node);
        case Asn1Constants.SEQUENCE:
            return exitSequence((Token) node);
        case Asn1Constants.SET:
            return exitSet((Token) node);
        case Asn1Constants.OF:
            return exitOf((Token) node);
        case Asn1Constants.CHOICE:
            return exitChoice((Token) node);
        case Asn1Constants.UNIVERSAL:
            return exitUniversal((Token) node);
        case Asn1Constants.APPLICATION:
            return exitApplication((Token) node);
        case Asn1Constants.PRIVATE:
            return exitPrivate((Token) node);
        case Asn1Constants.ANY:
            return exitAny((Token) node);
        case Asn1Constants.DEFINED:
            return exitDefined((Token) node);
        case Asn1Constants.BY:
            return exitBy((Token) node);
        case Asn1Constants.OBJECT:
            return exitObject((Token) node);
        case Asn1Constants.IDENTIFIER:
            return exitIdentifier((Token) node);
        case Asn1Constants.INCLUDES:
            return exitIncludes((Token) node);
        case Asn1Constants.MIN:
            return exitMin((Token) node);
        case Asn1Constants.MAX:
            return exitMax((Token) node);
        case Asn1Constants.SIZE:
            return exitSize((Token) node);
        case Asn1Constants.WITH:
            return exitWith((Token) node);
        case Asn1Constants.COMPONENT:
            return exitComponent((Token) node);
        case Asn1Constants.COMPONENTS:
            return exitComponents((Token) node);
        case Asn1Constants.PRESENT:
            return exitPresent((Token) node);
        case Asn1Constants.ABSENT:
            return exitAbsent((Token) node);
        case Asn1Constants.OPTIONAL:
            return exitOptional((Token) node);
        case Asn1Constants.DEFAULT:
            return exitDefault((Token) node);
        case Asn1Constants.TRUE:
            return exitTrue((Token) node);
        case Asn1Constants.FALSE:
            return exitFalse((Token) node);
        case Asn1Constants.PLUS_INFINITY:
            return exitPlusInfinity((Token) node);
        case Asn1Constants.MINUS_INFINITY:
            return exitMinusInfinity((Token) node);
        case Asn1Constants.MODULE_IDENTITY:
            return exitModuleIdentity((Token) node);
        case Asn1Constants.OBJECT_IDENTITY:
            return exitObjectIdentity((Token) node);
        case Asn1Constants.OBJECT_TYPE:
            return exitObjectType((Token) node);
        case Asn1Constants.NOTIFICATION_TYPE:
            return exitNotificationType((Token) node);
        case Asn1Constants.TRAP_TYPE:
            return exitTrapType((Token) node);
        case Asn1Constants.TEXTUAL_CONVENTION:
            return exitTextualConvention((Token) node);
        case Asn1Constants.OBJECT_GROUP:
            return exitObjectGroup((Token) node);
        case Asn1Constants.NOTIFICATION_GROUP:
            return exitNotificationGroup((Token) node);
        case Asn1Constants.MODULE_COMPLIANCE:
            return exitModuleCompliance((Token) node);
        case Asn1Constants.AGENT_CAPABILITIES:
            return exitAgentCapabilities((Token) node);
        case Asn1Constants.LAST_UPDATED:
            return exitLastUpdated((Token) node);
        case Asn1Constants.ORGANIZATION:
            return exitOrganization((Token) node);
        case Asn1Constants.CONTACT_INFO:
            return exitContactInfo((Token) node);
        case Asn1Constants.DESCRIPTION:
            return exitDescription((Token) node);
        case Asn1Constants.REVISION:
            return exitRevision((Token) node);
        case Asn1Constants.STATUS:
            return exitStatus((Token) node);
        case Asn1Constants.REFERENCE:
            return exitReference((Token) node);
        case Asn1Constants.SYNTAX:
            return exitSyntax((Token) node);
        case Asn1Constants.BITS:
            return exitBits((Token) node);
        case Asn1Constants.UNITS:
            return exitUnits((Token) node);
        case Asn1Constants.ACCESS:
            return exitAccess((Token) node);
        case Asn1Constants.MAX_ACCESS:
            return exitMaxAccess((Token) node);
        case Asn1Constants.MIN_ACCESS:
            return exitMinAccess((Token) node);
        case Asn1Constants.INDEX:
            return exitIndex((Token) node);
        case Asn1Constants.AUGMENTS:
            return exitAugments((Token) node);
        case Asn1Constants.IMPLIED:
            return exitImplied((Token) node);
        case Asn1Constants.DEFVAL:
            return exitDefval((Token) node);
        case Asn1Constants.OBJECTS:
            return exitObjects((Token) node);
        case Asn1Constants.ENTERPRISE:
            return exitEnterprise((Token) node);
        case Asn1Constants.VARIABLES:
            return exitVariables((Token) node);
        case Asn1Constants.DISPLAY_HINT:
            return exitDisplayHint((Token) node);
        case Asn1Constants.NOTIFICATIONS:
            return exitNotifications((Token) node);
        case Asn1Constants.MODULE:
            return exitModule((Token) node);
        case Asn1Constants.MANDATORY_GROUPS:
            return exitMandatoryGroups((Token) node);
        case Asn1Constants.GROUP:
            return exitGroup((Token) node);
        case Asn1Constants.WRITE_SYNTAX:
            return exitWriteSyntax((Token) node);
        case Asn1Constants.PRODUCT_RELEASE:
            return exitProductRelease((Token) node);
        case Asn1Constants.SUPPORTS:
            return exitSupports((Token) node);
        case Asn1Constants.VARIATION:
            return exitVariation((Token) node);
        case Asn1Constants.CREATION_REQUIRES:
            return exitCreationRequires((Token) node);
        case Asn1Constants.BINARY_STRING:
            return exitBinaryString((Token) node);
        case Asn1Constants.HEXADECIMAL_STRING:
            return exitHexadecimalString((Token) node);
        case Asn1Constants.QUOTED_STRING:
            return exitQuotedString((Token) node);
        case Asn1Constants.IDENTIFIER_STRING:
            return exitIdentifierString((Token) node);
        case Asn1Constants.NUMBER_STRING:
            return exitNumberString((Token) node);
        case Asn1Constants.MODULE_DEFINITION:
            return exitModuleDefinition((Production) node);
        case Asn1Constants.MODULE_IDENTIFIER:
            return exitModuleIdentifier((Production) node);
        case Asn1Constants.MODULE_REFERENCE:
            return exitModuleReference((Production) node);
        case Asn1Constants.TAG_DEFAULT:
            return exitTagDefault((Production) node);
        case Asn1Constants.MODULE_BODY:
            return exitModuleBody((Production) node);
        case Asn1Constants.EXPORT_LIST:
            return exitExportList((Production) node);
        case Asn1Constants.IMPORT_LIST:
            return exitImportList((Production) node);
        case Asn1Constants.SYMBOLS_FROM_MODULE:
            return exitSymbolsFromModule((Production) node);
        case Asn1Constants.SYMBOL_LIST:
            return exitSymbolList((Production) node);
        case Asn1Constants.SYMBOL:
            return exitSymbol((Production) node);
        case Asn1Constants.ASSIGNMENT_LIST:
            return exitAssignmentList((Production) node);
        case Asn1Constants.ASSIGNMENT:
            return exitAssignment((Production) node);
        case Asn1Constants.MACRO_DEFINITION:
            return exitMacroDefinition((Production) node);
        case Asn1Constants.MACRO_REFERENCE:
            return exitMacroReference((Production) node);
        case Asn1Constants.MACRO_BODY:
            return exitMacroBody((Production) node);
        case Asn1Constants.MACRO_BODY_ELEMENT:
            return exitMacroBodyElement((Production) node);
        case Asn1Constants.TYPE_ASSIGNMENT:
            return exitTypeAssignment((Production) node);
        case Asn1Constants.TYPE:
            return exitType((Production) node);
        case Asn1Constants.DEFINED_TYPE:
            return exitDefinedType((Production) node);
        case Asn1Constants.BUILTIN_TYPE:
            return exitBuiltinType((Production) node);
        case Asn1Constants.NULL_TYPE:
            return exitNullType((Production) node);
        case Asn1Constants.BOOLEAN_TYPE:
            return exitBooleanType((Production) node);
        case Asn1Constants.REAL_TYPE:
            return exitRealType((Production) node);
        case Asn1Constants.INTEGER_TYPE:
            return exitIntegerType((Production) node);
        case Asn1Constants.OBJECT_IDENTIFIER_TYPE:
            return exitObjectIdentifierType((Production) node);
        case Asn1Constants.STRING_TYPE:
            return exitStringType((Production) node);
        case Asn1Constants.BIT_STRING_TYPE:
            return exitBitStringType((Production) node);
        case Asn1Constants.BITS_TYPE:
            return exitBitsType((Production) node);
        case Asn1Constants.SEQUENCE_TYPE:
            return exitSequenceType((Production) node);
        case Asn1Constants.SEQUENCE_OF_TYPE:
            return exitSequenceOfType((Production) node);
        case Asn1Constants.SET_TYPE:
            return exitSetType((Production) node);
        case Asn1Constants.SET_OF_TYPE:
            return exitSetOfType((Production) node);
        case Asn1Constants.CHOICE_TYPE:
            return exitChoiceType((Production) node);
        case Asn1Constants.ENUMERATED_TYPE:
            return exitEnumeratedType((Production) node);
        case Asn1Constants.SELECTION_TYPE:
            return exitSelectionType((Production) node);
        case Asn1Constants.TAGGED_TYPE:
            return exitTaggedType((Production) node);
        case Asn1Constants.TAG:
            return exitTag((Production) node);
        case Asn1Constants.CLASS:
            return exitClass((Production) node);
        case Asn1Constants.EXPLICIT_OR_IMPLICIT_TAG:
            return exitExplicitOrImplicitTag((Production) node);
        case Asn1Constants.ANY_TYPE:
            return exitAnyType((Production) node);
        case Asn1Constants.ELEMENT_TYPE_LIST:
            return exitElementTypeList((Production) node);
        case Asn1Constants.ELEMENT_TYPE:
            return exitElementType((Production) node);
        case Asn1Constants.OPTIONAL_OR_DEFAULT_ELEMENT:
            return exitOptionalOrDefaultElement((Production) node);
        case Asn1Constants.VALUE_OR_CONSTRAINT_LIST:
            return exitValueOrConstraintList((Production) node);
        case Asn1Constants.NAMED_NUMBER_LIST:
            return exitNamedNumberList((Production) node);
        case Asn1Constants.NAMED_NUMBER:
            return exitNamedNumber((Production) node);
        case Asn1Constants.NUMBER:
            return exitNumber((Production) node);
        case Asn1Constants.CONSTRAINT_LIST:
            return exitConstraintList((Production) node);
        case Asn1Constants.CONSTRAINT:
            return exitConstraint((Production) node);
        case Asn1Constants.VALUE_CONSTRAINT_LIST:
            return exitValueConstraintList((Production) node);
        case Asn1Constants.VALUE_CONSTRAINT:
            return exitValueConstraint((Production) node);
        case Asn1Constants.VALUE_RANGE:
            return exitValueRange((Production) node);
        case Asn1Constants.LOWER_END_POINT:
            return exitLowerEndPoint((Production) node);
        case Asn1Constants.UPPER_END_POINT:
            return exitUpperEndPoint((Production) node);
        case Asn1Constants.SIZE_CONSTRAINT:
            return exitSizeConstraint((Production) node);
        case Asn1Constants.ALPHABET_CONSTRAINT:
            return exitAlphabetConstraint((Production) node);
        case Asn1Constants.CONTAINED_TYPE_CONSTRAINT:
            return exitContainedTypeConstraint((Production) node);
        case Asn1Constants.INNER_TYPE_CONSTRAINT:
            return exitInnerTypeConstraint((Production) node);
        case Asn1Constants.COMPONENTS_LIST:
            return exitComponentsList((Production) node);
        case Asn1Constants.COMPONENTS_LIST_TAIL:
            return exitComponentsListTail((Production) node);
        case Asn1Constants.COMPONENT_CONSTRAINT:
            return exitComponentConstraint((Production) node);
        case Asn1Constants.COMPONENT_VALUE_PRESENCE:
            return exitComponentValuePresence((Production) node);
        case Asn1Constants.COMPONENT_PRESENCE:
            return exitComponentPresence((Production) node);
        case Asn1Constants.VALUE_ASSIGNMENT:
            return exitValueAssignment((Production) node);
        case Asn1Constants.VALUE:
            return exitValue((Production) node);
        case Asn1Constants.DEFINED_VALUE:
            return exitDefinedValue((Production) node);
        case Asn1Constants.BUILTIN_VALUE:
            return exitBuiltinValue((Production) node);
        case Asn1Constants.NULL_VALUE:
            return exitNullValue((Production) node);
        case Asn1Constants.BOOLEAN_VALUE:
            return exitBooleanValue((Production) node);
        case Asn1Constants.SPECIAL_REAL_VALUE:
            return exitSpecialRealValue((Production) node);
        case Asn1Constants.NUMBER_VALUE:
            return exitNumberValue((Production) node);
        case Asn1Constants.BINARY_VALUE:
            return exitBinaryValue((Production) node);
        case Asn1Constants.HEXADECIMAL_VALUE:
            return exitHexadecimalValue((Production) node);
        case Asn1Constants.STRING_VALUE:
            return exitStringValue((Production) node);
        case Asn1Constants.BIT_OR_OBJECT_IDENTIFIER_VALUE:
            return exitBitOrObjectIdentifierValue((Production) node);
        case Asn1Constants.BIT_VALUE:
            return exitBitValue((Production) node);
        case Asn1Constants.OBJECT_IDENTIFIER_VALUE:
            return exitObjectIdentifierValue((Production) node);
        case Asn1Constants.NAME_VALUE_LIST:
            return exitNameValueList((Production) node);
        case Asn1Constants.NAME_VALUE_COMPONENT:
            return exitNameValueComponent((Production) node);
        case Asn1Constants.NAME_OR_NUMBER:
            return exitNameOrNumber((Production) node);
        case Asn1Constants.NAME_AND_NUMBER:
            return exitNameAndNumber((Production) node);
        case Asn1Constants.DEFINED_MACRO_TYPE:
            return exitDefinedMacroType((Production) node);
        case Asn1Constants.DEFINED_MACRO_NAME:
            return exitDefinedMacroName((Production) node);
        case Asn1Constants.SNMP_MODULE_IDENTITY_MACRO_TYPE:
            return exitSnmpModuleIdentityMacroType((Production) node);
        case Asn1Constants.SNMP_OBJECT_IDENTITY_MACRO_TYPE:
            return exitSnmpObjectIdentityMacroType((Production) node);
        case Asn1Constants.SNMP_OBJECT_TYPE_MACRO_TYPE:
            return exitSnmpObjectTypeMacroType((Production) node);
        case Asn1Constants.SNMP_NOTIFICATION_TYPE_MACRO_TYPE:
            return exitSnmpNotificationTypeMacroType((Production) node);
        case Asn1Constants.SNMP_TRAP_TYPE_MACRO_TYPE:
            return exitSnmpTrapTypeMacroType((Production) node);
        case Asn1Constants.SNMP_TEXTUAL_CONVENTION_MACRO_TYPE:
            return exitSnmpTextualConventionMacroType((Production) node);
        case Asn1Constants.SNMP_OBJECT_GROUP_MACRO_TYPE:
            return exitSnmpObjectGroupMacroType((Production) node);
        case Asn1Constants.SNMP_NOTIFICATION_GROUP_MACRO_TYPE:
            return exitSnmpNotificationGroupMacroType((Production) node);
        case Asn1Constants.SNMP_MODULE_COMPLIANCE_MACRO_TYPE:
            return exitSnmpModuleComplianceMacroType((Production) node);
        case Asn1Constants.SNMP_AGENT_CAPABILITIES_MACRO_TYPE:
            return exitSnmpAgentCapabilitiesMacroType((Production) node);
        case Asn1Constants.SNMP_UPDATE_PART:
            return exitSnmpUpdatePart((Production) node);
        case Asn1Constants.SNMP_ORGANIZATION_PART:
            return exitSnmpOrganizationPart((Production) node);
        case Asn1Constants.SNMP_CONTACT_PART:
            return exitSnmpContactPart((Production) node);
        case Asn1Constants.SNMP_DESCR_PART:
            return exitSnmpDescrPart((Production) node);
        case Asn1Constants.SNMP_REVISION_PART:
            return exitSnmpRevisionPart((Production) node);
        case Asn1Constants.SNMP_STATUS_PART:
            return exitSnmpStatusPart((Production) node);
        case Asn1Constants.SNMP_REFER_PART:
            return exitSnmpReferPart((Production) node);
        case Asn1Constants.SNMP_SYNTAX_PART:
            return exitSnmpSyntaxPart((Production) node);
        case Asn1Constants.SNMP_UNITS_PART:
            return exitSnmpUnitsPart((Production) node);
        case Asn1Constants.SNMP_ACCESS_PART:
            return exitSnmpAccessPart((Production) node);
        case Asn1Constants.SNMP_INDEX_PART:
            return exitSnmpIndexPart((Production) node);
        case Asn1Constants.INDEX_VALUE_LIST:
            return exitIndexValueList((Production) node);
        case Asn1Constants.INDEX_VALUE:
            return exitIndexValue((Production) node);
        case Asn1Constants.INDEX_TYPE:
            return exitIndexType((Production) node);
        case Asn1Constants.SNMP_DEF_VAL_PART:
            return exitSnmpDefValPart((Production) node);
        case Asn1Constants.SNMP_OBJECTS_PART:
            return exitSnmpObjectsPart((Production) node);
        case Asn1Constants.VALUE_LIST:
            return exitValueList((Production) node);
        case Asn1Constants.SNMP_ENTERPRISE_PART:
            return exitSnmpEnterprisePart((Production) node);
        case Asn1Constants.SNMP_VAR_PART:
            return exitSnmpVarPart((Production) node);
        case Asn1Constants.SNMP_DISPLAY_PART:
            return exitSnmpDisplayPart((Production) node);
        case Asn1Constants.SNMP_NOTIFICATIONS_PART:
            return exitSnmpNotificationsPart((Production) node);
        case Asn1Constants.SNMP_MODULE_PART:
            return exitSnmpModulePart((Production) node);
        case Asn1Constants.SNMP_MODULE_IMPORT:
            return exitSnmpModuleImport((Production) node);
        case Asn1Constants.SNMP_MANDATORY_PART:
            return exitSnmpMandatoryPart((Production) node);
        case Asn1Constants.SNMP_COMPLIANCE_PART:
            return exitSnmpCompliancePart((Production) node);
        case Asn1Constants.COMPLIANCE_GROUP:
            return exitComplianceGroup((Production) node);
        case Asn1Constants.COMPLIANCE_OBJECT:
            return exitComplianceObject((Production) node);
        case Asn1Constants.SNMP_WRITE_SYNTAX_PART:
            return exitSnmpWriteSyntaxPart((Production) node);
        case Asn1Constants.SNMP_PRODUCT_RELEASE_PART:
            return exitSnmpProductReleasePart((Production) node);
        case Asn1Constants.SNMP_MODULE_SUPPORT_PART:
            return exitSnmpModuleSupportPart((Production) node);
        case Asn1Constants.SNMP_VARIATION_PART:
            return exitSnmpVariationPart((Production) node);
        case Asn1Constants.SNMP_CREATION_PART:
            return exitSnmpCreationPart((Production) node);
        }
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void child(Production node, Node child)
        throws ParseException {

        switch (node.getId()) {
        case Asn1Constants.MODULE_DEFINITION:
            childModuleDefinition(node, child);
            break;
        case Asn1Constants.MODULE_IDENTIFIER:
            childModuleIdentifier(node, child);
            break;
        case Asn1Constants.MODULE_REFERENCE:
            childModuleReference(node, child);
            break;
        case Asn1Constants.TAG_DEFAULT:
            childTagDefault(node, child);
            break;
        case Asn1Constants.MODULE_BODY:
            childModuleBody(node, child);
            break;
        case Asn1Constants.EXPORT_LIST:
            childExportList(node, child);
            break;
        case Asn1Constants.IMPORT_LIST:
            childImportList(node, child);
            break;
        case Asn1Constants.SYMBOLS_FROM_MODULE:
            childSymbolsFromModule(node, child);
            break;
        case Asn1Constants.SYMBOL_LIST:
            childSymbolList(node, child);
            break;
        case Asn1Constants.SYMBOL:
            childSymbol(node, child);
            break;
        case Asn1Constants.ASSIGNMENT_LIST:
            childAssignmentList(node, child);
            break;
        case Asn1Constants.ASSIGNMENT:
            childAssignment(node, child);
            break;
        case Asn1Constants.MACRO_DEFINITION:
            childMacroDefinition(node, child);
            break;
        case Asn1Constants.MACRO_REFERENCE:
            childMacroReference(node, child);
            break;
        case Asn1Constants.MACRO_BODY:
            childMacroBody(node, child);
            break;
        case Asn1Constants.MACRO_BODY_ELEMENT:
            childMacroBodyElement(node, child);
            break;
        case Asn1Constants.TYPE_ASSIGNMENT:
            childTypeAssignment(node, child);
            break;
        case Asn1Constants.TYPE:
            childType(node, child);
            break;
        case Asn1Constants.DEFINED_TYPE:
            childDefinedType(node, child);
            break;
        case Asn1Constants.BUILTIN_TYPE:
            childBuiltinType(node, child);
            break;
        case Asn1Constants.NULL_TYPE:
            childNullType(node, child);
            break;
        case Asn1Constants.BOOLEAN_TYPE:
            childBooleanType(node, child);
            break;
        case Asn1Constants.REAL_TYPE:
            childRealType(node, child);
            break;
        case Asn1Constants.INTEGER_TYPE:
            childIntegerType(node, child);
            break;
        case Asn1Constants.OBJECT_IDENTIFIER_TYPE:
            childObjectIdentifierType(node, child);
            break;
        case Asn1Constants.STRING_TYPE:
            childStringType(node, child);
            break;
        case Asn1Constants.BIT_STRING_TYPE:
            childBitStringType(node, child);
            break;
        case Asn1Constants.BITS_TYPE:
            childBitsType(node, child);
            break;
        case Asn1Constants.SEQUENCE_TYPE:
            childSequenceType(node, child);
            break;
        case Asn1Constants.SEQUENCE_OF_TYPE:
            childSequenceOfType(node, child);
            break;
        case Asn1Constants.SET_TYPE:
            childSetType(node, child);
            break;
        case Asn1Constants.SET_OF_TYPE:
            childSetOfType(node, child);
            break;
        case Asn1Constants.CHOICE_TYPE:
            childChoiceType(node, child);
            break;
        case Asn1Constants.ENUMERATED_TYPE:
            childEnumeratedType(node, child);
            break;
        case Asn1Constants.SELECTION_TYPE:
            childSelectionType(node, child);
            break;
        case Asn1Constants.TAGGED_TYPE:
            childTaggedType(node, child);
            break;
        case Asn1Constants.TAG:
            childTag(node, child);
            break;
        case Asn1Constants.CLASS:
            childClass(node, child);
            break;
        case Asn1Constants.EXPLICIT_OR_IMPLICIT_TAG:
            childExplicitOrImplicitTag(node, child);
            break;
        case Asn1Constants.ANY_TYPE:
            childAnyType(node, child);
            break;
        case Asn1Constants.ELEMENT_TYPE_LIST:
            childElementTypeList(node, child);
            break;
        case Asn1Constants.ELEMENT_TYPE:
            childElementType(node, child);
            break;
        case Asn1Constants.OPTIONAL_OR_DEFAULT_ELEMENT:
            childOptionalOrDefaultElement(node, child);
            break;
        case Asn1Constants.VALUE_OR_CONSTRAINT_LIST:
            childValueOrConstraintList(node, child);
            break;
        case Asn1Constants.NAMED_NUMBER_LIST:
            childNamedNumberList(node, child);
            break;
        case Asn1Constants.NAMED_NUMBER:
            childNamedNumber(node, child);
            break;
        case Asn1Constants.NUMBER:
            childNumber(node, child);
            break;
        case Asn1Constants.CONSTRAINT_LIST:
            childConstraintList(node, child);
            break;
        case Asn1Constants.CONSTRAINT:
            childConstraint(node, child);
            break;
        case Asn1Constants.VALUE_CONSTRAINT_LIST:
            childValueConstraintList(node, child);
            break;
        case Asn1Constants.VALUE_CONSTRAINT:
            childValueConstraint(node, child);
            break;
        case Asn1Constants.VALUE_RANGE:
            childValueRange(node, child);
            break;
        case Asn1Constants.LOWER_END_POINT:
            childLowerEndPoint(node, child);
            break;
        case Asn1Constants.UPPER_END_POINT:
            childUpperEndPoint(node, child);
            break;
        case Asn1Constants.SIZE_CONSTRAINT:
            childSizeConstraint(node, child);
            break;
        case Asn1Constants.ALPHABET_CONSTRAINT:
            childAlphabetConstraint(node, child);
            break;
        case Asn1Constants.CONTAINED_TYPE_CONSTRAINT:
            childContainedTypeConstraint(node, child);
            break;
        case Asn1Constants.INNER_TYPE_CONSTRAINT:
            childInnerTypeConstraint(node, child);
            break;
        case Asn1Constants.COMPONENTS_LIST:
            childComponentsList(node, child);
            break;
        case Asn1Constants.COMPONENTS_LIST_TAIL:
            childComponentsListTail(node, child);
            break;
        case Asn1Constants.COMPONENT_CONSTRAINT:
            childComponentConstraint(node, child);
            break;
        case Asn1Constants.COMPONENT_VALUE_PRESENCE:
            childComponentValuePresence(node, child);
            break;
        case Asn1Constants.COMPONENT_PRESENCE:
            childComponentPresence(node, child);
            break;
        case Asn1Constants.VALUE_ASSIGNMENT:
            childValueAssignment(node, child);
            break;
        case Asn1Constants.VALUE:
            childValue(node, child);
            break;
        case Asn1Constants.DEFINED_VALUE:
            childDefinedValue(node, child);
            break;
        case Asn1Constants.BUILTIN_VALUE:
            childBuiltinValue(node, child);
            break;
        case Asn1Constants.NULL_VALUE:
            childNullValue(node, child);
            break;
        case Asn1Constants.BOOLEAN_VALUE:
            childBooleanValue(node, child);
            break;
        case Asn1Constants.SPECIAL_REAL_VALUE:
            childSpecialRealValue(node, child);
            break;
        case Asn1Constants.NUMBER_VALUE:
            childNumberValue(node, child);
            break;
        case Asn1Constants.BINARY_VALUE:
            childBinaryValue(node, child);
            break;
        case Asn1Constants.HEXADECIMAL_VALUE:
            childHexadecimalValue(node, child);
            break;
        case Asn1Constants.STRING_VALUE:
            childStringValue(node, child);
            break;
        case Asn1Constants.BIT_OR_OBJECT_IDENTIFIER_VALUE:
            childBitOrObjectIdentifierValue(node, child);
            break;
        case Asn1Constants.BIT_VALUE:
            childBitValue(node, child);
            break;
        case Asn1Constants.OBJECT_IDENTIFIER_VALUE:
            childObjectIdentifierValue(node, child);
            break;
        case Asn1Constants.NAME_VALUE_LIST:
            childNameValueList(node, child);
            break;
        case Asn1Constants.NAME_VALUE_COMPONENT:
            childNameValueComponent(node, child);
            break;
        case Asn1Constants.NAME_OR_NUMBER:
            childNameOrNumber(node, child);
            break;
        case Asn1Constants.NAME_AND_NUMBER:
            childNameAndNumber(node, child);
            break;
        case Asn1Constants.DEFINED_MACRO_TYPE:
            childDefinedMacroType(node, child);
            break;
        case Asn1Constants.DEFINED_MACRO_NAME:
            childDefinedMacroName(node, child);
            break;
        case Asn1Constants.SNMP_MODULE_IDENTITY_MACRO_TYPE:
            childSnmpModuleIdentityMacroType(node, child);
            break;
        case Asn1Constants.SNMP_OBJECT_IDENTITY_MACRO_TYPE:
            childSnmpObjectIdentityMacroType(node, child);
            break;
        case Asn1Constants.SNMP_OBJECT_TYPE_MACRO_TYPE:
            childSnmpObjectTypeMacroType(node, child);
            break;
        case Asn1Constants.SNMP_NOTIFICATION_TYPE_MACRO_TYPE:
            childSnmpNotificationTypeMacroType(node, child);
            break;
        case Asn1Constants.SNMP_TRAP_TYPE_MACRO_TYPE:
            childSnmpTrapTypeMacroType(node, child);
            break;
        case Asn1Constants.SNMP_TEXTUAL_CONVENTION_MACRO_TYPE:
            childSnmpTextualConventionMacroType(node, child);
            break;
        case Asn1Constants.SNMP_OBJECT_GROUP_MACRO_TYPE:
            childSnmpObjectGroupMacroType(node, child);
            break;
        case Asn1Constants.SNMP_NOTIFICATION_GROUP_MACRO_TYPE:
            childSnmpNotificationGroupMacroType(node, child);
            break;
        case Asn1Constants.SNMP_MODULE_COMPLIANCE_MACRO_TYPE:
            childSnmpModuleComplianceMacroType(node, child);
            break;
        case Asn1Constants.SNMP_AGENT_CAPABILITIES_MACRO_TYPE:
            childSnmpAgentCapabilitiesMacroType(node, child);
            break;
        case Asn1Constants.SNMP_UPDATE_PART:
            childSnmpUpdatePart(node, child);
            break;
        case Asn1Constants.SNMP_ORGANIZATION_PART:
            childSnmpOrganizationPart(node, child);
            break;
        case Asn1Constants.SNMP_CONTACT_PART:
            childSnmpContactPart(node, child);
            break;
        case Asn1Constants.SNMP_DESCR_PART:
            childSnmpDescrPart(node, child);
            break;
        case Asn1Constants.SNMP_REVISION_PART:
            childSnmpRevisionPart(node, child);
            break;
        case Asn1Constants.SNMP_STATUS_PART:
            childSnmpStatusPart(node, child);
            break;
        case Asn1Constants.SNMP_REFER_PART:
            childSnmpReferPart(node, child);
            break;
        case Asn1Constants.SNMP_SYNTAX_PART:
            childSnmpSyntaxPart(node, child);
            break;
        case Asn1Constants.SNMP_UNITS_PART:
            childSnmpUnitsPart(node, child);
            break;
        case Asn1Constants.SNMP_ACCESS_PART:
            childSnmpAccessPart(node, child);
            break;
        case Asn1Constants.SNMP_INDEX_PART:
            childSnmpIndexPart(node, child);
            break;
        case Asn1Constants.INDEX_VALUE_LIST:
            childIndexValueList(node, child);
            break;
        case Asn1Constants.INDEX_VALUE:
            childIndexValue(node, child);
            break;
        case Asn1Constants.INDEX_TYPE:
            childIndexType(node, child);
            break;
        case Asn1Constants.SNMP_DEF_VAL_PART:
            childSnmpDefValPart(node, child);
            break;
        case Asn1Constants.SNMP_OBJECTS_PART:
            childSnmpObjectsPart(node, child);
            break;
        case Asn1Constants.VALUE_LIST:
            childValueList(node, child);
            break;
        case Asn1Constants.SNMP_ENTERPRISE_PART:
            childSnmpEnterprisePart(node, child);
            break;
        case Asn1Constants.SNMP_VAR_PART:
            childSnmpVarPart(node, child);
            break;
        case Asn1Constants.SNMP_DISPLAY_PART:
            childSnmpDisplayPart(node, child);
            break;
        case Asn1Constants.SNMP_NOTIFICATIONS_PART:
            childSnmpNotificationsPart(node, child);
            break;
        case Asn1Constants.SNMP_MODULE_PART:
            childSnmpModulePart(node, child);
            break;
        case Asn1Constants.SNMP_MODULE_IMPORT:
            childSnmpModuleImport(node, child);
            break;
        case Asn1Constants.SNMP_MANDATORY_PART:
            childSnmpMandatoryPart(node, child);
            break;
        case Asn1Constants.SNMP_COMPLIANCE_PART:
            childSnmpCompliancePart(node, child);
            break;
        case Asn1Constants.COMPLIANCE_GROUP:
            childComplianceGroup(node, child);
            break;
        case Asn1Constants.COMPLIANCE_OBJECT:
            childComplianceObject(node, child);
            break;
        case Asn1Constants.SNMP_WRITE_SYNTAX_PART:
            childSnmpWriteSyntaxPart(node, child);
            break;
        case Asn1Constants.SNMP_PRODUCT_RELEASE_PART:
            childSnmpProductReleasePart(node, child);
            break;
        case Asn1Constants.SNMP_MODULE_SUPPORT_PART:
            childSnmpModuleSupportPart(node, child);
            break;
        case Asn1Constants.SNMP_VARIATION_PART:
            childSnmpVariationPart(node, child);
            break;
        case Asn1Constants.SNMP_CREATION_PART:
            childSnmpCreationPart(node, child);
            break;
        }
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDot(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDot(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDoubleDot(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDoubleDot(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTripleDot(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTripleDot(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComma(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComma(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSemiColon(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSemiColon(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightParen(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightParen(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBrace(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBrace(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLeftBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLeftBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRightBracket(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRightBracket(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMinus(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMinus(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLessThan(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLessThan(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterVerticalBar(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitVerticalBar(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinition(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinition(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinitions(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinitions(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterExplicit(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitExplicit(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterImplicit(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitImplicit(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTags(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTags(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBegin(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBegin(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterEnd(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitEnd(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterExports(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitExports(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterImports(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitImports(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterFrom(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitFrom(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMacro(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMacro(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterInteger(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitInteger(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterReal(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitReal(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBoolean(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBoolean(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNull(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNull(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBit(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBit(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterOctet(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitOctet(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterString(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitString(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterEnumerated(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitEnumerated(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSequence(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSequence(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSet(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSet(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterOf(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitOf(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterChoice(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitChoice(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterUniversal(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitUniversal(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterApplication(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitApplication(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterPrivate(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitPrivate(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAny(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAny(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefined(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefined(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBy(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBy(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObject(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObject(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIdentifier(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIdentifier(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIncludes(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIncludes(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMin(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMin(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMax(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMax(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSize(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSize(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterWith(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitWith(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponent(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponent(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponents(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponents(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterPresent(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitPresent(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAbsent(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAbsent(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterOptional(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitOptional(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefault(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefault(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTrue(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTrue(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterFalse(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitFalse(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterPlusInfinity(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitPlusInfinity(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMinusInfinity(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMinusInfinity(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleIdentity(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleIdentity(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjectIdentity(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjectIdentity(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjectType(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjectType(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNotificationType(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNotificationType(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTrapType(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTrapType(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTextualConvention(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTextualConvention(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjectGroup(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjectGroup(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNotificationGroup(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNotificationGroup(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleCompliance(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleCompliance(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAgentCapabilities(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAgentCapabilities(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLastUpdated(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLastUpdated(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterOrganization(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitOrganization(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterContactInfo(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitContactInfo(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDescription(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDescription(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRevision(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRevision(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterStatus(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitStatus(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterReference(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitReference(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSyntax(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSyntax(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBits(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBits(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterUnits(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitUnits(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAccess(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAccess(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMaxAccess(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMaxAccess(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMinAccess(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMinAccess(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIndex(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIndex(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAugments(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAugments(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterImplied(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitImplied(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefval(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefval(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjects(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjects(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterEnterprise(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitEnterprise(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterVariables(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitVariables(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDisplayHint(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDisplayHint(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNotifications(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNotifications(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModule(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModule(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMandatoryGroups(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMandatoryGroups(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterGroup(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitGroup(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterWriteSyntax(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitWriteSyntax(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterProductRelease(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitProductRelease(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSupports(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSupports(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterVariation(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitVariation(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterCreationRequires(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitCreationRequires(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBinaryString(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBinaryString(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterHexadecimalString(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitHexadecimalString(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterQuotedString(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitQuotedString(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIdentifierString(Token node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIdentifierString(Token node)
        throws ParseException {

        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNumberString(Token node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNumberString(Token node) throws ParseException {
        return node;
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleDefinition(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleDefinition(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childModuleDefinition(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleIdentifier(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleIdentifier(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childModuleIdentifier(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleReference(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleReference(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childModuleReference(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTagDefault(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTagDefault(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTagDefault(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterModuleBody(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitModuleBody(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childModuleBody(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterExportList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitExportList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childExportList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterImportList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitImportList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childImportList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSymbolsFromModule(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSymbolsFromModule(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSymbolsFromModule(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSymbolList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSymbolList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSymbolList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSymbol(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSymbol(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSymbol(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAssignmentList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAssignmentList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAssignmentList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAssignment(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAssignment(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAssignment(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMacroDefinition(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMacroDefinition(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childMacroDefinition(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMacroReference(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMacroReference(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childMacroReference(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMacroBody(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMacroBody(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childMacroBody(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterMacroBodyElement(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitMacroBodyElement(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childMacroBodyElement(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTypeAssignment(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTypeAssignment(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTypeAssignment(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterType(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinedType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinedType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childDefinedType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBuiltinType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBuiltinType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBuiltinType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNullType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNullType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNullType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBooleanType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBooleanType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBooleanType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterRealType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitRealType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childRealType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIntegerType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIntegerType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childIntegerType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjectIdentifierType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjectIdentifierType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childObjectIdentifierType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterStringType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitStringType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childStringType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBitStringType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBitStringType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBitStringType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBitsType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBitsType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBitsType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSequenceType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSequenceType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSequenceType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSequenceOfType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSequenceOfType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSequenceOfType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSetType(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSetType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSetType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSetOfType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSetOfType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSetOfType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterChoiceType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitChoiceType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childChoiceType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterEnumeratedType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitEnumeratedType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childEnumeratedType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSelectionType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSelectionType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSelectionType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTaggedType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTaggedType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTaggedType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterTag(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitTag(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childTag(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterClass(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitClass(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childClass(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterExplicitOrImplicitTag(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitExplicitOrImplicitTag(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childExplicitOrImplicitTag(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAnyType(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAnyType(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAnyType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterElementTypeList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitElementTypeList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childElementTypeList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterElementType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitElementType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childElementType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterOptionalOrDefaultElement(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitOptionalOrDefaultElement(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childOptionalOrDefaultElement(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueOrConstraintList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueOrConstraintList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueOrConstraintList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNamedNumberList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNamedNumberList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNamedNumberList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNamedNumber(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNamedNumber(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNamedNumber(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNumber(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNumber(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNumber(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterConstraintList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitConstraintList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childConstraintList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueConstraintList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueConstraintList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueConstraintList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueRange(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueRange(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueRange(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterLowerEndPoint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitLowerEndPoint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childLowerEndPoint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterUpperEndPoint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitUpperEndPoint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childUpperEndPoint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSizeConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSizeConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSizeConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterAlphabetConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitAlphabetConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childAlphabetConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterContainedTypeConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitContainedTypeConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childContainedTypeConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterInnerTypeConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitInnerTypeConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childInnerTypeConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponentsList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponentsList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComponentsList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponentsListTail(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponentsListTail(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComponentsListTail(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponentConstraint(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponentConstraint(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComponentConstraint(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponentValuePresence(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponentValuePresence(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComponentValuePresence(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComponentPresence(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComponentPresence(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComponentPresence(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueAssignment(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueAssignment(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueAssignment(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValue(Production node) throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValue(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinedValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinedValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childDefinedValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBuiltinValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBuiltinValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBuiltinValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNullValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNullValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNullValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBooleanValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBooleanValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBooleanValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSpecialRealValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSpecialRealValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSpecialRealValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNumberValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNumberValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNumberValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBinaryValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBinaryValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBinaryValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterHexadecimalValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitHexadecimalValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childHexadecimalValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterStringValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitStringValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childStringValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBitOrObjectIdentifierValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBitOrObjectIdentifierValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBitOrObjectIdentifierValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterBitValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitBitValue(Production node) throws ParseException {
        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childBitValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterObjectIdentifierValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitObjectIdentifierValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childObjectIdentifierValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNameValueList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNameValueList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNameValueList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNameValueComponent(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNameValueComponent(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNameValueComponent(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNameOrNumber(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNameOrNumber(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNameOrNumber(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterNameAndNumber(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitNameAndNumber(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childNameAndNumber(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinedMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinedMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childDefinedMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterDefinedMacroName(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitDefinedMacroName(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childDefinedMacroName(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpModuleIdentityMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpModuleIdentityMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpModuleIdentityMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpObjectIdentityMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpObjectIdentityMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpObjectIdentityMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpObjectTypeMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpObjectTypeMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpObjectTypeMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpNotificationTypeMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpNotificationTypeMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpNotificationTypeMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpTrapTypeMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpTrapTypeMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpTrapTypeMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpTextualConventionMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpTextualConventionMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpTextualConventionMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpObjectGroupMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpObjectGroupMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpObjectGroupMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpNotificationGroupMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpNotificationGroupMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpNotificationGroupMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpModuleComplianceMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpModuleComplianceMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpModuleComplianceMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpAgentCapabilitiesMacroType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpAgentCapabilitiesMacroType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpAgentCapabilitiesMacroType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpUpdatePart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpUpdatePart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpUpdatePart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpOrganizationPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpOrganizationPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpOrganizationPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpContactPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpContactPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpContactPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpDescrPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpDescrPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpDescrPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpRevisionPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpRevisionPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpRevisionPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpStatusPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpStatusPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpStatusPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpReferPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpReferPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpReferPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpSyntaxPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpSyntaxPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpSyntaxPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpUnitsPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpUnitsPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpUnitsPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpAccessPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpAccessPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpAccessPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpIndexPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpIndexPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpIndexPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIndexValueList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIndexValueList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childIndexValueList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIndexValue(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIndexValue(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childIndexValue(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterIndexType(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitIndexType(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childIndexType(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpDefValPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpDefValPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpDefValPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpObjectsPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpObjectsPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpObjectsPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterValueList(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitValueList(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childValueList(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpEnterprisePart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpEnterprisePart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpEnterprisePart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpVarPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpVarPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpVarPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpDisplayPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpDisplayPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpDisplayPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpNotificationsPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpNotificationsPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpNotificationsPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpModulePart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpModulePart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpModulePart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpModuleImport(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpModuleImport(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpModuleImport(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpMandatoryPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpMandatoryPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpMandatoryPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpCompliancePart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpCompliancePart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpCompliancePart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComplianceGroup(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComplianceGroup(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComplianceGroup(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterComplianceObject(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitComplianceObject(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childComplianceObject(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpWriteSyntaxPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpWriteSyntaxPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpWriteSyntaxPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpProductReleasePart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpProductReleasePart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpProductReleasePart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpModuleSupportPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpModuleSupportPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpModuleSupportPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpVariationPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpVariationPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpVariationPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }

    /**
     * Called when entering a parse tree node.
     * 
     * @param node           the node being entered
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void enterSnmpCreationPart(Production node)
        throws ParseException {
    }

    /**
     * Called when exiting a parse tree node.
     * 
     * @param node           the node being exited
     * 
     * @return the node to add to the parse tree, or
     *         null if no parse tree should be created
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected Node exitSnmpCreationPart(Production node)
        throws ParseException {

        return node;
    }

    /**
     * Called when adding a child to a parse tree node.
     * 
     * @param node           the parent node
     * @param child          the child node, or null
     * 
     * @throws ParseException if the node analysis discovered errors
     */
    protected void childSnmpCreationPart(Production node, Node child)
        throws ParseException {

        node.addChild(child);
    }
}
