/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.browser.MibNode;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibTreeBuilder {
    private static MibTreeBuilder instance = null;
    public static JTree mibTree = null;

    public static MibTreeBuilder getInstance() {
        if (instance == null) {
            instance = new MibTreeBuilder();
        }
        return instance;
    }

    private MibTreeBuilder() {
        int mode = 1;
        mibTree = new JTree(new MibNode("Mibble Browser", null));
        mibTree.getSelectionModel().setSelectionMode(mode);
        mibTree.setRootVisible(false);
    }

    public Mib loadMib(File file) throws IOException, MibLoaderException {
        MibLoader loader = new MibLoader();
        loader.addDir(file.getParentFile());
        return loader.load(file);
    }

    public void addMib(Mib mib) {
        Iterator iter = mib.getAllSymbols().iterator();
        MibNode node = new MibNode("VALUES", null);
        JTree valueTree = new JTree(node);
        while (iter.hasNext()) {
            MibSymbol symbol = (MibSymbol)iter.next();
            this.addSymbol(valueTree.getModel(), symbol);
        }
        MibNode root = (MibNode)mibTree.getModel().getRoot();
        node = new MibNode(mib.getName(), null);
        node.add((MibNode)valueTree.getModel().getRoot());
        root.add(node);
    }

    private void addSymbol(TreeModel model, MibSymbol symbol) {
        MibValue value;
        if (symbol instanceof MibValueSymbol && (value = ((MibValueSymbol)symbol).getValue()) instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue oid = (ObjectIdentifierValue)value;
            this.addToTree(model, oid);
        }
    }

    private MibNode addToTree(TreeModel model, ObjectIdentifierValue oid) {
        MibNode node;
        MibNode parent = this.hasParent(oid) ? this.addToTree(model, oid.getParent()) : (MibNode)model.getRoot();
        int i = 0;
        while (i < model.getChildCount(parent)) {
            node = (MibNode)model.getChild(parent, i);
            if (node.getValue().equals(oid)) {
                return node;
            }
            ++i;
        }
        String name = oid.getName() + " (" + oid.getValue() + ")";
        node = new MibNode(name, oid);
        parent.add(node);
        return node;
    }

    private boolean hasParent(ObjectIdentifierValue oid) {
        ObjectIdentifierValue parent = oid.getParent();
        return oid.getSymbol() != null && parent != null && parent.getSymbol() != null && parent.getSymbol().getMib().equals(oid.getSymbol().getMib());
    }

    public boolean unloadMib(String mibName) {
        DefaultTreeModel model = (DefaultTreeModel)mibTree.getModel();
        MibNode tempNode = null;
        MibNode root = (MibNode)model.getRoot();
        Enumeration<TreeNode> enumeration = root.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            tempNode = (MibNode)enumeration.nextElement();
            if (tempNode.getValue() != null || !tempNode.getName().equals(mibName)) continue;
            model.removeNodeFromParent(tempNode);
            return true;
        }
        return false;
    }
}

