/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class GraphDataSet {
    private static final String version_id = "@(#)$Id: GraphDataSet.java,v 1.5 2002/10/10 15:13:58 birgit Exp $ Copyright Westhawk Ltd";
    private int capacity = 100;
    private int[] values = new int[this.capacity];
    private int index = 0;
    private Vector propertyChangeListener = new Vector();

    public GraphDataSet() {
        this(100);
    }

    public GraphDataSet(int cap) {
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getSize() {
        return this.index;
    }

    public void addElement(int v) {
        int[] nArray = this.values;
        synchronized (nArray) {
            int newcount = this.index + 1;
            if (newcount > this.capacity) {
                this.shiftValues();
            }
            this.values[this.index++] = v;
        }
        this.firePropertyChange("Values", null, new Integer(v));
    }

    public int[] getValues() {
        return this.values;
    }

    private void shiftValues() {
        int[] oldData = this.values;
        this.values = new int[this.capacity];
        System.arraycopy(oldData, 1, this.values, 0, this.capacity - 1);
        this.index = this.capacity - 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        Vector vector = this.propertyChangeListener;
        synchronized (vector) {
            this.propertyChangeListener.addElement(l);
        }
        if (this.index > 0) {
            this.firePropertyChange("Values", null, new Integer(this.values[this.index - 1]));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        Vector vector = this.propertyChangeListener;
        synchronized (vector) {
            this.propertyChangeListener.removeElement(l);
        }
    }

    protected void firePropertyChange(String property, Object old_v, Object new_v) {
        Vector listeners;
        Vector vector = this.propertyChangeListener;
        synchronized (vector) {
            listeners = (Vector)this.propertyChangeListener.clone();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, property, old_v, new_v);
        int sz = listeners.size();
        int i = 0;
        while (i < sz) {
            PropertyChangeListener l = (PropertyChangeListener)listeners.elementAt(i);
            l.propertyChange(event);
            ++i;
        }
    }
}

