/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnTrapPduv1Sequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public abstract class TrapPduv1
extends Pdu {
    private static final String version_id = "@(#)$Id: TrapPduv1.java,v 3.8 2002/10/10 15:13:57 birgit Exp $ Copyright Westhawk Ltd";
    private String enterprise;
    private byte[] IpAddress;
    private int generic_trap;
    private int specific_trap;
    private long timeTicks;
    private static final String[] genericTrapStrings = new String[]{"Cold Start", "Warm Start", "Link Down", "Link Up", "Authentication Failure", "EGP Neighbor Loss", "Enterprise Specific"};

    public TrapPduv1(SnmpContext con) {
        super(con);
        this.setMsgType((byte)-92);
        this.generic_trap = 1;
    }

    public void setEnterprise(String var) {
        this.enterprise = var;
    }

    public String getEnterprise() {
        return this.enterprise;
    }

    public void setIpAddress(byte[] var) {
        this.IpAddress = var;
    }

    public byte[] getIpAddress() {
        return this.IpAddress;
    }

    public void setGenericTrap(int var) {
        this.generic_trap = var;
    }

    public int getGenericTrap() {
        return this.generic_trap;
    }

    public String getGenericTrapString() {
        String trapStr = "";
        if (this.generic_trap > -1 && this.generic_trap < genericTrapStrings.length) {
            trapStr = genericTrapStrings[this.generic_trap];
        }
        return trapStr;
    }

    public void setSpecificTrap(int var) {
        this.specific_trap = var;
    }

    public int getSpecificTrap() {
        return this.specific_trap;
    }

    public void setTimeTicks(long var) {
        this.timeTicks = var;
    }

    public long getTimeTicks() {
        return this.timeTicks;
    }

    public boolean send() throws IOException, PduException {
        if (!this.added) {
            this.added = this.context.addPdu(this);
        }
        Enumeration vbs = this.reqVarbinds.elements();
        this.encodedPacket = ((SnmpContext)this.context).encodePacket(this.msg_type, this.enterprise, this.IpAddress, this.generic_trap, this.specific_trap, this.timeTicks, vbs);
        this.addToTrans();
        return this.added;
    }

    void transmit() {
        this.transmit(false);
    }

    public String toString() {
        varbind var;
        int i;
        int sz;
        String iPAddressStr = "null";
        if (this.IpAddress != null) {
            iPAddressStr = new AsnOctets(this.IpAddress).toIpAddress();
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("context=").append(this.context);
        buffer.append(", reqId=").append(this.getReqId());
        buffer.append(", msgType=0x").append(SnmpUtilities.toHex(this.msg_type));
        buffer.append(", enterprise=").append(this.enterprise);
        buffer.append(", IpAddress=").append(iPAddressStr);
        buffer.append(", generic_trap=").append(this.getGenericTrapString());
        buffer.append(", specific_trap=").append(this.specific_trap);
        buffer.append(", timeTicks=").append(this.timeTicks);
        buffer.append(", reqVarbinds=");
        if (this.reqVarbinds != null) {
            sz = this.reqVarbinds.size();
            buffer.append("[");
            i = 0;
            while (i < sz) {
                var = (varbind)this.reqVarbinds.elementAt(i);
                buffer.append(var.toString()).append(", ");
                ++i;
            }
            buffer.append("]");
        } else {
            buffer.append("null");
        }
        buffer.append(", respVarbinds=");
        if (this.respVarbinds != null) {
            sz = this.respVarbinds.size();
            buffer.append("[");
            i = 0;
            while (i < sz) {
                var = (varbind)this.respVarbinds.elementAt(i);
                buffer.append(var.toString()).append(", ");
                ++i;
            }
            buffer.append("]");
        } else {
            buffer.append("null");
        }
        buffer.append("]");
        return buffer.toString();
    }

    void fillin(AsnTrapPduv1Sequence seq) {
        if (seq != null) {
            try {
                AsnSequence varBind = seq.getVarBind();
                int size = varBind.getObjCount();
                this.respVarbinds = new Vector(size, 1);
                int n = 0;
                while (n < size) {
                    AsnSequence varSeq = (AsnSequence)varBind.getObj(n);
                    varbind vb = new varbind(varSeq);
                    this.respVarbinds.addElement(vb);
                    ++n;
                }
                this.setEnterprise(seq.getEnterprise());
                this.setIpAddress(seq.getIPAddress());
                this.setGenericTrap(seq.getGenericTrap());
                this.setSpecificTrap(seq.getSpecificTrap());
                this.setTimeTicks(seq.getTimeTicks());
            }
            catch (DecodingException exc) {
                this.setErrorStatus(20, exc);
            }
        }
    }

    protected void new_value(int n, varbind res) {
    }

    protected void tell_them() {
    }
}

