/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.pdu.DiscoveryPdu;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextPoolItem;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.SnmpContextv3Face;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class SnmpContextv3Pool
implements SnmpContextv3Face {
    private static final String version_id = "@(#)$Id: SnmpContextv3Pool.java,v 3.16 2002/10/23 09:56:03 birgit Exp $ Copyright Westhawk Ltd";
    protected static Hashtable contextPool;
    protected String hostAddr;
    protected String socketType;
    protected int hostPort;
    protected SnmpContextv3 context = null;
    protected String userName = "";
    protected boolean useAuthentication = false;
    protected String userAuthenticationPassword = "";
    protected boolean usePrivacy = false;
    protected String userPrivacyPassword = "";
    protected int authenticationProtocol = 0;
    protected byte[] contextEngineId = new byte[0];
    protected String contextName = "";
    protected boolean hasChanged = false;

    public SnmpContextv3Pool(String host, int port) throws IOException {
        this(host, port, "Standard");
    }

    public SnmpContextv3Pool(String host, int port, String typeSocket) throws IOException {
        SnmpContextv3Pool.initPools();
        this.hostAddr = host;
        this.hostPort = port;
        this.socketType = typeSocket;
    }

    private static synchronized void initPools() {
        if (contextPool == null) {
            contextPool = new Hashtable(5);
        }
    }

    public int getVersion() {
        return 3;
    }

    public String getHost() {
        return this.hostAddr;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getTypeSocket() {
        return this.socketType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String newUserName) {
        if (newUserName != null && !newUserName.equals(this.userName)) {
            this.userName = newUserName;
            this.hasChanged = true;
        }
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean newUseAuthentication) {
        if (newUseAuthentication != this.useAuthentication) {
            this.useAuthentication = newUseAuthentication;
            this.hasChanged = true;
        }
    }

    public String getUserAuthenticationPassword() {
        return this.userAuthenticationPassword;
    }

    public void setUserAuthenticationPassword(String newUserAuthenticationPd) {
        if (newUserAuthenticationPd != null && !newUserAuthenticationPd.equals(this.userAuthenticationPassword)) {
            this.userAuthenticationPassword = newUserAuthenticationPd;
            this.hasChanged = true;
        }
    }

    public void setAuthenticationProtocol(int protocol) {
        if (protocol != this.authenticationProtocol) {
            this.authenticationProtocol = protocol;
            this.hasChanged = true;
        }
    }

    public int getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public boolean isUsePrivacy() {
        return this.usePrivacy;
    }

    public void setUsePrivacy(boolean newUsePrivacy) {
        if (newUsePrivacy != this.usePrivacy) {
            this.usePrivacy = newUsePrivacy;
            this.hasChanged = true;
        }
    }

    public String getUserPrivacyPassword() {
        return this.userPrivacyPassword;
    }

    public void setUserPrivacyPassword(String newUserPrivacyPd) {
        if (newUserPrivacyPd != null && !newUserPrivacyPd.equals(this.userPrivacyPassword)) {
            this.userPrivacyPassword = newUserPrivacyPd;
            this.hasChanged = true;
        }
    }

    public void setContextEngineId(byte[] newContextEngineId) {
        if (newContextEngineId != null && !newContextEngineId.equals(this.contextEngineId)) {
            this.contextEngineId = newContextEngineId;
            this.hasChanged = true;
        }
    }

    public byte[] getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextName(String newContextName) {
        if (newContextName != null && !newContextName.equals(this.contextName)) {
            this.contextName = newContextName;
            this.hasChanged = true;
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean addDiscoveryPdu(DiscoveryPdu pdu) throws IOException, PduException, IllegalArgumentException {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.addDiscoveryPdu(): " + exc.getMessage());
            }
        }
        return this.context.addDiscoveryPdu(pdu);
    }

    public boolean addPdu(Pdu pdu) throws IOException, PduException, IllegalArgumentException {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.addPdu(): " + exc.getMessage());
            }
        }
        return this.context.addPdu(pdu);
    }

    public boolean removePdu(int requestId) {
        boolean res = false;
        if (this.context != null) {
            res = this.context.removePdu(requestId);
        }
        return res;
    }

    public byte[] encodeDiscoveryPacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodeDiscoveryPacket(msg_type, rId, errstat, errind, ve);
        }
        return res;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodePacket(msg_type, rId, errstat, errind, ve);
        }
        return res;
    }

    public void sendPacket(byte[] packet) {
        if (this.context != null) {
            this.context.sendPacket(packet);
        }
    }

    public void destroy() {
        block9: {
            try {
                if (this.hasChanged) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block9;
                System.out.println("SnmpContextv3Pool.destroy(): " + exc.getMessage());
            }
        }
        if (this.context != null) {
            String hashKey = this.getHashKey();
            Hashtable hashtable = contextPool;
            synchronized (hashtable) {
                int count = 0;
                SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(hashKey);
                if (item != null) {
                    count = item.getCounter();
                    item.setCounter(--count);
                }
                if (count <= 0) {
                    contextPool.remove(hashKey);
                    this.context.destroy();
                    this.context = null;
                }
            }
        }
    }

    protected SnmpContextv3 getMatchingContext() throws IOException, IllegalArgumentException {
        SnmpContextPoolItem item = null;
        SnmpContextv3 newContext = null;
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            if (contextPool.containsKey(hashKey)) {
                item = (SnmpContextPoolItem)contextPool.get(hashKey);
                newContext = (SnmpContextv3)item.getContext();
                count = item.getCounter();
            } else {
                newContext = new SnmpContextv3(this.hostAddr, this.hostPort, this.socketType);
                newContext.setContextEngineId(this.contextEngineId);
                newContext.setContextName(this.contextName);
                newContext.setUserName(this.userName);
                newContext.setUseAuthentication(this.useAuthentication);
                newContext.setUserAuthenticationPassword(this.userAuthenticationPassword);
                newContext.setAuthenticationProtocol(this.authenticationProtocol);
                newContext.setUsePrivacy(this.usePrivacy);
                newContext.setUserPrivacyPassword(this.userPrivacyPassword);
                item = new SnmpContextPoolItem(newContext);
                contextPool.put(hashKey, item);
            }
            this.hasChanged = false;
            item.setCounter(++count);
        }
        return newContext;
    }

    public void dumpContexts(String title) {
        block5: {
            try {
                if (this.hasChanged) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block5;
                System.out.println("SnmpContextv3Pool.dumpContexts(): " + exc.getMessage());
            }
        }
        System.out.println(title + " " + contextPool.size());
        Enumeration keys = contextPool.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(key);
            if (item == null) continue;
            int count = item.getCounter();
            SnmpContextv3 cntxt = (SnmpContextv3)item.getContext();
            System.out.println("\tcontext: " + key + ", count: " + count + ", index: " + i);
            if (cntxt == this.context) {
                System.out.println("\t\tcurrent context");
            }
            ++i;
        }
        System.out.println("\thasChanged: " + this.hasChanged);
    }

    public String getHashKey() {
        String str = this.hostAddr + "_" + this.hostPort + "_" + this.socketType + "_" + this.useAuthentication + "_" + this.authenticationProtocol + "_" + this.userAuthenticationPassword + "_" + this.userName + "_" + this.usePrivacy + "_" + this.userPrivacyPassword + "_" + SnmpUtilities.toHexString(this.contextEngineId) + "_" + this.contextName + "_v" + this.getVersion();
        return str;
    }

    public void addTrapListener(TrapListener l) throws IOException {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.addTrapListener(): " + exc.getMessage());
            }
        }
        this.context.addTrapListener(l);
    }

    public void removeTrapListener(TrapListener l) throws IOException {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.removeTrapListener(): " + exc.getMessage());
            }
        }
        this.context.removeTrapListener(l);
    }

    public Pdu processIncomingTrap(byte[] message) throws DecodingException, IOException {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.processIncomingTrap(): " + exc.getMessage());
            }
        }
        Pdu pdu = null;
        pdu = this.context.processIncomingTrap(message);
        return pdu;
    }

    public String toString() {
        block3: {
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println("SnmpContextv3Pool.toString(): " + exc.getMessage());
            }
        }
        String res = "";
        res = this.context.toString();
        return res;
    }
}

