/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.beans.UsmDiscoveryBean;
import uk.co.westhawk.snmp.pdu.DiscoveryPdu;
import uk.co.westhawk.snmp.pdu.OneTrapPduv2;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoder;
import uk.co.westhawk.snmp.stack.AsnEncoder;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.DefaultUsmAgent;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextv3Face;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.stack.UsmAgent;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class SnmpContextv3
extends AbstractSnmpContext
implements SnmpContextv3Face,
Cloneable {
    private static final String version_id = "@(#)$Id: SnmpContextv3.java,v 3.20 2002/10/23 11:48:01 birgit Exp $ Copyright Westhawk Ltd";
    private Hashtable msgIdHash = new Hashtable(20);
    private String userName = "initial";
    private boolean useAuthentication = false;
    private String userAuthenticationPassword;
    private byte[] userAuthKeyMD5 = null;
    private byte[] userAuthKeySHA1 = null;
    private int authenticationProtocol = 0;
    private boolean usePrivacy = false;
    private String userPrivacyPassword;
    private byte[] userPrivKeyMD5 = null;
    private byte[] userPrivKeySHA1 = null;
    private byte[] contextEngineId = new byte[0];
    private String contextName = "";
    private static UsmAgent usmAgent = null;
    private static int next_id = 1;

    public SnmpContextv3(String host, int port) throws IOException {
        this(host, port, "Standard");
    }

    public SnmpContextv3(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
        if (TimeWindow.getCurrent() == null) {
            TimeWindow timew = new TimeWindow();
        }
        if (usmAgent == null) {
            usmAgent = this.createUsmAgent();
        }
    }

    public int getVersion() {
        return 3;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String newUserName) {
        this.userName = newUserName;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean newUseAuthentication) {
        this.useAuthentication = newUseAuthentication;
    }

    public String getUserAuthenticationPassword() {
        return this.userAuthenticationPassword;
    }

    public void setUserAuthenticationPassword(String newUserAuthPassword) {
        if (newUserAuthPassword != null && !newUserAuthPassword.equals(this.userAuthenticationPassword)) {
            this.userAuthenticationPassword = newUserAuthPassword;
            this.userAuthKeyMD5 = null;
            this.userAuthKeySHA1 = null;
        }
    }

    public void setAuthenticationProtocol(int protocol) throws IllegalArgumentException {
        if (protocol == 0 || protocol == 1) {
            if (protocol != this.authenticationProtocol) {
                this.authenticationProtocol = protocol;
            }
        } else {
            throw new IllegalArgumentException("Authentication Protocol should be MD5 or SHA1");
        }
    }

    public int getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    byte[] getAuthenticationPasswordKeyMD5() {
        if (this.userAuthKeyMD5 == null) {
            this.userAuthKeyMD5 = SnmpUtilities.passwordToKeyMD5(this.userAuthenticationPassword);
        }
        return this.userAuthKeyMD5;
    }

    byte[] getAuthenticationPasswordKeySHA1() {
        if (this.userAuthKeySHA1 == null) {
            this.userAuthKeySHA1 = SnmpUtilities.passwordToKeySHA1(this.userAuthenticationPassword);
        }
        return this.userAuthKeySHA1;
    }

    byte[] getPrivacyPasswordKeyMD5() {
        if (this.userPrivKeyMD5 == null) {
            this.userPrivKeyMD5 = SnmpUtilities.passwordToKeyMD5(this.userPrivacyPassword);
        }
        return this.userPrivKeyMD5;
    }

    byte[] getPrivacyPasswordKeySHA1() {
        if (this.userPrivKeySHA1 == null) {
            this.userPrivKeySHA1 = SnmpUtilities.passwordToKeySHA1(this.userPrivacyPassword);
        }
        return this.userPrivKeySHA1;
    }

    public boolean isUsePrivacy() {
        return this.usePrivacy;
    }

    public void setUsePrivacy(boolean newUsePrivacy) {
        this.usePrivacy = newUsePrivacy;
    }

    public String getUserPrivacyPassword() {
        return this.userPrivacyPassword;
    }

    public void setUserPrivacyPassword(String newUserPrivacyPassword) {
        if (newUserPrivacyPassword != null && !newUserPrivacyPassword.equals(this.userPrivacyPassword)) {
            this.userPrivacyPassword = newUserPrivacyPassword;
            this.userPrivKeyMD5 = null;
            this.userPrivKeySHA1 = null;
        }
    }

    public void setContextEngineId(byte[] newContextEngineId) throws IllegalArgumentException {
        this.contextEngineId = newContextEngineId;
        if (this.contextEngineId == null) {
            throw new IllegalArgumentException("contextEngineId is null");
        }
    }

    public byte[] getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextName(String newContextName) {
        this.contextName = newContextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean addDiscoveryPdu(DiscoveryPdu pdu) throws IOException, PduException {
        return this.addPdu(pdu, false);
    }

    public boolean addPdu(Pdu pdu) throws IOException, PduException {
        return this.addPdu(pdu, true);
    }

    protected UsmAgent createUsmAgent() {
        return new DefaultUsmAgent();
    }

    public static void setUsmAgent(UsmAgent agent) {
        usmAgent = agent;
    }

    protected boolean addPdu(Pdu pdu, boolean checkDiscovery) throws IOException, PduException {
        boolean added = super.addPdu(pdu);
        if (checkDiscovery && !this.isAuthoritative(pdu.getMsgType())) {
            this.discoverIfNeeded();
        }
        return added;
    }

    public synchronized boolean removePdu(int rid) {
        boolean removed = super.removePdu(rid);
        if (removed) {
            Enumeration keys = this.msgIdHash.keys();
            Integer msgIdI = null;
            boolean found = false;
            while (keys.hasMoreElements() && !found) {
                msgIdI = (Integer)keys.nextElement();
                Integer pduIdI = (Integer)this.msgIdHash.get(msgIdI);
                boolean bl = found = pduIdI == rid;
            }
            if (found) {
                this.msgIdHash.remove(msgIdI);
            }
        }
        return removed;
    }

    public byte[] encodeDiscoveryPacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        String engineId = "";
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (tWindow.isSnmpEngineIdKnown(this.hostAddr, this.hostPort)) {
            engineId = tWindow.getSnmpEngineId(this.hostAddr, this.hostPort);
        }
        TimeWindowNode node = new TimeWindowNode(engineId, 0, 0);
        return this.actualEncodePacket(msg_type, rId, errstat, errind, ve, node);
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        TimeWindowNode node;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        if (this.isAuthoritative(msg_type)) {
            usmAgent.setSnmpContext(this);
            node = new TimeWindowNode(usmAgent.getSnmpEngineId(), usmAgent.getSnmpEngineBoots(), usmAgent.getSnmpEngineTime());
        } else {
            TimeWindow tWindow = TimeWindow.getCurrent();
            if (!tWindow.isSnmpEngineIdKnown(this.hostAddr, this.hostPort)) {
                throw new EncodingException("Engine ID of host " + this.hostAddr + ", port " + this.hostPort + " is unknown. Perform discovery.");
            }
            String engineId = tWindow.getSnmpEngineId(this.hostAddr, this.hostPort);
            node = new TimeWindowNode(engineId, 0, 0);
            if (this.isUseAuthentication()) {
                if (tWindow.isTimeLineKnown(engineId)) {
                    node = tWindow.getTimeLine(engineId);
                } else {
                    throw new EncodingException("Time Line of Engine ID of host " + this.hostAddr + ", port " + this.hostPort + " is unknown. " + "Perform discovery.");
                }
            }
        }
        return this.actualEncodePacket(msg_type, rId, errstat, errind, ve, node);
    }

    protected byte[] actualEncodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, TimeWindowNode node) throws IOException, EncodingException {
        AsnEncoder enc = new AsnEncoder();
        int msgId = next_id++;
        this.msgIdHash.put(new Integer(msgId), new Integer(rId));
        if (AsnObject.debug > 6) {
            System.out.println("SnmpContextv3.actualEncodePacket(): msgId=" + msgId + ", Pdu reqId=" + rId);
        }
        byte[] packet = enc.EncodeSNMPv3(this, msgId, node, msg_type, rId, errstat, errind, ve);
        return packet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ProcessIncomingMessage(AsnDecoder rpdu, ByteArrayInputStream in) throws DecodingException, IOException {
        byte[] bu = null;
        int nb = in.available();
        bu = new byte[nb];
        in.read(bu);
        in = new ByteArrayInputStream(bu);
        AsnSequence asnTopSeq = rpdu.DecodeSNMPv3(in);
        int msgId = rpdu.getMsgId(asnTopSeq);
        Integer rid = (Integer)this.msgIdHash.get(new Integer(msgId));
        if (rid != null) {
            if (AsnObject.debug > 6) {
                System.out.println("SnmpContextv3.ProcessIncomingMessage(): msgId=" + msgId + ", Pdu reqId=" + rid);
            }
            Pdu pdu = this.getPdu(rid);
            try {
                AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, bu);
                if (pduSeq != null) {
                    Integer rid2 = new Integer(pduSeq.getReqId());
                    if (AsnObject.debug > 6) {
                        System.out.println("SnmpContextv3.ProcessIncomingMessage(): rid2=" + rid2);
                    }
                    Pdu newPdu = null;
                    if (rid2.intValue() != rid.intValue()) {
                        newPdu = this.getPdu(rid2);
                        if (AsnObject.debug > 3) {
                            System.out.println("ProcessIncomingMessage(): pduReqId of msgId (" + rid + ") != pduReqId of Pdu (" + rid2 + ")");
                        }
                        if (newPdu == null && AsnObject.debug > 3) {
                            System.out.println("ProcessIncomingMessage(): Using pduReqId of msgId (" + rid + ")");
                        }
                    }
                    if (newPdu != null) {
                        pdu = newPdu;
                    }
                } else if (AsnObject.debug > 6) {
                    System.out.println("SnmpContextv3.ProcessIncomingMessage(): pduSeq is null.");
                }
                if (pdu != null) {
                    pdu.fillin(pduSeq);
                    return;
                }
                if (AsnObject.debug <= 6) return;
                System.out.println("ProcessIncomingMessage(): No Pdu with reqid " + rid);
                return;
            }
            catch (DecodingException exc) {
                if (pdu == null) throw exc;
                pdu.setErrorStatus(19, exc);
                pdu.fillin(null);
                return;
            }
        } else {
            if (AsnObject.debug > 3) {
                System.out.println("Pdu of msgId " + msgId + " is already answered");
            }
            rid = new Integer(-1);
        }
    }

    protected boolean isAuthoritative(byte msg_type) {
        return msg_type == -94 || msg_type == -89 || msg_type == -88;
    }

    void discoverIfNeeded() throws IOException, PduException {
        UsmDiscoveryBean discBean = null;
        boolean isNeeded = false;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostAddr, this.hostPort);
        if (engineId == null) {
            isNeeded = true;
            discBean = new UsmDiscoveryBean(this.hostAddr, this.hostPort, this.typeSocket);
        }
        if (this.isUseAuthentication()) {
            if (isNeeded) {
                discBean.setAuthenticationDetails(this.userName, this.userAuthenticationPassword, this.authenticationProtocol);
            } else if (!tWindow.isTimeLineKnown(engineId)) {
                isNeeded = true;
                discBean = new UsmDiscoveryBean(this.hostAddr, this.hostPort, this.typeSocket);
                discBean.setAuthenticationDetails(this.userName, this.userAuthenticationPassword, this.authenticationProtocol);
            }
            if (isNeeded && this.isUsePrivacy()) {
                discBean.setPrivacyDetails(this.userPrivacyPassword);
            }
        }
        if (isNeeded) {
            discBean.startDiscovery();
        }
    }

    public Pdu processIncomingTrap(byte[] message) throws DecodingException, IOException {
        int l = message.length;
        byte[] copyOfMessage = new byte[l];
        System.arraycopy(message, 0, copyOfMessage, 0, l);
        AsnDecoder rpdu = new AsnDecoder();
        ByteArrayInputStream in = new ByteArrayInputStream(message);
        AsnSequence asnTopSeq = rpdu.DecodeSNMPv3(in);
        AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, copyOfMessage);
        OneTrapPduv2 trapPdu = new OneTrapPduv2(this);
        trapPdu.fillin(pduSeq);
        return trapPdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContextv3 clContext = null;
        try {
            clContext = new SnmpContextv3(this.hostAddr, this.hostPort, this.typeSocket);
            clContext.setUserName(new String(this.userName));
            clContext.setUseAuthentication(this.useAuthentication);
            if (this.userAuthenticationPassword != null) {
                clContext.setUserAuthenticationPassword(new String(this.userAuthenticationPassword));
            }
            clContext.setAuthenticationProtocol(this.authenticationProtocol);
            clContext.setContextName(new String(this.contextName));
            int l = this.contextEngineId.length;
            byte[] newContextEngineId = new byte[l];
            System.arraycopy(this.contextEngineId, 0, newContextEngineId, 0, l);
            clContext.setContextEngineId(newContextEngineId);
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SnmpContextv3[");
        buffer.append("host=").append(this.hostAddr);
        buffer.append(", port=").append(this.hostPort);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", contextEngineId=").append(SnmpUtilities.toHexString(this.contextEngineId));
        buffer.append(", contextName=").append(this.contextName);
        buffer.append(", userName=").append(this.userName);
        buffer.append(", useAuthentication=").append(this.useAuthentication);
        buffer.append(", authenticationProtocol=").append(SnmpContextv3Face.ProtocolNames[this.authenticationProtocol]);
        buffer.append(", userAuthenticationPassword=").append(this.userAuthenticationPassword);
        buffer.append(", usePrivacy=").append(this.usePrivacy);
        buffer.append(", userPrivacyPassword=").append(this.userPrivacyPassword);
        buffer.append("]");
        return buffer.toString();
    }
}

