/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.AgentException;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.Transmitter;
import uk.co.westhawk.snmp.stack.varbind;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public abstract class Pdu
extends Observable {
    private static final String version_id = "@(#)$Id: Pdu.java,v 3.25 2002/10/23 09:48:01 birgit Exp $ Copyright Westhawk Ltd";
    protected Vector reqVarbinds = null;
    protected Vector respVarbinds = null;
    private static final String TIMED_OUT = "Timed out";
    private static final String[] errorStrings = new String[]{"No error", "Value too big error", "No such name error", "Bad value error", "Read only error", "General error", "No access error", "Wrong type error", "Wrong length error", "Wrong encoding error", "Wrong value error", "No creation error", "Inconsistent value error", "Resource unavailable error", "Commit failed error", "Undo failed error", "Authorization error", "Not writable error", "Inconsistent name error"};
    private static int next_id = 1;
    private int[] retry_intervals = new int[]{500, 1000, 2000, 5000, 5000};
    protected byte[] encodedPacket = null;
    protected SnmpContextBasisFace context;
    protected boolean added = false;
    protected byte msg_type;
    private int req_id;
    protected int errstat;
    protected int errind;
    private Transmitter trans = null;
    private int retries;
    protected boolean answered;
    private boolean got = false;
    private boolean isTimedOut;
    private PduException respException = null;

    protected abstract void new_value(int var1, varbind var2);

    protected abstract void tell_them();

    public Pdu(SnmpContextBasisFace con) {
        this.context = con;
        this.req_id = next_id++;
        this.errstat = 0;
        this.errind = 0;
        this.reqVarbinds = new Vector(1, 1);
        this.setMsgType((byte)-96);
        this.isTimedOut = false;
        this.answered = true;
    }

    public SnmpContextBasisFace getContext() {
        return this.context;
    }

    public void setRetryIntervals(int[] rinterval) {
        this.retry_intervals = rinterval;
    }

    public boolean send() throws IOException, PduException {
        return this.send(this.errstat, this.errind);
    }

    protected boolean send(int error_status, int error_index) throws IOException, PduException {
        if (!this.added) {
            this.added = this.context.addPdu(this);
        }
        Enumeration vbs = this.reqVarbinds.elements();
        this.encodedPacket = this.context.encodePacket(this.msg_type, this.req_id, error_status, error_index, vbs);
        this.addToTrans();
        return this.added;
    }

    protected void addToTrans() {
        if (this.added && this.trans != null) {
            this.trans.setPdu(this);
            this.trans.stand();
        }
    }

    protected boolean sendme() {
        this.context.sendPacket(this.encodedPacket);
        ++this.retries;
        if (AsnObject.debug > 6) {
            System.out.println("Pdu.sendme(): Sent Pdu reqId " + this.req_id + ", retries " + this.retries);
        }
        return this.retries > 3;
    }

    public boolean send(String com) throws IOException, PduException {
        if (this.context instanceof SnmpContext) {
            ((SnmpContext)this.context).setCommunity(com);
        }
        return this.send();
    }

    public void addOid(String oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(String oid, AsnObject val) {
        varbind vb = new varbind(oid, val);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid, AsnObject val) {
        varbind vb = new varbind(oid, val);
        this.addOid(vb);
    }

    public void addOid(varbind var) {
        this.reqVarbinds.addElement(var);
    }

    public varbind[] getRequestVarbinds() {
        int sz = this.reqVarbinds.size();
        Object[] arr = new varbind[sz];
        this.reqVarbinds.copyInto(arr);
        return arr;
    }

    public varbind[] getResponseVarbinds() throws PduException {
        if (this.respException != null) {
            throw this.respException;
        }
        Object[] arr = null;
        if (this.respVarbinds != null) {
            int sz = this.respVarbinds.size();
            arr = new varbind[sz];
            this.respVarbinds.copyInto(arr);
        }
        return arr;
    }

    private void dump(Vector v, varbind[] array) {
        int sz = v.size();
        System.out.println("Vector: ");
        int i = 0;
        while (i < sz) {
            System.out.println("\t" + v.elementAt(i));
            ++i;
        }
        System.out.println("Array: ");
        int i2 = 0;
        while (i2 < array.length) {
            System.out.println("\t" + array[i2]);
            ++i2;
        }
        System.out.println("--");
    }

    void setResponseException(PduException exc) {
        if (AsnObject.debug > 6) {
            System.out.println("Pdu.setResponseException(): " + exc.getMessage());
        }
        this.respException = exc;
    }

    public int getReqId() {
        return this.req_id;
    }

    public int getErrorIndex() {
        return this.errind;
    }

    public int getErrorStatus() {
        return this.errstat;
    }

    public String getErrorStatusString() {
        String errString = "";
        if (this.errstat >= 0) {
            if (this.errstat < errorStrings.length) {
                errString = errorStrings[this.errstat];
                if (this.errstat == 5 && this.isTimedOut()) {
                    errString = TIMED_OUT;
                }
            } else {
                errString = this.respException != null ? this.respException.getMessage() : "Decoding Exception";
            }
        }
        return errString;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public boolean waitForSelf() {
        long del = 1000L;
        int i = 0;
        while (i < this.retry_intervals.length) {
            del += (long)this.retry_intervals[i];
            ++i;
        }
        boolean res = this.waitForSelf(del);
        if (AsnObject.debug > 6) {
            System.out.println("Pdu.waitForSelf(): " + res);
        }
        if (!this.answered) {
            this.handleNoAnswer();
        }
        return res;
    }

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean withRespVars) {
        varbind var;
        int i;
        int sz;
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("context=").append(this.context);
        buffer.append(", reqId=").append(this.req_id);
        buffer.append(", msgType=0x").append(SnmpUtilities.toHex(this.msg_type));
        buffer.append(", reqVarbinds=");
        if (this.reqVarbinds != null) {
            sz = this.reqVarbinds.size();
            buffer.append("[");
            i = 0;
            while (i < sz) {
                var = (varbind)this.reqVarbinds.elementAt(i);
                buffer.append(var.toString()).append(", ");
                ++i;
            }
            buffer.append("]");
        } else {
            buffer.append("null");
        }
        if (withRespVars) {
            buffer.append(", respVarbinds=");
            if (this.respVarbinds != null) {
                sz = this.respVarbinds.size();
                buffer.append("[");
                i = 0;
                while (i < sz) {
                    var = (varbind)this.respVarbinds.elementAt(i);
                    buffer.append(var.toString()).append(", ");
                    ++i;
                }
            } else {
                buffer.append("null");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    synchronized boolean waitForSelf(long delay) {
        if (!this.got) {
            try {
                this.wait(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.answered;
    }

    void transmit() {
        this.transmit(true);
    }

    void transmit(boolean withRetries) {
        if (withRetries) {
            int n = 0;
            this.answered = false;
            while (!this.answered && n < this.retry_intervals.length) {
                this.sendme();
                try {
                    Thread.sleep(this.retry_intervals[n]);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
            if (!this.answered) {
                this.handleNoAnswer();
            }
        } else {
            this.sendme();
            this.answered = true;
        }
        if (!this.context.removePdu(this.req_id) && AsnObject.debug > 6) {
            System.out.println("Pdu.transmit(): Failed to remove " + this.req_id);
        }
    }

    void setTrans(Transmitter t) {
        this.trans = t;
    }

    public byte getMsgType() {
        return this.msg_type;
    }

    protected void setMsgType(byte type) {
        this.msg_type = type;
    }

    protected void setErrorStatus(int err) {
        this.errstat = err;
        if (AsnObject.debug > 6) {
            System.out.println("Pdu.setErrorStatus(): " + this.errstat);
        }
        if (this.errstat != 0) {
            this.setResponseException(new AgentException(this.getErrorStatusString()));
        }
    }

    protected void setErrorStatus(int err, PduException exc) {
        this.errstat = err;
        this.setResponseException(exc);
    }

    protected void setErrorIndex(int ind) {
        this.errind = ind;
    }

    private void handleNoAnswer() {
        if (AsnObject.debug > 6) {
            System.out.println("Pdu.handleNoAnswer()");
        }
        this.answered = true;
        this.isTimedOut = true;
        this.setErrorStatus(5);
        this.setErrorIndex(0);
        this.setChanged();
        this.tell_them();
        this.clearChanged();
        Pdu pdu = this;
        synchronized (pdu) {
            this.notify();
        }
    }

    void fillin(AsnPduSequence seq) {
        if (this.answered) {
            if (AsnObject.debug > 6) {
                System.out.println("Pdu.fillin(): Got a second answer to request " + this.req_id);
            }
            return;
        }
        if (seq != null) {
            if (seq.isCorrect) {
                int n = -1;
                try {
                    this.req_id = seq.getReqId();
                    this.setErrorStatus(seq.getWhatError());
                    this.setErrorIndex(seq.getWhereError());
                    AsnSequence varBind = seq.getVarBind();
                    int size = varBind.getObjCount();
                    this.respVarbinds = new Vector(size, 1);
                    n = 0;
                    while (n < size) {
                        AsnSequence varSeq = (AsnSequence)varBind.getObj(n);
                        varbind vb = new varbind(varSeq);
                        this.respVarbinds.addElement(vb);
                        this.new_value(n, vb);
                        ++n;
                    }
                }
                catch (Exception e) {
                    DecodingException exc = new DecodingException("Incorrect varbind list, element " + n);
                    this.setErrorStatus(20, exc);
                }
            } else {
                DecodingException exc = new DecodingException("Incorrect packet. No of bytes received less than packet length.");
                this.setErrorStatus(21, exc);
            }
        }
        this.setChanged();
        this.tell_them();
        this.clearChanged();
        Pdu pdu = this;
        synchronized (pdu) {
            this.got = true;
            this.answered = true;
            this.notify();
            if (this.trans != null) {
                this.trans.interruptMe();
            }
        }
    }

    public void notifyObservers(Object arg) {
        if (this.respException != null) {
            super.notifyObservers(this.respException);
        } else {
            super.notifyObservers(arg);
        }
    }
}

