/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.OneIntPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class InterfaceGetNextPdu
extends GetNextPdu_vec {
    private static final String version_id = "@(#)$Id: InterfaceGetNextPdu.java,v 3.14 2002/10/29 14:44:40 birgit Exp $ Copyright Westhawk Ltd";
    public static final String IFNUMBER = "1.3.6.1.2.1.2.1.0";
    public static final String SYS_UPTIME = "1.3.6.1.2.1.1.3";
    public static final String INDEX = "1.3.6.1.2.1.2.2.1.1";
    public static final String DESCR = "1.3.6.1.2.1.2.2.1.2";
    public static final String OPR_STATUS = "1.3.6.1.2.1.2.2.1.8";
    public static final String IN_OCTETS = "1.3.6.1.2.1.2.2.1.10";
    public static final String OUT_OCTETS = "1.3.6.1.2.1.2.2.1.16";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String TESTING = "testing";
    public static final String UNKNOWN = "unknown";
    static final int NR_OID = 6;
    static final String[] inf_oids = new String[]{"1.3.6.1.2.1.1.3", "1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.8", "1.3.6.1.2.1.2.2.1.10", "1.3.6.1.2.1.2.2.1.16"};
    private varbind[] inf_var = new varbind[6];
    int index;
    long sysUpTime;
    int operStatus;
    long inOctets;
    long outOctets;
    long speed;
    String descr;
    boolean valid = false;

    public InterfaceGetNextPdu(SnmpContextBasisFace con) {
        super(con, 6);
        int i = 0;
        while (i < 6) {
            this.inf_var[i] = null;
            ++i;
        }
        this.speed = 0L;
        this.valid = false;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDescription() {
        return this.descr;
    }

    public int getOperStatus() {
        return this.operStatus;
    }

    public String getOperStatusString() {
        return this.getOperStatusString(this.operStatus);
    }

    public String getOperStatusString(int status) {
        String str = null;
        switch (status) {
            case 1: {
                str = UP;
                break;
            }
            case 2: {
                str = DOWN;
                break;
            }
            case 3: {
                str = TESTING;
                break;
            }
            default: {
                str = UNKNOWN;
            }
        }
        return str;
    }

    public long getSpeed() {
        return this.speed;
    }

    public long getSpeed(InterfaceGetNextPdu old) {
        this.speed = -1L;
        if (this.operStatus < 1 || old.operStatus < 1 || !this.valid || !old.valid) {
            return -1L;
        }
        long tdif = this.sysUpTime - old.sysUpTime;
        if (tdif != 0L) {
            long inO = this.inOctets - old.inOctets;
            long outO = this.outOctets - old.outOctets;
            this.speed = 100L * (inO + outO) / tdif;
        }
        return this.speed;
    }

    public boolean addOids() {
        int i = 0;
        while (i < 6) {
            this.inf_var[i] = new varbind(inf_oids[i]);
            this.addOid(this.inf_var[i]);
            ++i;
        }
        return true;
    }

    public void addOids(InterfaceGetNextPdu old) {
        this.inf_var[0] = new varbind(SYS_UPTIME);
        int i = 1;
        while (i < 6) {
            this.inf_var[i] = old.inf_var[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 6) {
            this.addOid(this.inf_var[i2]);
            ++i2;
        }
    }

    protected void new_value(int n, varbind res) {
        this.inf_var[n] = res;
        if (this.getErrorStatus() == 0) {
            if (this.inf_var[n].getOid().toString().startsWith(inf_oids[n])) {
                try {
                    switch (n) {
                        case 0: {
                            this.sysUpTime = ((AsnUnsInteger)this.inf_var[n].getValue()).getValue();
                            break;
                        }
                        case 1: {
                            this.index = ((AsnInteger)this.inf_var[n].getValue()).getValue();
                            break;
                        }
                        case 2: {
                            this.descr = ((AsnOctets)this.inf_var[n].getValue()).getValue();
                            break;
                        }
                        case 3: {
                            this.operStatus = ((AsnInteger)this.inf_var[n].getValue()).getValue();
                            break;
                        }
                        case 4: {
                            this.inOctets = ((AsnUnsInteger)this.inf_var[n].getValue()).getValue();
                            break;
                        }
                        case 5: {
                            this.outOctets = ((AsnUnsInteger)this.inf_var[n].getValue()).getValue();
                            this.valid = true;
                            break;
                        }
                        default: {
                            this.valid = false;
                            break;
                        }
                    }
                }
                catch (ClassCastException exc) {
                    this.descr = null;
                    this.index = 0;
                    this.sysUpTime = 0L;
                    this.operStatus = 0;
                    this.inOctets = 0L;
                    this.outOctets = 0L;
                    this.valid = false;
                }
            } else {
                this.setErrorStatus(2);
                this.setErrorIndex(n);
            }
        }
    }

    public String toString() {
        String str = new String();
        int i = 0;
        while (i < 6) {
            str = str + this.inf_var[i] + "\n";
            ++i;
        }
        return str;
    }

    public static int getNumIfs(SnmpContextBasisFace con) throws PduException, IOException {
        OneIntPdu numIfs;
        int ifNumber = 0;
        if (con != null && (numIfs = new OneIntPdu(con, IFNUMBER)).waitForSelf()) {
            ifNumber = numIfs.getValue();
        }
        return ifNumber;
    }
}

