/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class ValueReference
extends MibValue {
    private FileLocation location;
    private MibContext context;
    private String name;

    public ValueReference(FileLocation location, MibContext context, String name) {
        super("ReferenceToValue(" + name + ")");
        this.location = location;
        this.context = context;
        this.name = name;
    }

    public MibValue initialize(MibLoaderLog log) throws MibException {
        MibSymbol symbol = this.context.getSymbol(this.name);
        if (symbol instanceof MibValueSymbol) {
            MibValue value = ((MibValueSymbol)symbol).getValue().initialize(log);
            try {
                value = value.createReference();
            }
            catch (UnsupportedOperationException e) {
                throw new MibException(this.location, e.getMessage());
            }
            if (!(value instanceof ObjectIdentifierValue)) {
                value.setReferenceSymbol((MibValueSymbol)symbol);
            }
            return value;
        }
        if (symbol == null) {
            String message = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        String message = "referenced symbol '" + this.name + "' is not a value";
        throw new MibException(this.location, message);
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public Object toObject() {
        return null;
    }

    public String toString() {
        return "ReferenceToValue(" + this.name + ")";
    }
}

