/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class TypeReference
extends MibType
implements MibContext {
    private FileLocation location;
    private MibContext context;
    private String name;
    private MibType type = null;
    private Constraint constraint = null;
    private ArrayList values = null;
    private MibTypeTag tag = null;
    private boolean implicitTag = true;

    public TypeReference(FileLocation location, MibContext context, String name) {
        super("ReferenceToType(" + name + ")", false);
        this.location = location;
        this.context = context;
        this.name = name;
    }

    public TypeReference(FileLocation location, MibContext context, String name, Constraint constraint) {
        this(location, context, name);
        this.constraint = constraint;
    }

    public TypeReference(FileLocation location, MibContext context, String name, ArrayList values) {
        this(location, context, name);
        this.values = values;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        MibSymbol ref = this.context.getSymbol(this.name);
        if (ref instanceof MibTypeSymbol) {
            this.type = this.initialize(symbol, log, (MibTypeSymbol)ref);
            return this.type;
        }
        if (ref == null) {
            String message = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        String message = "referenced symbol '" + this.name + "' is not a type";
        throw new MibException(this.location, message);
    }

    private MibType initialize(MibSymbol symbol, MibLoaderLog log, MibTypeSymbol ref) throws MibException {
        MibType type = ref.getType();
        type = type.initialize(symbol, log);
        try {
            type = this.constraint != null ? type.createReference(this.constraint) : (this.values != null ? type.createReference(this.values) : type.createReference());
            type = type.initialize(symbol, log);
        }
        catch (UnsupportedOperationException e) {
            throw new MibException(this.location, e.getMessage());
        }
        type.setReferenceSymbol(ref);
        this.initializeTypeTag(type, this.tag);
        return type;
    }

    private void initializeTypeTag(MibType type, MibTypeTag tag) {
        if (tag != null) {
            if (tag.getNext() == null) {
                type.setTag(this.implicitTag, tag);
            } else {
                this.initializeTypeTag(type, tag.getNext());
                type.setTag(false, tag);
            }
        }
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public MibSymbol getSymbol(String name) {
        if (this.type instanceof MibContext) {
            return ((MibContext)((Object)this.type)).getSymbol(name);
        }
        return null;
    }

    public void setTag(boolean implicit, MibTypeTag tag) {
        if (this.tag == null) {
            this.tag = tag;
            this.implicitTag = implicit;
        } else if (implicit) {
            tag.setNext(this.tag.getNext());
            this.tag = tag;
        } else {
            tag.setNext(this.tag);
            this.tag = tag;
        }
    }
}

