/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibValueSymbol
extends MibSymbol {
    private MibType type;
    private MibValue value;

    public MibValueSymbol(FileLocation location, Mib mib, String name, MibType type, MibValue value) {
        super(location, mib, name);
        this.type = type;
        this.value = value;
    }

    public void initialize(MibLoaderLog log) throws MibException {
        if (this.type != null) {
            this.type = this.type.initialize(this, log);
        }
        if (this.value != null) {
            this.value = this.value.initialize(log);
        }
        if (this.type != null && this.value != null && !this.type.isCompatible(this.value)) {
            throw new MibException(this.getLocation(), "value is not compatible with type");
        }
        if (this.value instanceof ObjectIdentifierValue) {
            ((ObjectIdentifierValue)this.value).setSymbol(this);
        }
    }

    public MibType getType() {
        return this.type;
    }

    public MibValue getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("VALUE ");
        buffer.append(this.getName());
        buffer.append(" ");
        buffer.append(this.getType());
        buffer.append("\n    ::= ");
        buffer.append(this.getValue());
        return buffer.toString();
    }
}

