/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExp;
import net.percederberg.grammatica.parser.re.RegExpException;

public class Tokenizer {
    private boolean useTokenList = false;
    private StringTokenMatcher stringMatcher = new StringTokenMatcher();
    private ArrayList regexpMatchers = new ArrayList();
    private Reader input = null;
    private CharBuffer buffer = new CharBuffer();
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private boolean endOfBuffer = false;
    private Token previousToken = null;

    public Tokenizer(Reader input) {
        this.input = input;
    }

    public boolean getUseTokenList() {
        return this.useTokenList;
    }

    public void setUseTokenList(boolean useTokenList) {
        this.useTokenList = useTokenList;
    }

    public String getPatternDescription(int id) {
        TokenPattern pattern = this.stringMatcher.getPattern(id);
        if (pattern != null) {
            return pattern.toShortString();
        }
        for (int i = 0; i < this.regexpMatchers.size(); ++i) {
            RegExpTokenMatcher re = (RegExpTokenMatcher)this.regexpMatchers.get(i);
            if (re.getPattern().getId() != id) continue;
            return re.getPattern().toShortString();
        }
        return null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void addPattern(TokenPattern pattern) throws ParserCreationException {
        switch (pattern.getType()) {
            case 1: {
                this.stringMatcher.addPattern(pattern);
                break;
            }
            case 2: {
                try {
                    this.regexpMatchers.add(new RegExpTokenMatcher(pattern));
                    break;
                }
                catch (RegExpException e) {
                    throw new ParserCreationException(2, pattern.getName(), "regular expression contains error(s): " + e.getMessage());
                }
            }
            default: {
                throw new ParserCreationException(2, pattern.getName(), "pattern type " + pattern.getType() + " is undefined");
            }
        }
    }

    public Token next() throws ParseException {
        Token token = null;
        do {
            token = this.nextToken();
            if (this.useTokenList && token != null) {
                token.setPreviousToken(this.previousToken);
                this.previousToken = token;
            }
            if (token == null) {
                return null;
            }
            if (token.getPattern().isError()) {
                throw new ParseException(5, token.getPattern().getErrorMessage(), token.getStartLine(), token.getStartColumn());
            }
            if (!token.getPattern().isIgnore()) continue;
            token = null;
        } while (token == null);
        return token;
    }

    private Token nextToken() throws ParseException {
        TokenMatcher m;
        do {
            if (this.endOfBuffer) {
                this.readInput();
                this.endOfBuffer = false;
            }
            m = this.findMatch();
        } while (this.endOfBuffer && this.input != null);
        if (m != null) {
            String str = this.buffer.substring(this.position, this.position + m.getMatchedLength());
            Token token = new Token(m.getMatchedPattern(), str, this.line, this.column);
            this.position += m.getMatchedLength();
            this.line = token.getEndLine();
            this.column = token.getEndColumn() + 1;
            return token;
        }
        if (this.position >= this.buffer.length()) {
            return null;
        }
        ParseException e = new ParseException(3, String.valueOf(this.buffer.charAt(this.position)), this.line, this.column);
        if (this.buffer.charAt(this.position) == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        ++this.position;
        throw e;
    }

    private void readInput() throws ParseException {
        int length;
        char[] chars = new char[4096];
        if (this.input == null) {
            return;
        }
        if (this.position > 1024) {
            this.buffer.delete(0, this.position);
            this.position = 0;
        }
        try {
            length = this.input.read(chars);
        }
        catch (IOException e) {
            this.input = null;
            throw new ParseException(1, e.getMessage(), -1, -1);
        }
        if (length > 0) {
            this.buffer.append(chars, 0, length);
        }
        if (length < chars.length) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }

    private TokenMatcher findMatch() {
        TokenMatcher bestMatch = null;
        int bestLength = 0;
        if (this.stringMatcher.matchFrom(this.position)) {
            bestMatch = this.stringMatcher;
            bestLength = bestMatch.getMatchedLength();
        }
        if (this.stringMatcher.hasReadEndOfString()) {
            this.endOfBuffer = true;
        }
        for (int i = 0; i < this.regexpMatchers.size(); ++i) {
            RegExpTokenMatcher re = (RegExpTokenMatcher)this.regexpMatchers.get(i);
            if (re.matchFrom(this.position) && re.getMatchedLength() > bestLength) {
                bestMatch = re;
                bestLength = bestMatch.getMatchedLength();
            }
            if (!re.hasReadEndOfString()) continue;
            this.endOfBuffer = true;
        }
        return bestMatch;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stringMatcher);
        for (int i = 0; i < this.regexpMatchers.size(); ++i) {
            buffer.append(this.regexpMatchers.get(i));
        }
        return buffer.toString();
    }

    private class AutomatonTree {
        private char value = '\u0000';
        private Automaton state = null;
        private AutomatonTree left = null;
        private AutomatonTree right = null;

        public Automaton find(char c) {
            if (this.value == '\u0000' || this.value == c) {
                return this.state;
            }
            if (this.value > c) {
                return this.left.find(c);
            }
            return this.right.find(c);
        }

        public void add(char c, Automaton state) {
            if (this.value == '\u0000') {
                this.value = c;
                this.state = state;
                this.left = new AutomatonTree();
                this.right = new AutomatonTree();
            } else if (this.value > c) {
                this.left.add(c, state);
            } else {
                this.right.add(c, state);
            }
        }
    }

    private class Automaton {
        private Object value = null;
        private AutomatonTree tree = new AutomatonTree();

        public void addMatch(String str, Object value) {
            if (str.equals("")) {
                this.value = value;
            } else {
                Automaton state = this.tree.find(str.charAt(0));
                if (state == null) {
                    state = new Automaton();
                    state.addMatch(str.substring(1), value);
                    this.tree.add(str.charAt(0), state);
                } else {
                    state.addMatch(str.substring(1), value);
                }
            }
        }

        public Object matchFrom(StringTokenMatcher m, int pos) {
            Automaton state;
            Object result = null;
            if (pos >= Tokenizer.this.buffer.length()) {
                m.setReadEndOfString();
            } else if (this.tree != null && (state = this.tree.find(Tokenizer.this.buffer.charAt(pos))) != null) {
                result = state.matchFrom(m, pos + 1);
            }
            return result == null ? this.value : result;
        }
    }

    private class StringTokenMatcher
    extends TokenMatcher {
        private ArrayList patterns = new ArrayList();
        private Automaton start = new Automaton();
        private TokenPattern match = null;
        private boolean endOfString = false;

        public void reset() {
            this.match = null;
            this.endOfString = false;
        }

        public TokenPattern getMatchedPattern() {
            return this.match;
        }

        public int getMatchedLength() {
            if (this.match == null) {
                return 0;
            }
            return this.match.getPattern().length();
        }

        public boolean hasReadEndOfString() {
            return this.endOfString;
        }

        public void setReadEndOfString() {
            this.endOfString = true;
        }

        public TokenPattern getPattern(int id) {
            for (int i = 0; i < this.patterns.size(); ++i) {
                TokenPattern pattern = (TokenPattern)this.patterns.get(i);
                if (pattern.getId() != id) continue;
                return pattern;
            }
            return null;
        }

        public void addPattern(TokenPattern pattern) {
            this.patterns.add(pattern);
            this.start.addMatch(pattern.getPattern(), pattern);
        }

        public boolean matchFrom(int pos) {
            this.reset();
            this.match = (TokenPattern)this.start.matchFrom(this, pos);
            return this.match != null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.patterns.size(); ++i) {
                buffer.append(this.patterns.get(i));
                buffer.append("\n\n");
            }
            return buffer.toString();
        }
    }

    private class RegExpTokenMatcher
    extends TokenMatcher {
        private TokenPattern pattern;
        private RegExp regExp;
        private Matcher matcher;

        public RegExpTokenMatcher(TokenPattern pattern) throws RegExpException {
            this.pattern = pattern;
            this.regExp = new RegExp(pattern.getPattern());
            this.matcher = this.regExp.matcher(Tokenizer.this.buffer);
        }

        public TokenPattern getPattern() {
            return this.pattern;
        }

        public int start() {
            if (this.matcher.length() <= 0) {
                return 0;
            }
            return this.matcher.start();
        }

        public TokenPattern getMatchedPattern() {
            if (this.matcher.length() <= 0) {
                return null;
            }
            return this.pattern;
        }

        public int getMatchedLength() {
            return this.matcher.length();
        }

        public boolean hasReadEndOfString() {
            return this.matcher.hasReadEndOfString();
        }

        public boolean matchFrom(int pos) {
            return this.matcher.matchFrom(pos);
        }

        public String toString() {
            return this.pattern.toString() + "\n" + this.regExp.toString() + "\n";
        }
    }

    private abstract class TokenMatcher {
        private TokenMatcher() {
        }

        public abstract TokenPattern getMatchedPattern();

        public abstract int getMatchedLength();

        public abstract boolean hasReadEndOfString();
    }
}

