/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaPackage;
import net.percederberg.grammatica.output.JavaAnalyzerFile;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserFile;
import net.percederberg.grammatica.output.JavaTokenizerFile;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class JavaParserGenerator
extends ParserGenerator {
    private String basePackage = null;
    private String baseName = null;
    private boolean publicAccess = false;
    private String classComment = null;

    public JavaParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String str = this.getGrammar().getFileName();
        if (str.indexOf(47) >= 0) {
            str = str.substring(str.lastIndexOf(47) + 1);
        }
        if (str.indexOf(92) >= 0) {
            str = str.substring(str.lastIndexOf(92) + 1);
        }
        if (str.indexOf(46) > 0) {
            str = str.substring(0, str.indexOf(46));
        }
        if (Character.isLowerCase(str.charAt(0))) {
            str = Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }
        this.baseName = str;
        StringBuffer buffer = new StringBuffer();
        str = this.getGrammar().getDeclaration("AUTHOR");
        if (str != null) {
            buffer.append("@author   ");
            buffer.append(str);
        }
        if ((str = this.getGrammar().getDeclaration("VERSION")) != null) {
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append("@version  ");
            buffer.append(str);
        }
        this.classComment = buffer.toString();
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String pkg) {
        this.basePackage = pkg;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    public boolean getPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean flag) {
        this.publicAccess = flag;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.JAVA;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public void write() throws IOException {
        ProductionPattern production;
        int i;
        Grammar grammar = this.getGrammar();
        JavaConstantsFile constants = new JavaConstantsFile(this);
        JavaTokenizerFile tokenizer = new JavaTokenizerFile(this);
        JavaParserFile parser = new JavaParserFile(this, tokenizer);
        JavaAnalyzerFile analyzer = new JavaAnalyzerFile(this);
        for (i = 0; i < grammar.getTokenPatternCount(); ++i) {
            TokenPattern token = grammar.getTokenPattern(i);
            constants.addToken(token);
            tokenizer.addToken(token, constants);
            analyzer.addToken(token, constants);
        }
        for (i = 0; i < grammar.getProductionPatternCount(); ++i) {
            production = grammar.getProductionPattern(i);
            constants.addProduction(production);
            parser.addProductionConstant(production);
            analyzer.addProduction(production, constants);
        }
        for (i = 0; i < grammar.getProductionPatternCount(); ++i) {
            production = grammar.getProductionPattern(i);
            parser.addProduction(production, constants);
        }
        constants.writeCode();
        tokenizer.writeCode();
        parser.writeCode();
        analyzer.writeCode();
    }

    public JavaFile createJavaFile() {
        if (this.basePackage == null) {
            return new JavaFile(this.getBaseDir());
        }
        return new JavaFile(this.getBaseDir(), new JavaPackage(this.getBasePackage()));
    }
}

