/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpObjectType
implements MibType {
    private MibType syntax;
    private String units;
    private SnmpAccess access;
    private SnmpStatus status;
    private String description;
    private String reference;
    private ArrayList index;
    private MibValue augments;
    private MibValue defaultValue;

    public SnmpObjectType(MibType syntax, String units, SnmpAccess access, SnmpStatus status, String description, String reference, ArrayList index, MibValue defaultValue) {
        this.syntax = syntax;
        this.units = units;
        this.access = access;
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.index = index;
        this.augments = null;
        this.defaultValue = defaultValue;
    }

    public SnmpObjectType(MibType syntax, String units, SnmpAccess access, SnmpStatus status, String description, String reference, MibValue augments, MibValue defaultValue) {
        this.syntax = syntax;
        this.units = units;
        this.access = access;
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.index = new ArrayList();
        this.augments = augments;
        this.defaultValue = defaultValue;
    }

    public MibType initialize(MibLoaderLog log) throws MibException {
        ArrayList<Object> list = new ArrayList<Object>();
        this.syntax = this.syntax.initialize(log);
        for (int i = 0; i < this.index.size(); ++i) {
            Object obj = this.index.get(i);
            if (obj instanceof MibValue) {
                list.add(((MibValue)obj).initialize(log));
                continue;
            }
            list.add(((MibType)obj).initialize(log));
        }
        this.index = list;
        if (this.augments != null) {
            this.augments = this.augments.initialize(log);
        }
        if (this.defaultValue != null) {
            this.defaultValue = this.defaultValue.initialize(log);
        }
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public String getUnits() {
        return this.units;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getIndex() {
        return this.index;
    }

    public MibValue getAugments() {
        return this.augments;
    }

    public MibValue getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OBJECT-TYPE (");
        buffer.append("\n  Syntax: ");
        buffer.append(this.syntax);
        if (this.units != null) {
            buffer.append("\n  Units: ");
            buffer.append(this.units);
        }
        buffer.append("\n  Access: ");
        buffer.append(this.access);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        if (this.description != null) {
            buffer.append("\n  Description: ");
            buffer.append(this.description);
        }
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        if (this.index.size() > 0) {
            buffer.append("\n  Index: ");
            buffer.append(this.index);
        }
        if (this.augments != null) {
            buffer.append("\n  Augments: ");
            buffer.append(this.augments);
        }
        if (this.defaultValue != null) {
            buffer.append("\n  Default Value: ");
            buffer.append(this.defaultValue);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

