/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.LogEntry;
import net.percederberg.mibble.LogPrinter;
import net.percederberg.mibble.SimpleLogPrinter;

public class MibLoaderLog {
    private ArrayList entries = new ArrayList();
    private int errors = 0;
    private int warnings = 0;

    public int errorCount() {
        return this.errors;
    }

    public int warningCount() {
        return this.warnings;
    }

    public void add(LogEntry entry) {
        if (entry.isError()) {
            ++this.errors;
        }
        if (entry.isWarning()) {
            ++this.warnings;
        }
        this.entries.add(entry);
    }

    public void addInternalError(FileLocation location, String message) {
        this.add(new LogEntry(1, location, message));
    }

    public void addInternalError(File file, String message) {
        this.addInternalError(new FileLocation(file), message);
    }

    public void addError(FileLocation location, String message) {
        this.add(new LogEntry(2, location, message));
    }

    public void addError(File file, int line, int column, String message) {
        this.addError(new FileLocation(file, line, column), message);
    }

    public void addWarning(FileLocation location, String message) {
        this.add(new LogEntry(3, location, message));
    }

    public void addWarning(File file, int line, int column, String message) {
        this.addWarning(new FileLocation(file, line, column), message);
    }

    public void addAll(MibLoaderLog log) {
        for (int i = 0; i < log.entries.size(); ++i) {
            this.add((LogEntry)log.entries.get(i));
        }
    }

    void addAll(File file, ParserLogException log) {
        for (int i = 0; i < log.getErrorCount(); ++i) {
            ParseException e = log.getError(i);
            this.addError(file, e.getLine(), e.getColumn(), e.getErrorMessage());
        }
    }

    public void printTo(PrintStream output) {
        this.printTo(new PrintWriter(output));
    }

    public void printTo(PrintWriter output) {
        this.printTo(new SimpleLogPrinter(output, 70));
    }

    public void printTo(LogPrinter printer) {
        for (int i = 0; i < this.entries.size(); ++i) {
            printer.print((LogEntry)this.entries.get(i));
        }
    }
}

