/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.output.CSharpAnalyzerFile;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserFile;
import net.percederberg.grammatica.output.CSharpTokenizerFile;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class CSharpParserGenerator
extends ParserGenerator {
    private String baseName = null;
    private String namespace = null;
    private boolean publicAccess = false;

    public CSharpParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String str = this.getGrammar().getFileName();
        if (str.indexOf(47) >= 0) {
            str = str.substring(str.lastIndexOf(47) + 1);
        }
        if (str.indexOf(92) >= 0) {
            str = str.substring(str.lastIndexOf(92) + 1);
        }
        if (str.indexOf(46) > 0) {
            str = str.substring(0, str.indexOf(46));
        }
        if (Character.isLowerCase(str.charAt(0))) {
            str = Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }
        this.baseName = str;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    public boolean getPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean flag) {
        this.publicAccess = flag;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.CSHARP;
    }

    public void write() throws IOException {
        ProductionPattern production;
        Grammar grammar = this.getGrammar();
        CSharpConstantsFile constants = new CSharpConstantsFile(this);
        CSharpTokenizerFile tokenizer = new CSharpTokenizerFile(this);
        CSharpParserFile parser = new CSharpParserFile(this, tokenizer);
        CSharpAnalyzerFile analyzer = new CSharpAnalyzerFile(this);
        int i = 0;
        while (i < grammar.getTokenPatternCount()) {
            TokenPattern token = grammar.getTokenPattern(i);
            constants.addToken(token);
            tokenizer.addToken(token, constants);
            analyzer.addToken(token, constants);
            ++i;
        }
        i = 0;
        while (i < grammar.getProductionPatternCount()) {
            production = grammar.getProductionPattern(i);
            constants.addProduction(production);
            parser.addProductionConstant(production);
            analyzer.addProduction(production, constants);
            ++i;
        }
        i = 0;
        while (i < grammar.getProductionPatternCount()) {
            production = grammar.getProductionPattern(i);
            parser.addProduction(production, constants);
            ++i;
        }
        constants.writeCode();
        tokenizer.writeCode();
        parser.writeCode();
        analyzer.writeCode();
    }
}

