/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

abstract class JavaType
extends CodeElementContainer {
    private int modifiers;
    private String name;
    private String extendType;
    private String[] implementTypes = null;
    private JavaComment comment = null;

    protected JavaType(int modifiers, String name, String extendsType, String implementType) {
        this.modifiers = modifiers;
        this.name = name;
        this.extendType = extendsType;
        if (implementType == null || implementType.equals("")) {
            this.implementTypes = new String[0];
        } else {
            this.implementTypes = new String[1];
            this.implementTypes[0] = implementType;
        }
    }

    protected JavaType(int modifiers, String name, String extendsType, String[] implementTypes) {
        this.modifiers = modifiers;
        this.name = name;
        this.extendType = extendsType;
        this.implementTypes = implementTypes;
    }

    public String toString() {
        return this.name;
    }

    public void addComment(JavaComment comment) {
        this.comment = comment;
    }

    protected void print(PrintWriter out, CodeStyle style, int indent, String type) {
        String str;
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer buf = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        buf.append(indentStr);
        buf.append(JavaModifier.createModifierDecl(this.modifiers));
        buf.append(type);
        buf.append(" ");
        buf.append(this.name);
        if (this.extendType != null && !this.extendType.equals("")) {
            buf.append(" extends ");
            buf.append(this.extendType);
        }
        if ((str = this.createImplDecl()).length() > 0) {
            if (buf.length() + str.length() > style.getMargin()) {
                buf.append("\n");
                buf.append(codeIndentStr);
            } else {
                buf.append(" ");
            }
            buf.append(str);
        }
        buf.append(" {");
        out.println(buf.toString());
        out.println();
        this.printContents(out, style, indent + 1);
        out.println(indentStr + "}");
    }

    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
        if (prev != null && next != null) {
            out.println();
        }
    }

    private String createImplDecl() {
        StringBuffer res = new StringBuffer("implements ");
        if (this.implementTypes == null || this.implementTypes.length <= 0) {
            return "";
        }
        int i = 0;
        while (i < this.implementTypes.length) {
            res.append(this.implementTypes[i]);
            if (i + 1 < this.implementTypes.length) {
                res.append(", ");
            }
            ++i;
        }
        return res.toString();
    }
}

