/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import net.percederberg.grammatica.FirstPassAnalyzer;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.GrammarParser;
import net.percederberg.grammatica.SecondPassAnalyzer;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.RecursiveDescentParser;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammar {
    public static final String AUTHOR_DECLARATION = "AUTHOR";
    public static final String COPYRIGHT_DECLARATION = "COPYRIGHT";
    public static final String DATE_DECLARATION = "DATE";
    public static final String DESCRIPTION_DECLARATION = "DESCRIPTION";
    public static final String GRAMMAR_TYPE_DECLARATION = "GRAMMARTYPE";
    public static final String LICENSE_DECLARATION = "LICENSE";
    public static final String VERSION_DECLARATION = "VERSION";
    private String fileName = "";
    private HashMap declarations = new HashMap();
    private Vector tokens = new Vector();
    private HashMap tokenIds = new HashMap();
    private HashMap tokenNames = new HashMap();
    private HashMap tokenPatterns = new HashMap();
    private Vector productions = new Vector();
    private HashMap productionIds = new HashMap();
    private HashMap productionNames = new HashMap();
    private HashMap lines = new HashMap();

    public Grammar(File file) throws FileNotFoundException, ParserLogException, GrammarException {
        FirstPassAnalyzer first = new FirstPassAnalyzer(this);
        SecondPassAnalyzer second = new SecondPassAnalyzer(this);
        this.fileName = file.toString();
        try {
            GrammarParser parser = new GrammarParser(new FileReader(file), (Analyzer)first);
            second.analyze(parser.parse());
        }
        catch (ParserCreationException e) {
            throw new UnsupportedOperationException("internal error in grammar parser: " + e.getMessage());
        }
        this.verify();
    }

    private void verify() throws GrammarException {
        String type = (String)this.declarations.get(GRAMMAR_TYPE_DECLARATION);
        if (type == null) {
            throw new GrammarException(this.fileName, "grammar header missing GRAMMARTYPE declaration");
        }
        if (!type.equals("LL")) {
            throw new GrammarException(this.fileName, "unrecognized GRAMMARTYPE value: '" + type + "', currently only 'LL' is supported");
        }
        if (this.productions.size() > 0) {
            this.createParser(this.createTokenizer(null));
        }
    }

    public Tokenizer createTokenizer(Reader in) throws GrammarException {
        Tokenizer tokenizer;
        try {
            tokenizer = new Tokenizer(in);
            int i = 0;
            while (i < this.tokens.size()) {
                tokenizer.addPattern((TokenPattern)this.tokens.get(i));
                ++i;
            }
        }
        catch (ParserCreationException e) {
            if (e.getName() == null) {
                throw new GrammarException(this.fileName, e.getMessage());
            }
            LineRange range = (LineRange)this.lines.get(e.getName());
            throw new GrammarException(this.fileName, e.getMessage(), range.getStart(), range.getEnd());
        }
        return tokenizer;
    }

    public Parser createParser(Tokenizer tokenizer) throws GrammarException {
        return this.createParser(tokenizer, null);
    }

    public Parser createParser(Tokenizer tokenizer, Analyzer analyzer) throws GrammarException {
        RecursiveDescentParser parser;
        try {
            parser = new RecursiveDescentParser(tokenizer, analyzer);
            int i = 0;
            while (i < this.productions.size()) {
                ((Parser)parser).addPattern((ProductionPattern)this.productions.get(i));
                ++i;
            }
            ((Parser)parser).prepare();
        }
        catch (ParserCreationException e) {
            LineRange range = (LineRange)this.lines.get(e.getName());
            if (range == null) {
                throw new GrammarException(this.fileName, e.getMessage());
            }
            throw new GrammarException(this.fileName, e.getMessage(), range.getStart(), range.getEnd());
        }
        return parser;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDeclaration(String name) {
        return (String)this.declarations.get(name);
    }

    public int getTokenPatternCount() {
        return this.tokens.size();
    }

    public TokenPattern getTokenPattern(int pos) {
        return (TokenPattern)this.tokens.get(pos);
    }

    public TokenPattern getTokenPatternById(int id) {
        return (TokenPattern)this.tokenIds.get(new Integer(id));
    }

    public TokenPattern getTokenPatternByName(String name) {
        return (TokenPattern)this.tokenNames.get(name);
    }

    TokenPattern getTokenPatternByImage(String image) {
        return (TokenPattern)this.tokenPatterns.get(image);
    }

    public int getProductionPatternCount() {
        return this.productions.size();
    }

    public ProductionPattern getProductionPattern(int pos) {
        return (ProductionPattern)this.productions.get(pos);
    }

    public ProductionPattern getProductionPatternById(int id) {
        return (ProductionPattern)this.productionIds.get(new Integer(id));
    }

    public ProductionPattern getProductionPatternByName(String name) {
        return (ProductionPattern)this.productionNames.get(name);
    }

    void addDeclaration(String name, String value) {
        this.declarations.put(name, value);
    }

    void addToken(TokenPattern token, int start, int end) {
        this.tokens.add(token);
        this.tokenIds.put(new Integer(token.getId()), token);
        this.tokenNames.put(token.getName(), token);
        if (token.getType() == 1) {
            this.tokenPatterns.put(token.getPattern(), token);
        }
        this.lines.put(token.getName(), new LineRange(start, end));
    }

    void addProduction(ProductionPattern production, int start, int end) {
        this.productions.add(production);
        this.productionIds.put(new Integer(production.getId()), production);
        this.productionNames.put(production.getName(), production);
        this.lines.put(production.getName(), new LineRange(start, end));
    }

    private class LineRange {
        private int start;
        private int end;

        public LineRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

