#line 2 "recordList.c"
#line 70 "../parser/recordList.l"
/*=======================================================================
* Version: this file is generated by LEX using recordList.l
 * Project: Mediatex
 * Module : recordList reentrant scanner

 * recordList scanner
 * Note: Please provide an archive by line from input file

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

=======================================================================*/

#include "../mediatex.h"
#include "../misc/log.h"
#include "../memory/strdsm.h"
#include "../memory/recordTree.h"

#ifndef utMAIN
#include "../misc/cypher.h"
#include "recordList.tab.h"
#include <sys/socket.h> //
#include <netinet/in.h> // inet_aton
#include <arpa/inet.h>  //
#endif	/*	: utMAIN	*/

typedef struct RecordExtra {
  int            lineNo;
  AESData*       aesData;
} RecordExtra;

// %union{} used by flex/bison to write/read values
typedef union BisonUnion {
  // lex token types
  Type   type;
  time_t time;
  off_t  size;
  char*  string;
  int    msgval;
  char   hash[MAX_SIZE_HASH+1];

  // bison token types
  Record*          record;
} BisonUnion;

#define YYSTYPE BisonUnion
#define YY_NO_INPUT // no warning



#line 67 "recordList.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */
/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* %endif */

/* %if-not-reentrant */
/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE record_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

/* %if-not-reentrant */
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via record_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

void record_restart (FILE *input_file ,yyscan_t yyscanner );
void record__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE record__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void record__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void record__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void record_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void record_pop_buffer_state (yyscan_t yyscanner );

static void record_ensure_buffer_stack (yyscan_t yyscanner );
static void record__load_buffer_state (yyscan_t yyscanner );
static void record__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER record__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE record__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE record__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE record__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

/* %endif */

void *record_alloc (yy_size_t ,yyscan_t yyscanner );
void *record_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void record_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer record__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        record_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            record__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        record_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            record__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define record_wrap(n) 1
#define YY_SKIP_YYWRAP

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	yyg->yy_c_buf_p = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 31
#define YY_END_OF_BUFFER 32
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[211] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   32,   30,   25,    2,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   28,
       31,   28,   15,   15,   15,   16,   30,   30,   30,   30,
       30,   18,   17,   30,   22,   23,   24,   30,   23,   23,
       25,    2,    1,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   26,   29,   15,
       15,   15,   16,   18,   17,    0,    0,    0,   22,   23,
       24,   23,   23,    0,   27,    0,    9,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   15,    0,    0,

        0,   23,   14,    0,    8,    0,   10,    0,    0,    0,
        7,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   11,
        6,    0,   12,    0,    0,    0,    0,    0,    3,   13,
        0,    0,    0,    0,    5,    0,    0,    0,    0,    0,
        0,    0,    4,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       19,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,   20,   21,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    5,    1,    1,    1,    1,    1,
        1,    6,    1,    7,    8,    1,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   11,    1,    1,
        1,    1,    1,    1,   12,   13,   14,   15,   16,   17,
       18,   19,   20,    1,   21,   22,    1,   23,   24,   25,
        1,   26,   27,   28,   29,   30,   31,    1,   32,    1,
        1,    1,    1,    1,    1,    1,   33,   34,   35,   36,

       37,   38,   39,   40,   41,    1,   42,   43,    1,   44,
       45,   46,    1,   47,   48,   49,   50,   51,   52,    1,
       53,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[285] =
    {   0,
        0,   49,    2,   14,   22,   77,   98,  662,  145,  661,
       36,   64,  114,  117,  665, 2721,  662, 2721,  654,    1,
       46,   85,   51,    0,  104,    5,   97,  119,  550, 2721,
     2721,  543,    0,  542,   53, 2721,  280,  137,  273,  271,
        0,    0, 2721,    0,  270,    0, 2721,  276,  269,   57,
      269, 2721, 2721,  267,    7,  125,  129,  126,  142,  137,
      156,  141,  144,  146,  154,  154,  265, 2721, 2721,    0,
      135,  191, 2721, 2721, 2721,  256,    0,    0,  255,    0,
     2721,  196,  199,  261, 2721,  152, 2721,  164,  166,  172,
      190,  194,  190,  181,  196,  190,  190,  213,  133,    0,

        0,  216, 2721,  205, 2721,  197, 2721,  207,  207,  210,
     2721,  204,  217,  133,  132,    0,  222,  218,  212,  207,
      214,  210,  231,  117,    0,    0,  220,  235,  225, 2721,
     2721,  230, 2721,   95,    0,    0,  234,  229, 2721, 2721,
       96,    0,    0,  232, 2721,   85,    0,    0,  240,   84,
        0,    0, 2721,   83,    0,    0,   78,    0,    0,   77,
        0,    0,   54,    0,    0,   37,    0,    0,   31,    0,
        0,   21,    0,    0,   20,    0,    0,    1,    0,    0,
     2721,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0, 2721, 2721, 2721,
      284,  337,  390,  443,  496,  549,  602,  646,  675,  713,
      766,  819,  872,  916,  945,  983, 1027, 1056, 1087, 1116,
     1145, 1174, 1203, 1232, 1261, 1290, 1319, 1348, 1377, 1406,
     1435, 1464, 1493, 1522, 1551, 1580, 1609, 1638, 1667, 1696,
     1725, 1754, 1783, 1812, 1841, 1870, 1899, 1928, 1957, 1986,
     2015, 2044, 2073, 2102, 2131, 2160, 2189, 2218, 2247, 2276,
     2305, 2334, 2363, 2392, 2421, 2450, 2479, 2508, 2537, 2566,
     2595, 2624, 2653, 2682
    } ;

static yyconst flex_int16_t yy_def[285] =
    {   0,
      211,  211,  212,  212,  213,  213,  211,    7,  211,    9,
      211,  211,  214,  214,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  215,  210,
      210,  210,  216,  216,  217,  210,  210,  210,  210,  218,
      218,  218,  210,  219,  210,  220,  210,  210,  220,  221,
      210,  210,  210,  222,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  215,  210,  210,  216,
      223,  217,  210,  210,  210,  224,  224,  225,  210,  220,
      210,  226,  221,  222,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  223,  227,  227,

      228,  226,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  229,  229,  230,  210,  210,  210,  210,
      210,  210,  210,  210,  231,  232,  210,  210,  210,  210,
      210,  210,  210,  210,  233,  234,  210,  210,  210,  210,
      210,  235,  236,  210,  210,  210,  237,  238,  210,  210,
      239,  240,  210,  210,  241,  242,  210,  243,  244,  210,
      245,  246,  210,  247,  248,  210,  249,  250,  210,  251,
      252,  210,  253,  254,  210,  255,  256,  210,  257,  258,
      210,  259,  260,  261,  262,  263,  264,  265,  266,  267,
      268,  269,  270,  271,  272,  273,  274,  275,  276,  277,

      278,  279,  280,  281,  282,  283,  284,  210,  210,    0,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210
    } ;

static yyconst flex_int16_t yy_nxt[2775] =
    {   0,
      210,   17,   18,   19,   31,   16,   53,   32,   20,   54,
      181,   60,   21,   22,   23,   61,   31,   16,   24,   32,
       63,   86,   25,   17,   31,   16,   26,   27,   28,  178,
       34,  175,   60,   21,   22,   23,   61,   17,   31,   24,
      172,   63,   86,   25,   39,   45,  169,   26,   27,   28,
       17,   18,   19,   29,   67,   68,   67,   20,   67,   68,
       67,   21,   22,   23,  166,   17,   31,   24,   29,   55,
       58,   25,   39,   45,   59,   26,   27,   28,   17,   31,
       16,   35,   21,   22,   23,   34,  163,  160,   24,  157,
       55,   58,   25,  154,  150,   59,   26,   27,   28,   17,

       36,   37,   56,  146,  141,   38,   39,   40,   57,   41,
       41,   41,   42,   41,   41,   17,   47,   48,   17,   47,
       48,   50,   49,   56,   43,   49,  134,   62,   64,   57,
       41,   41,   41,   42,   41,   41,   84,   85,   84,  210,
      124,   65,  114,   66,   87,   43,   17,   31,   62,   64,
       88,   74,   89,   39,   44,   90,   44,   44,   44,   44,
       44,   44,   65,   75,   66,   87,   91,   92,   93,   94,
       95,   88,   74,   89,   96,   97,   90,   44,   44,   44,
       44,   44,   44,  103,   75,  104,  105,   91,   92,   93,
       94,   95,   67,   68,   67,   96,   97,   84,   85,   84,

       67,   68,   67,  106,  103,  107,  104,  105,  108,  109,
      110,  111,  112,  113,   84,   85,   84,   84,   85,   84,
      117,  118,  119,  120,  106,  121,  107,  122,  123,  108,
      109,  110,  111,  112,  113,  127,  128,  129,  130,  131,
      132,  117,  118,  119,  120,  133,  121,  137,  122,  123,
      138,  139,  140,  144,  145,  149,  127,  128,  129,  130,
      131,  132,  153,   85,   79,   99,  133,   68,  137,   85,
       51,  138,  139,  140,  144,  145,  149,   82,   81,   79,
       76,   54,   73,  153,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,

       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,

       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   67,   67,   67,   67,

       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   70,
       71,   69,   68,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,

       70,   70,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   77,   52,   77,   77,   77,
       77,   77,   77,   51,  210,   29,   29,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,   77,   77,
       77,   77,   77,   77,   78,  210,   78,   78,   78,   78,
       78,   78,  210,  210,  210,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,   78,   78,   78,
       78,   78,   78,   80,  210,  210,  210,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,

       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,  100,  210,  100,  100,  100,
      100,  100,  100,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  100,  100,
      100,  100,  100,  100,  101,  210,  101,  101,  101,  101,
      101,  101,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  101,  101,  101,
      101,  101,  101,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,

      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  115,  210,  115,  115,
      115,  115,  115,  115,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  115,
      115,  115,  115,  115,  115,  116,  210,  116,  116,  116,
      116,  116,  116,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  116,  116,
      116,  116,  116,  116,  125,  210,  125,  210,  125,  125,

      125,  125,  125,  125,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  125,
      125,  125,  125,  125,  125,  126,  210,  126,  126,  126,
      126,  126,  126,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  126,  126,
      126,  126,  126,  126,  135,  210,  135,  135,  135,  135,
      135,  135,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  135,  135,  135,
      135,  135,  135,  136,  210,  136,  136,  136,  136,  136,
      136,  210,  210,  210,  210,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  136,  136,  136,  136,
      136,  136,  142,  210,  142,  142,  142,  142,  142,  142,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  142,  142,  142,  142,  142,
      142,  143,  210,  143,  143,  143,  143,  143,  143,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  143,  143,  143,  143,  143,  143,
      147,  210,  147,  147,  147,  147,  147,  147,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  147,  147,  147,  147,  147,  147,  148,

      210,  148,  148,  148,  148,  148,  148,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  148,  148,  148,  148,  148,  148,  151,  210,
      151,  151,  151,  151,  151,  151,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  151,  151,  151,  151,  151,  151,  152,  210,  152,
      152,  152,  152,  152,  152,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      152,  152,  152,  152,  152,  152,  155,  210,  155,  155,
      155,  155,  155,  155,  210,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  155,
      155,  155,  155,  155,  155,  156,  210,  156,  156,  156,
      156,  156,  156,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  156,  156,
      156,  156,  156,  156,  158,  210,  158,  158,  158,  158,
      158,  158,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  158,  158,  158,
      158,  158,  158,  159,  210,  159,  159,  159,  159,  159,
      159,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  159,  159,  159,  159,

      159,  159,  161,  210,  161,  161,  161,  161,  161,  161,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  161,  161,  161,  161,  161,
      161,  162,  210,  162,  162,  162,  162,  162,  162,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  162,  162,  162,  162,  162,  162,
      164,  210,  164,  164,  164,  164,  164,  164,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  164,  164,  164,  164,  164,  164,  165,
      210,  165,  165,  165,  165,  165,  165,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  165,  165,  165,  165,  165,  165,  167,  210,
      167,  167,  167,  167,  167,  167,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  167,  167,  167,  167,  167,  167,  168,  210,  168,
      168,  168,  168,  168,  168,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      168,  168,  168,  168,  168,  168,  170,  210,  170,  170,
      170,  170,  170,  170,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  170,

      170,  170,  170,  170,  170,  171,  210,  171,  171,  171,
      171,  171,  171,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  171,  171,
      171,  171,  171,  171,  173,  210,  173,  173,  173,  173,
      173,  173,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  173,  173,  173,
      173,  173,  173,  174,  210,  174,  174,  174,  174,  174,
      174,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  174,  174,  174,  174,
      174,  174,  176,  210,  176,  176,  176,  176,  176,  176,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  176,  176,  176,  176,  176,
      176,  177,  210,  177,  177,  177,  177,  177,  177,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  177,  177,  177,  177,  177,  177,
      179,  210,  179,  179,  179,  179,  179,  179,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  179,  179,  179,  179,  179,  179,  180,
      210,  180,  180,  180,  180,  180,  180,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,

      210,  210,  180,  180,  180,  180,  180,  180,  182,  210,
      182,  182,  182,  182,  182,  182,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  182,  182,  182,  182,  182,  182,  183,  210,  183,
      183,  183,  183,  183,  183,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      183,  183,  183,  183,  183,  183,  184,  210,  184,  184,
      184,  184,  184,  184,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  184,
      184,  184,  184,  184,  184,  185,  210,  185,  185,  185,

      185,  185,  185,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  185,  185,
      185,  185,  185,  185,  186,  210,  186,  186,  186,  186,
      186,  186,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  186,  186,  186,
      186,  186,  186,  187,  210,  187,  187,  187,  187,  187,
      187,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  187,  187,  187,  187,
      187,  187,  188,  210,  188,  188,  188,  188,  188,  188,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  188,  188,  188,  188,  188,
      188,  189,  210,  189,  189,  189,  189,  189,  189,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  189,  189,  189,  189,  189,  189,
      190,  210,  190,  190,  190,  190,  190,  190,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  190,  190,  190,  190,  190,  190,  191,
      210,  191,  191,  191,  191,  191,  191,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  191,  191,  191,  191,  191,  191,  192,  210,

      192,  192,  192,  192,  192,  192,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  192,  192,  192,  192,  192,  192,  193,  210,  193,
      193,  193,  193,  193,  193,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      193,  193,  193,  193,  193,  193,  194,  210,  194,  194,
      194,  194,  194,  194,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  194,
      194,  194,  194,  194,  194,  195,  210,  195,  195,  195,
      195,  195,  195,  210,  210,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  195,  195,
      195,  195,  195,  195,  196,  210,  196,  196,  196,  196,
      196,  196,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  196,  196,  196,
      196,  196,  196,  197,  210,  197,  197,  197,  197,  197,
      197,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  197,  197,  197,  197,
      197,  197,  198,  210,  198,  198,  198,  198,  198,  198,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  198,  198,  198,  198,  198,

      198,  199,  210,  199,  199,  199,  199,  199,  199,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  199,  199,  199,  199,  199,  199,
      200,  210,  200,  200,  200,  200,  200,  200,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  200,  200,  200,  200,  200,  200,  201,
      210,  201,  201,  201,  201,  201,  201,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  201,  201,  201,  201,  201,  201,  202,  210,
      202,  202,  202,  202,  202,  202,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  202,  202,  202,  202,  202,  202,  203,  210,  203,
      203,  203,  203,  203,  203,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      203,  203,  203,  203,  203,  203,  204,  210,  204,  204,
      204,  204,  204,  204,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  204,
      204,  204,  204,  204,  204,  205,  210,  205,  205,  205,
      205,  205,  205,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  205,  205,

      205,  205,  205,  205,  206,  210,  206,  206,  206,  206,
      206,  206,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  206,  206,  206,
      206,  206,  206,  207,  210,  207,  207,  207,  207,  207,
      207,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  207,  207,  207,  207,
      207,  207,  208,  210,  208,  208,  208,  208,  208,  208,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  208,  208,  208,  208,  208,
      208,  209,  210,  209,  209,  209,  209,  209,  209,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  209,  209,  209,  209,  209,  209,
       15,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210
    } ;

static yyconst flex_int16_t yy_chk[2775] =
    {   0,
        0,    1,    1,    1,    3,    3,   20,    3,    1,   20,
      178,   24,    1,    1,    1,   24,    4,    4,    1,    4,
       26,   55,    1,    5,    5,    5,    1,    1,    1,  175,
        5,  172,   24,    1,    1,    1,   24,   11,   11,    1,
      169,   26,   55,    1,   11,   11,  166,    1,    1,    1,
        2,    2,    2,    2,   35,   35,   35,    2,   50,   50,
       50,    2,    2,    2,  163,   12,   12,    2,   12,   21,
       23,    2,   12,   12,   23,    2,    2,    2,    6,    6,
        6,    6,    2,    2,    2,    6,  160,  157,    2,  154,
       21,   23,    2,  150,  146,   23,    2,    2,    2,    7,

        7,    7,   22,  141,  134,    7,    7,    7,   22,    7,
        7,    7,    7,    7,    7,   13,   13,   13,   14,   14,
       14,   14,   13,   22,    7,   14,  124,   25,   27,   22,
        7,    7,    7,    7,    7,    7,   71,   71,   71,  115,
      114,   28,   99,   28,   56,    7,    9,    9,   25,   27,
       57,   38,   58,    9,    9,   59,    9,    9,    9,    9,
        9,    9,   28,   38,   28,   56,   60,   61,   62,   63,
       64,   57,   38,   58,   65,   66,   59,    9,    9,    9,
        9,    9,    9,   86,   38,   88,   89,   60,   61,   62,
       63,   64,   72,   72,   72,   65,   66,   82,   82,   82,

       83,   83,   83,   90,   86,   91,   88,   89,   92,   93,
       94,   95,   96,   97,   98,   98,   98,  102,  102,  102,
      104,  106,  108,  109,   90,  110,   91,  112,  113,   92,
       93,   94,   95,   96,   97,  117,  118,  119,  120,  121,
      122,  104,  106,  108,  109,  123,  110,  127,  112,  113,
      128,  129,  132,  137,  138,  144,  117,  118,  119,  120,
      121,  122,  149,   84,   79,   76,  123,   67,  127,   54,
       51,  128,  129,  132,  137,  138,  144,   49,   48,   45,
       40,   39,   37,  149,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  211,  211,  211,

      211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,

      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  215,  215,  215,  215,

      215,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  215,  216,
       34,   32,   29,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,

      216,  216,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  218,   19,  218,  218,  218,
      218,  218,  218,   17,   15,   10,    8,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  218,  218,
      218,  218,  218,  218,  219,    0,  219,  219,  219,  219,
      219,  219,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  219,  219,  219,
      219,  219,  219,  220,    0,    0,    0,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  221,  221,  221,  221,

      221,  221,  221,  221,  221,  221,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  221,  221,  221,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  223,  223,  223,  223,  223,  223,  223,  223,
      223,  223,  223,  223,  223,  223,  223,  223,  223,  223,
      223,  223,  223,  223,  223,  223,  223,  223,  223,  223,

      223,  223,  223,  223,  223,  223,  223,  223,  223,  223,
      223,  223,  223,  223,  223,  223,  223,  223,  223,  223,
      223,  223,  223,  223,  223,  224,    0,  224,  224,  224,
      224,  224,  224,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  224,  224,
      224,  224,  224,  224,  225,    0,  225,  225,  225,  225,
      225,  225,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  225,  225,  225,
      225,  225,  225,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,

      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  227,    0,  227,  227,
      227,  227,  227,  227,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  227,
      227,  227,  227,  227,  227,  228,    0,  228,  228,  228,
      228,  228,  228,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  228,  228,
      228,  228,  228,  228,  229,    0,  229,    0,  229,  229,

      229,  229,  229,  229,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  229,
      229,  229,  229,  229,  229,  230,    0,  230,  230,  230,
      230,  230,  230,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  230,  230,
      230,  230,  230,  230,  231,    0,  231,  231,  231,  231,
      231,  231,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  231,  231,  231,
      231,  231,  231,  232,    0,  232,  232,  232,  232,  232,
      232,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  232,  232,  232,  232,
      232,  232,  233,    0,  233,  233,  233,  233,  233,  233,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  233,  233,  233,  233,  233,
      233,  234,    0,  234,  234,  234,  234,  234,  234,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  234,  234,  234,  234,  234,  234,
      235,    0,  235,  235,  235,  235,  235,  235,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  235,  235,  235,  235,  235,  235,  236,

        0,  236,  236,  236,  236,  236,  236,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  236,  236,  236,  236,  236,  236,  237,    0,
      237,  237,  237,  237,  237,  237,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  237,  237,  237,  237,  237,  237,  238,    0,  238,
      238,  238,  238,  238,  238,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      238,  238,  238,  238,  238,  238,  239,    0,  239,  239,
      239,  239,  239,  239,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  239,
      239,  239,  239,  239,  239,  240,    0,  240,  240,  240,
      240,  240,  240,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  240,  240,
      240,  240,  240,  240,  241,    0,  241,  241,  241,  241,
      241,  241,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  241,  241,  241,
      241,  241,  241,  242,    0,  242,  242,  242,  242,  242,
      242,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  242,  242,  242,  242,

      242,  242,  243,    0,  243,  243,  243,  243,  243,  243,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  243,  243,  243,  243,  243,
      243,  244,    0,  244,  244,  244,  244,  244,  244,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  244,  244,  244,  244,  244,  244,
      245,    0,  245,  245,  245,  245,  245,  245,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  245,  245,  245,  245,  245,  245,  246,
        0,  246,  246,  246,  246,  246,  246,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  246,  246,  246,  246,  246,  246,  247,    0,
      247,  247,  247,  247,  247,  247,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  247,  247,  247,  247,  247,  247,  248,    0,  248,
      248,  248,  248,  248,  248,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      248,  248,  248,  248,  248,  248,  249,    0,  249,  249,
      249,  249,  249,  249,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  249,

      249,  249,  249,  249,  249,  250,    0,  250,  250,  250,
      250,  250,  250,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  250,  250,
      250,  250,  250,  250,  251,    0,  251,  251,  251,  251,
      251,  251,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  251,  251,  251,
      251,  251,  251,  252,    0,  252,  252,  252,  252,  252,
      252,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  252,  252,  252,  252,
      252,  252,  253,    0,  253,  253,  253,  253,  253,  253,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  253,  253,  253,  253,  253,
      253,  254,    0,  254,  254,  254,  254,  254,  254,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  254,  254,  254,  254,  254,  254,
      255,    0,  255,  255,  255,  255,  255,  255,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  255,  255,  255,  255,  255,  255,  256,
        0,  256,  256,  256,  256,  256,  256,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  256,  256,  256,  256,  256,  256,  257,    0,
      257,  257,  257,  257,  257,  257,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  257,  257,  257,  257,  257,  257,  258,    0,  258,
      258,  258,  258,  258,  258,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      258,  258,  258,  258,  258,  258,  259,    0,  259,  259,
      259,  259,  259,  259,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  259,
      259,  259,  259,  259,  259,  260,    0,  260,  260,  260,

      260,  260,  260,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  260,  260,
      260,  260,  260,  260,  261,    0,  261,  261,  261,  261,
      261,  261,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  261,  261,  261,
      261,  261,  261,  262,    0,  262,  262,  262,  262,  262,
      262,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  262,  262,  262,  262,
      262,  262,  263,    0,  263,  263,  263,  263,  263,  263,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,  263,  263,  263,  263,  263,
      263,  264,    0,  264,  264,  264,  264,  264,  264,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  264,  264,  264,  264,  264,  264,
      265,    0,  265,  265,  265,  265,  265,  265,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  265,  265,  265,  265,  265,  265,  266,
        0,  266,  266,  266,  266,  266,  266,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  266,  266,  266,  266,  266,  266,  267,    0,

      267,  267,  267,  267,  267,  267,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  267,  267,  267,  267,  267,  267,  268,    0,  268,
      268,  268,  268,  268,  268,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      268,  268,  268,  268,  268,  268,  269,    0,  269,  269,
      269,  269,  269,  269,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  269,
      269,  269,  269,  269,  269,  270,    0,  270,  270,  270,
      270,  270,  270,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,  270,  270,
      270,  270,  270,  270,  271,    0,  271,  271,  271,  271,
      271,  271,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  271,  271,  271,
      271,  271,  271,  272,    0,  272,  272,  272,  272,  272,
      272,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  272,  272,  272,  272,
      272,  272,  273,    0,  273,  273,  273,  273,  273,  273,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  273,  273,  273,  273,  273,

      273,  274,    0,  274,  274,  274,  274,  274,  274,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  274,  274,  274,  274,  274,  274,
      275,    0,  275,  275,  275,  275,  275,  275,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  275,  275,  275,  275,  275,  275,  276,
        0,  276,  276,  276,  276,  276,  276,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  276,  276,  276,  276,  276,  276,  277,    0,
      277,  277,  277,  277,  277,  277,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  277,  277,  277,  277,  277,  277,  278,    0,  278,
      278,  278,  278,  278,  278,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      278,  278,  278,  278,  278,  278,  279,    0,  279,  279,
      279,  279,  279,  279,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  279,
      279,  279,  279,  279,  279,  280,    0,  280,  280,  280,
      280,  280,  280,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  280,  280,

      280,  280,  280,  280,  281,    0,  281,  281,  281,  281,
      281,  281,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  281,  281,  281,
      281,  281,  281,  282,    0,  282,  282,  282,  282,  282,
      282,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  282,  282,  282,  282,
      282,  282,  283,    0,  283,  283,  283,  283,  283,  283,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  283,  283,  283,  283,  283,
      283,  284,    0,  284,  284,  284,  284,  284,  284,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  284,  284,  284,  284,  284,  284,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210
    } ;

static yyconst flex_int16_t yy_rule_linenum[31] =
    {   0,
      172,  176,  180,  188,  197,  207,  216,  224,  233,  242,
      251,  260,  269,  278,  290,  304,  308,  319,  330,  356,
      374,  392,  408,  418,  426,  427,  428,  432,  434,  440
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "../parser/recordList.l"
/*=======================================================================
 * Version: $Id: recordList.l,v 1.2 2014/11/13 16:36:59 nroche Exp $
 * Project: Mediatex
 * Module : recordList reentrant scanner

 * recordList scanner
 * Note: Please provide an archive by line from input file

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 =======================================================================*/
/* definitions: ====================================================*/
/* Options for Specifing Filenames: */
/* Options Affecting Scanner Behavior: */
/* option batch OU interactive */
/* Code-Level And API Options: */
/* Options for Scanner Speed and Size: */
/* Debugging Options: */
/* Miscellaneous Options: */

#line 133 "../parser/recordList.l"
  /* local variables: */
#ifndef utMAIN
#define YY_INPUT(buf, result, max_size) \
  aesInput(((RecordExtra*)yyextra)->aesData, buf, &result, max_size)
#endif 
/* scaner states */






/* maccros */
/* Constants are not allowed there so we do it with yyless
into the rules */
/* MAX_SIZE_HASH = 32 */
/* MAX_SIZE_COLL = 20 */
//COLL    [^[:blank:]\r\n]+
#line 1333 "recordList.c"

#define INITIAL 0
#define COMMENT 1
#define STRING 2
#define STATE1 3
#define STATE2 4
#define STATE3 5
#define STATE4 6

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

/* %if-c-only */

static int yy_init_globals (yyscan_t yyscanner );

/* %endif */

/* %if-reentrant */

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int record_lex_init (yyscan_t* scanner);

int record_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* %endif */

/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int record_lex_destroy (yyscan_t yyscanner );

int record_get_debug (yyscan_t yyscanner );

void record_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE record_get_extra (yyscan_t yyscanner );

void record_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *record_get_in (yyscan_t yyscanner );

void record_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *record_get_out (yyscan_t yyscanner );

void record_set_out  (FILE * out_str ,yyscan_t yyscanner );

int record_get_leng (yyscan_t yyscanner );

char *record_get_text (yyscan_t yyscanner );

int record_get_lineno (yyscan_t yyscanner );

void record_set_lineno (int line_number ,yyscan_t yyscanner );

/* %if-bison-bridge */

YYSTYPE * record_get_lval (yyscan_t yyscanner );

void record_set_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int record_wrap (yyscan_t yyscanner );
#else
extern int record_wrap (yyscan_t yyscanner );
#endif
#endif

/* %not-for-header */

/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int record_lex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int record_lex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

/* %% [7.0] user's declarations go here */
#line 166 "../parser/recordList.l"

 /* rules: ==========================================================*/
   /* first rule: */

#line 1648 "recordList.c"

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			record_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				record__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		record__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 210 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 31 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 31 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 32 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 172 "../parser/recordList.l"
{
    BEGIN(COMMENT);
  }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 176 "../parser/recordList.l"
{
    ++((RecordExtra*)yyextra)->lineNo;
  }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 180 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: HEADER", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordHEADER);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 188 "../parser/recordList.l"
{
    BEGIN(STRING);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: COLL", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordCOLL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 197 "../parser/recordList.l"
{
    BEGIN(STRING);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: DOCYPHER", 
	    ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordDOCYPHER);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 207 "../parser/recordList.l"
{
    BEGIN(STRING);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TYPE", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordSERVER);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 216 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TYPE", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordMSGTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 224 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: DISK", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = DISK;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 233 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: CGI", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = CGI;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 242 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: HAVE", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = HAVE;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 251 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: NOTIFY", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = NOTIFY;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 260 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: UPLOAD", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = UPLOAD;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 269 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: UNKNOWN", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->msgval = UNKNOWN;
    return(recordMSGVAL);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 278 "../parser/recordList.l"
{
    BEGIN(STATE1);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: BODY", ((RecordExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(recordBODY);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 15:
YY_RULE_SETUP
#line 290 "../parser/recordList.l"
{ 
    BEGIN(INITIAL);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: STRING ='%s'", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    yylval->string = createSizedString(yyleng, yytext);
    return(recordSTRING);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 304 "../parser/recordList.l"
{
    ++((RecordExtra*)yyextra)->lineNo;
  }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 308 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TYPE = %ssupply", 
	    ((RecordExtra*)yyextra)->lineNo, yytext[0]=='-'?"- ":"");
#else	/*	: utMAIN	*/
    yylval->type = SUPPLY;
    //if (yytext[0] == '-') yylval->type |= REMOVE; // (no more used)
    return(recordTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 319 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TYPE = %sdemand", 
	    ((RecordExtra*)yyextra)->lineNo, yytext[0]=='-'?"- ":"");
#else	/*	: utMAIN	*/
    yylval->type = DEMAND;
    //if (yytext[0] == '-') yylval->type |= REMOVE;
    return(recordTYPE);
#endif	/*	: utMAIN	*/
  }  
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 330 "../parser/recordList.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: DATE = %s", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    // date conversion into time_t
    struct tm date;
    memset(&date, 0, sizeof(struct tm));
    if (sscanf(yytext, "%d-%d-%d,%d:%d:%d",
	       &date.tm_year, &date.tm_mon, &date.tm_mday,
	       &date.tm_hour, &date.tm_min, &date.tm_sec)
	!= 6) {
      logEmit(LOG_ERR, "sscanf: error parsing date %s", yytext);
      return(recordERROR);
    }
    date.tm_year -= 1900; // from GNU/Linux burning date
    date.tm_mon -= 1;     // month are managed from 0 to 11 
    date.tm_isdst = -1;   // no information available about spring horodatage
    if ((yylval->time = mktime(&date)) == -1) {
      logEmit(LOG_ERR, "%s", "mktime: error parsing date");
      return(recordERROR);
    }
    return(recordDATE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 356 "../parser/recordList.l"
{
    BEGIN(STATE2);
    // force to take 32 char
    // else the ending digit are taken by the next token
    //if (yyleng != MAX_SIZE_HASH) yyless(MAX_SIZE_HASH);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: HASH(1) =%s", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    strncpy(yylval->hash, yytext, MAX_SIZE_HASH);
    yylval->hash[MAX_SIZE_HASH] = (char)0;
    return(recordHASH);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 21:
YY_RULE_SETUP
#line 374 "../parser/recordList.l"
{
    BEGIN(STATE3);
    // force to take 32 char
    // else the ending digit are taken by the next token
    if (yyleng != MAX_SIZE_HASH) yyless(MAX_SIZE_HASH);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: HASH(2) =%s", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    strncpy(yylval->hash, yytext, MAX_SIZE_HASH);
    yylval->hash[MAX_SIZE_HASH] = (char)0;
    return(recordHASH);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 22:
YY_RULE_SETUP
#line 392 "../parser/recordList.l"
{
    off_t size = 0;
    BEGIN(STATE4);
    sscanf(yytext, "%llu", (unsigned long long int*)&size);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: SIZE =%lli", 
	    ((RecordExtra*)yyextra)->lineNo, size);
#else	/*	: utMAIN	*/
    yylval->size = size;
    return(recordSIZE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 23:
YY_RULE_SETUP
#line 408 "../parser/recordList.l"
{ 
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: PATH ='%s'", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    yylval->string = createSizedString(yyleng, yytext);
    return(recordPATH);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 418 "../parser/recordList.l"
{
    BEGIN(STATE1);
    ++((RecordExtra*)yyextra)->lineNo;
  }
	YY_BREAK

/* <INITIAL,STATE2,STATE3,STATE4>{ */

case 25:
YY_RULE_SETUP
#line 426 "../parser/recordList.l"
/* : eat up any blank character */
	YY_BREAK
case 26:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 427 "../parser/recordList.l"
/* : eat up comments */
	YY_BREAK
case 27:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 428 "../parser/recordList.l"
/* : eat up comments */
	YY_BREAK


case 28:
YY_RULE_SETUP
#line 432 "../parser/recordList.l"
/* : eat up any unmatched character */
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 434 "../parser/recordList.l"
{
    BEGIN(INITIAL);
  }
	YY_BREAK


case 30:
YY_RULE_SETUP
#line 440 "../parser/recordList.l"
{ /* : eat up any unmatched character */
    
    logEmit(LOG_ERR, "line %i: exit on scanner error: %s", 
	    ((RecordExtra*)yyextra)->lineNo, yytext);
    
    // generate a parsor error (unexpected $end)
#ifdef utMAIN
    return -1;
#else	/*	: utMAIN	*/
    return recordERROR;
#endif	/*	: utMAIN	*/
  }
	YY_BREAK

case 31:
YY_RULE_SETUP
#line 454 "../parser/recordList.l"
ECHO;
	YY_BREAK
#line 2142 "recordList.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STRING):
case YY_STATE_EOF(STATE1):
case YY_STATE_EOF(STATE2):
case YY_STATE_EOF(STATE3):
case YY_STATE_EOF(STATE4):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * record_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( record_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of record_lex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					record_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			record_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) record_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
/* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 210);

	return yy_is_jam ? 0 : yy_current_state;
}

/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					record_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( record_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

/* %% [19.0] update BOL and yylineno */
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void record_restart  (FILE * input_file , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        record_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            record__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	record__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	record__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void record__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		record_pop_buffer_state();
	 *		record_push_buffer_state(new_buffer);
     */
	record_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	record__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (record_wrap()) processing, but the only time this flag
	 * is looked at is after record_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/* %if-c-only */
static void record__load_buffer_state  (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE record__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) record_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in record__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) record_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in record__create_buffer()" );

	b->yy_is_our_buffer = 1;

	record__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with record__create_buffer()
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void record__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		record_free((void *) b->yy_ch_buf ,yyscanner );

	record_free((void *) b ,yyscanner );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a record_restart() or at EOF.
 */
/* %if-c-only */
    static void record__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	record__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then record__init_buffer was _probably_
     * called from record_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void record__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		record__load_buffer_state(yyscanner );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
/* %if-c-only */
void record_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	record_ensure_buffer_stack(yyscanner);

	/* This block is copied from record__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from record__switch_to_buffer. */
	record__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
/* %if-c-only */
void record_pop_buffer_state (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	record__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		record__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void record_ensure_buffer_stack (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)record_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in record_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)record_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in record_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE record__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) record_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in record__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	record__switch_to_buffer(b ,yyscanner );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to record_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       record__scan_bytes() instead.
 */
YY_BUFFER_STATE record__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return record__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to record_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE record__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) record_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in record__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = record__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in record__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE record_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/* %endif */

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int record_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int record_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *record_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *record_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int record_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *record_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/* %if-reentrant */

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void record_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/* %endif */

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void record_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "record_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void record_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "record_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see record__switch_to_buffer
 */
void record_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void record_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int record_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void record_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* Accessor methods for yylval and yylloc */

/* %if-bison-bridge */

YYSTYPE * record_get_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void record_set_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* %endif */

/* User-visible API */

/* record_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int record_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) record_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* record_lex_init_extra has the same functionality as record_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to record_alloc in
 * the yyextra field.
 */

int record_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    record_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) record_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    record_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from record_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * record_lex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* record_lex_destroy is for both reentrant and non-reentrant scanners. */
int record_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		record__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		record_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	record_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        record_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * record_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

/* %if-reentrant */
    /* Destroy the main struct (reentrant only). */
    record_free ( yyscanner , yyscanner );
    yyscanner = NULL;
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *record_alloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *record_realloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void record_free (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see record_realloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 454 "../parser/recordList.l"


   /* user code (literally copied to the generated source) :
      ==========*/
   
/************************************************************************/

#ifdef utMAIN
#include "../misc/command.h"
#include <sys/types.h> //
#include <sys/stat.h>  // open 
#include <fcntl.h>     //
GLOBAL_STRUCT_DEF;

/*=======================================================================
 * Function   : usage
 * Description: Print the usage.
 * Synopsis   : static void usage(char* programName)
 * Input      : programName = the name of the program; usually argv[0].
 * Output     : N/A
 =======================================================================*/
static void 
usage(char* programName)
{
  parserUsage(programName);
  fprintf(stderr, " [ -i inputPath ]");

  parserOptions();
  fprintf(stderr, "  ---\n"
	  "  -i, --input\t\tinput file to parse\n");
  return;
}


/*=======================================================================
 * Function   : main 
 * Author     : Nicolas ROCHE
 * modif      : 2012/05/01
 * Description: Unit test for recordList module.
 * Synopsis   : ./utrecordList
 * Input      : stdin
 * Output     : stdout
 =======================================================================*/
int 
main(int argc, char** argv)
{
  char* inputPath = NULL;
  int inputFd = -1;
  FILE* inputStream = stdin;
  RecordExtra extra;
  yyscan_t scanner;
  // ---
  int rc = 0;
  int cOption = EOF;
  char* programName = *argv;
  char* options = PARSER_SHORT_OPTIONS"i:";
  struct option longOptions[] = {
    {"input", required_argument, NULL, 'i'},
    PARSER_LONG_OPTIONS,
    {0, 0, 0, 0}
  };

  // import mdtx environment
  getEnv(&env);

  // parse the command line
  while((cOption = getopt_long(argc, argv, options, longOptions, NULL)) 
	!= EOF) {
    switch(cOption) {
      
    case 'i':
      if(isEmptyString(optarg)) {
	fprintf(stderr, 
		"%s: nil or empty argument for the input stream\n",
		programName);
	rc = 2;
      }
      else {
	if ((inputPath = (char*)malloc(sizeof(char) * strlen(optarg) + 1))
	    == NULL) {
	  fprintf(stderr, 
		  "%s: cannot allocate memory for the input stream name\n", 
		  programName);
	  rc = 3;
	}
	else {
	  strcpy(inputPath, optarg);
	}
      }
      break;
		
      GET_PARSER_OPTIONS; // generic options
    }
    if (rc) goto optError;
  }

  // export mdtx environment
  if (!setEnv(programName, &env)) goto optError;

  /************************************************************************/
  // init scanner
  if (record_lex_init (&scanner)) {
    logEmit(LOG_ERR, "%s", "error initializing scanner");
    goto error;
  }
  record_set_debug(env.debugLexer, scanner);
  logEmit(LOG_DEBUG, "record_set_debug = %i", 
	  record_get_debug(scanner));
  
  // scan stdin or input file if defined
  if (!isEmptyString(inputPath)) {
    if ((inputFd = open(inputPath, O_RDONLY)) == 0) {
      logEmit(LOG_ERR, "cannot open input file: %s", inputPath); 
      goto error;
    }
    
    if ((inputStream = fdopen(inputFd, "r")) == NULL) {
      logEmit(LOG_ERR, "%s", "fdopen failed");
      goto error;
    }
    record_set_in(inputStream, scanner);
  }
  
  // call scanner 
  extra.lineNo = 1;
  extra.aesData = NULL;
  record_set_extra (&extra, scanner);
  //data = record_get_extra (scanner);
  //in GDB: print *(RecordExtra*)yyg->yyextra_r
  if (record_lex(NULL, scanner)) goto error;
  record_lex_destroy(scanner);
  fclose(inputStream);
  /************************************************************************/

  destroyString(inputPath);
  rc = TRUE;
 error:
  ENDINGS;
  rc=!rc;
 optError:
  exit(rc);
}
 
#endif // utMAIN

/* Local Variables: */
/* mode: c */
/* mode: font-lock */
/* mode: auto-fill */
/* End: */


