#line 2 "extractFile.c"
#line 68 "../parser/extractFile.l"
/*=======================================================================
 * Version: $Id: extractFile.l,v 1.2 2014/11/13 16:36:58 nroche Exp $
 * Project: Mediatex
 * Module : extraction meta-data scanner

 * extraction meta-data scanner

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
=======================================================================*/

#include "../mediatex.h"
#include "../misc/log.h"
#include "../memory/strdsm.h"
#include "../memory/extractTree.h"

#ifndef utMAIN
#include "extractFile.tab.h"
#endif	/*	: utMAIN	*/

typedef struct ExtrExtra {
  int            lineNo;
  // nothing more needed into the scanner
} ExtrExtra;

// %union{} used by flex/bison to write/read values
// (only available when linked with bison)
typedef union ExtrBisonUnion {
  // lex token types
  off_t  size;
  char   string[MAX_SIZE_STRING+1];
  char   hash[MAX_SIZE_HASH+1];
  EType  type; 

  // bison token types
  Archive* archive_t;
} ExtrBisonUnion;

#define YYSTYPE ExtrBisonUnion
#define YY_NO_INPUT // no warning



#line 60 "extractFile.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */
/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* %endif */

/* %if-not-reentrant */
/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE extr_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

/* %if-not-reentrant */
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via extr_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

void extr_restart (FILE *input_file ,yyscan_t yyscanner );
void extr__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE extr__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void extr__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void extr__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void extr_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void extr_pop_buffer_state (yyscan_t yyscanner );

static void extr_ensure_buffer_stack (yyscan_t yyscanner );
static void extr__load_buffer_state (yyscan_t yyscanner );
static void extr__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER extr__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE extr__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE extr__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE extr__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

/* %endif */

void *extr_alloc (yy_size_t ,yyscan_t yyscanner );
void *extr_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void extr_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer extr__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        extr_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            extr__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        extr_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            extr__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define extr_wrap(n) 1
#define YY_SKIP_YYWRAP

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	yyg->yy_c_buf_p = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 29
#define YY_END_OF_BUFFER 30
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[180] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   20,   20,
       30,   28,   23,   27,   28,    1,   28,   28,   28,   28,
       28,   28,   28,   28,   28,   28,   21,   21,   21,   21,
       21,   16,   18,   14,   28,   28,   19,   20,   20,   20,
       23,   27,   26,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   24,   22,   18,
        0,   17,   19,   20,   20,   20,   20,    0,   25,    0,
        0,    4,    0,    0,    3,   13,    2,    8,    6,    5,
       12,   18,    0,   19,   20,    7,   11,    9,   10,   18,
        0,   19,   18,    0,   19,   18,    0,   19,   18,    0,

       19,   18,    0,   19,   18,    0,   19,   18,    0,   19,
       18,    0,   19,   18,    0,   19,   18,    0,   19,   18,
        0,   19,   18,    0,   19,   18,    0,   19,   18,    0,
       19,   18,    0,   19,   18,    0,   19,   18,    0,   19,
       18,    0,   19,   18,    0,   19,   18,    0,   19,   18,
        0,   19,   18,    0,   19,   18,    0,   19,   18,    0,
       19,   18,    0,   19,   18,    0,   19,   18,    0,   19,
       18,    0,   19,   15,   15,   15,   18,   19,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    5,    1,    1,    1,    1,    6,
        7,    8,    1,    9,    1,    1,   10,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   12,    1,    1,
       13,   14,    1,    1,   15,   16,   17,   18,   19,   20,
       21,    1,   22,    1,    1,    1,    1,    1,   23,   24,
        1,   25,   26,   27,    1,    1,    1,    1,    1,   28,
        1,    1,    1,    1,    1,    1,   29,   30,   31,   18,

       32,   33,   34,    1,   35,    1,    1,    1,    1,    1,
       36,   37,    1,   38,   39,   40,    1,    1,    1,    1,
        1,   41,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[218] =
    {   0,
        0,  610,   40,   49,   59,  609,   34,   96,  108,  119,
      613, 1224,  604, 1224,  602, 1224,   48,   83,   78,  110,
       86,  104,  117,  129,  113,  601, 1224,  595,  586,   94,
      592, 1224,  583, 1224,  579,    0,  581,    0,  130,  153,
      589, 1224, 1224,  587,  119,  129,  126,  139,  145,  145,
      144,  153,  147,  145,  147,  152,  580, 1224, 1224,  571,
        0, 1224,  570,    0,    0,  188,  199,  571, 1224,  160,
      170, 1224,  176,  180, 1224, 1224, 1224, 1224, 1224, 1224,
     1224,  562,    0,  561,  211, 1224, 1224, 1224, 1224,  560,
        0,  559,  558,    0,  557,  556,    0,  549,  548,    0,

      547,  499,    0,  498,  497,    0,  496,  495,    0,  494,
      493,    0,  492,  485,    0,  484,  483,    0,  370,  367,
        0,  365,  362,    0,  361,  360,    0,  353,  352,    0,
      351,  350,    0,  349,  348,    0,  347,  346,    0,  339,
      338,    0,  337,  211,    0,  210,  208,    0,  205,  199,
        0,  198,  194,    0,  187,  182,    0,  176,  168,    0,
      167,  166,    0,  160,  141,    0,  131,  126,    0,  122,
      102,    0,   97,   94, 1224,   44,   38,   35, 1224,  223,
      264,  305,  336,  369,  410,  451,  482,  515,  546,  569,
      592,  615,  638,  661,  684,  707,  730,  753,  776,  799,

      822,  845,  868,  891,  914,  937,  960,  983, 1006, 1029,
     1052, 1075, 1098, 1121, 1144, 1167, 1190
    } ;

static yyconst flex_int16_t yy_def[218] =
    {   0,
      179,    1,  180,  180,  179,    5,    5,    5,  181,  181,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  182,  179,  179,  179,  179,
      182,  179,  183,  179,  179,  183,  183,  184,  184,  185,
      179,  179,  179,  186,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  182,  179,  179,  187,
      187,  179,  187,  184,  184,  188,  185,  186,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  189,  189,  189,  188,  179,  179,  179,  179,  190,
      190,  190,  191,  191,  191,  192,  192,  192,  193,  193,

      193,  194,  194,  194,  195,  195,  195,  196,  196,  196,
      197,  197,  197,  198,  198,  198,  199,  199,  199,  200,
      200,  200,  201,  201,  201,  202,  202,  202,  203,  203,
      203,  204,  204,  204,  205,  205,  205,  206,  206,  206,
      207,  207,  207,  208,  208,  208,  209,  209,  209,  210,
      210,  210,  211,  211,  211,  212,  212,  212,  213,  213,
      213,  214,  214,  214,  215,  215,  215,  216,  216,  216,
      217,  217,  217,  179,  179,  179,  179,  179,    0,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,

      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179
    } ;

static yyconst flex_int16_t yy_nxt[1266] =
    {   0,
       12,   13,   14,   15,   12,   16,   12,   12,   12,   17,
       12,   12,   12,   12,   18,   19,   20,   12,   12,   12,
       21,   22,   12,   12,   23,   12,   24,   25,   18,   19,
       20,   12,   12,   21,   22,   12,   12,   23,   12,   24,
       25,   28,   14,   15,   37,  178,   12,   29,  177,   30,
       28,   14,   15,   31,  178,   43,   29,   44,   30,   12,
       13,   14,   15,   12,   12,   32,   12,   12,   17,   33,
       34,   35,   12,   36,   36,   36,   36,   36,   36,   12,
       12,   12,   12,   12,   12,   12,   12,   36,   36,   36,
       36,   36,   12,   12,   12,   12,   12,   12,   12,   12,

       26,   43,   45,   44,  177,   46,   37,  176,   12,   13,
       14,   15,  174,   49,   12,   45,   12,   39,   46,   12,
       13,   14,   15,   40,   47,   12,   49,   12,   39,   50,
       12,   51,  173,   48,   56,   52,  171,   65,   47,   66,
       70,  170,   50,   53,   54,   51,   48,   56,   52,   55,
       71,  168,   72,   70,   57,   58,   57,   53,   54,   57,
       73,   57,   55,   71,   57,   72,   74,   75,   76,   77,
      167,   78,   79,   73,   80,   81,  165,  164,  162,   74,
       75,   76,   86,   77,   78,   79,  161,   80,   81,   68,
       69,   68,  159,   87,   68,   86,   68,  158,   88,   68,

       57,   58,   57,   89,  156,   57,   87,   57,  155,  153,
       57,   88,   68,   69,   68,  152,   89,   68,  150,   68,
      149,  147,   68,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,

       38,   38,   38,   38,   38,   57,   57,   57,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       57,   57,   57,   57,   57,   57,   57,   57,   57,   57,
       57,   57,   57,   57,   57,   57,   61,  146,  144,  143,
       61,   61,   61,   61,   61,   61,  141,  140,  138,  137,
      135,  134,  132,  131,   61,   61,   61,   61,   61,   64,
      129,  128,  126,   64,   64,  125,   64,  123,   64,   64,
      122,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,

       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   83,  120,  119,  117,   83,   83,   83,   83,

       83,   83,  116,  114,  113,  111,  110,  108,  107,  105,
       83,   83,   83,   83,   83,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   91,  104,  102,  101,
       91,   91,   91,   91,   91,   91,   99,   98,   96,   95,
       93,   92,   90,   69,   91,   91,   91,   91,   91,   94,
       84,   82,   58,   94,   94,   94,   94,   94,   94,   69,
       41,   63,   62,   60,   58,   59,   41,   94,   94,   94,

       94,   94,   97,   58,   42,   41,   97,   97,   97,   97,
       97,   97,  179,   26,   26,  179,  179,  179,  179,  179,
       97,   97,   97,   97,   97,  100,  179,  179,  179,  100,
      100,  100,  100,  100,  100,  179,  179,  179,  179,  179,
      179,  179,  179,  100,  100,  100,  100,  100,  103,  179,
      179,  179,  103,  103,  103,  103,  103,  103,  179,  179,
      179,  179,  179,  179,  179,  179,  103,  103,  103,  103,
      103,  106,  179,  179,  179,  106,  106,  106,  106,  106,
      106,  179,  179,  179,  179,  179,  179,  179,  179,  106,
      106,  106,  106,  106,  109,  179,  179,  179,  109,  109,

      109,  109,  109,  109,  179,  179,  179,  179,  179,  179,
      179,  179,  109,  109,  109,  109,  109,  112,  179,  179,
      179,  112,  112,  112,  112,  112,  112,  179,  179,  179,
      179,  179,  179,  179,  179,  112,  112,  112,  112,  112,
      115,  179,  179,  179,  115,  115,  115,  115,  115,  115,
      179,  179,  179,  179,  179,  179,  179,  179,  115,  115,
      115,  115,  115,  118,  179,  179,  179,  118,  118,  118,
      118,  118,  118,  179,  179,  179,  179,  179,  179,  179,
      179,  118,  118,  118,  118,  118,  121,  179,  179,  179,
      121,  121,  121,  121,  121,  121,  179,  179,  179,  179,

      179,  179,  179,  179,  121,  121,  121,  121,  121,  124,
      179,  179,  179,  124,  124,  124,  124,  124,  124,  179,
      179,  179,  179,  179,  179,  179,  179,  124,  124,  124,
      124,  124,  127,  179,  179,  179,  127,  127,  127,  127,
      127,  127,  179,  179,  179,  179,  179,  179,  179,  179,
      127,  127,  127,  127,  127,  130,  179,  179,  179,  130,
      130,  130,  130,  130,  130,  179,  179,  179,  179,  179,
      179,  179,  179,  130,  130,  130,  130,  130,  133,  179,
      179,  179,  133,  133,  133,  133,  133,  133,  179,  179,
      179,  179,  179,  179,  179,  179,  133,  133,  133,  133,

      133,  136,  179,  179,  179,  136,  136,  136,  136,  136,
      136,  179,  179,  179,  179,  179,  179,  179,  179,  136,
      136,  136,  136,  136,  139,  179,  179,  179,  139,  139,
      139,  139,  139,  139,  179,  179,  179,  179,  179,  179,
      179,  179,  139,  139,  139,  139,  139,  142,  179,  179,
      179,  142,  142,  142,  142,  142,  142,  179,  179,  179,
      179,  179,  179,  179,  179,  142,  142,  142,  142,  142,
      145,  179,  179,  179,  145,  145,  145,  145,  145,  145,
      179,  179,  179,  179,  179,  179,  179,  179,  145,  145,
      145,  145,  145,  148,  179,  179,  179,  148,  148,  148,

      148,  148,  148,  179,  179,  179,  179,  179,  179,  179,
      179,  148,  148,  148,  148,  148,  151,  179,  179,  179,
      151,  151,  151,  151,  151,  151,  179,  179,  179,  179,
      179,  179,  179,  179,  151,  151,  151,  151,  151,  154,
      179,  179,  179,  154,  154,  154,  154,  154,  154,  179,
      179,  179,  179,  179,  179,  179,  179,  154,  154,  154,
      154,  154,  157,  179,  179,  179,  157,  157,  157,  157,
      157,  157,  179,  179,  179,  179,  179,  179,  179,  179,
      157,  157,  157,  157,  157,  160,  179,  179,  179,  160,
      160,  160,  160,  160,  160,  179,  179,  179,  179,  179,

      179,  179,  179,  160,  160,  160,  160,  160,  163,  179,
      179,  179,  163,  163,  163,  163,  163,  163,  179,  179,
      179,  179,  179,  179,  179,  179,  163,  163,  163,  163,
      163,  166,  179,  179,  179,  166,  166,  166,  166,  166,
      166,  179,  179,  179,  179,  179,  179,  179,  179,  166,
      166,  166,  166,  166,  169,  179,  179,  179,  169,  169,
      169,  169,  169,  169,  179,  179,  179,  179,  179,  179,
      179,  179,  169,  169,  169,  169,  169,  172,  179,  179,
      179,  172,  172,  172,  172,  172,  172,  179,  179,  179,
      179,  179,  179,  179,  179,  172,  172,  172,  172,  172,

      175,  179,  179,  179,  175,  175,  175,  175,  175,  175,
      179,  179,  179,  179,  179,  179,  179,  179,  175,  175,
      175,  175,  175,   11,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179
    } ;

static yyconst flex_int16_t yy_chk[1266] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    3,    3,    7,  178,    7,    3,  177,    3,
        4,    4,    4,    4,  176,   17,    4,   17,    4,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        8,   30,   18,   30,  174,   19,    8,  173,    8,    9,
        9,    9,  171,   21,    9,   18,    9,    9,   19,    9,
       10,   10,   10,   10,   20,   10,   21,   10,   10,   22,
       10,   23,  170,   20,   25,   23,  168,   39,   20,   39,
       45,  167,   22,   24,   24,   23,   20,   25,   23,   24,
       46,  165,   47,   45,   40,   40,   40,   24,   24,   40,
       48,   40,   24,   46,   40,   47,   49,   50,   51,   52,
      164,   53,   54,   48,   55,   56,  162,  161,  159,   49,
       50,   51,   70,   52,   53,   54,  158,   55,   56,   66,
       66,   66,  156,   71,   66,   70,   66,  155,   73,   66,

       67,   67,   67,   74,  153,   67,   71,   67,  152,  150,
       67,   73,   85,   85,   85,  149,   74,   85,  147,   85,
      146,  144,   85,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  181,  181,  181,  181,  181,  181,
      181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
      181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
      181,  181,  181,  181,  181,  181,  181,  181,  181,  181,

      181,  181,  181,  181,  181,  182,  182,  182,  182,  182,
      182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
      182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
      182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
      182,  182,  182,  182,  182,  182,  183,  143,  141,  140,
      183,  183,  183,  183,  183,  183,  138,  137,  135,  134,
      132,  131,  129,  128,  183,  183,  183,  183,  183,  184,
      126,  125,  123,  184,  184,  122,  184,  120,  184,  184,
      119,  184,  184,  184,  184,  184,  184,  184,  184,  184,
      184,  184,  184,  184,  184,  184,  184,  184,  184,  184,

      184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  187,  117,  116,  114,  187,  187,  187,  187,

      187,  187,  113,  111,  110,  108,  107,  105,  104,  102,
      187,  187,  187,  187,  187,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  189,  101,   99,   98,
      189,  189,  189,  189,  189,  189,   96,   95,   93,   92,
       90,   84,   82,   68,  189,  189,  189,  189,  189,  190,
       63,   60,   57,  190,  190,  190,  190,  190,  190,   44,
       41,   37,   35,   33,   31,   29,   28,  190,  190,  190,

      190,  190,  191,   26,   15,   13,  191,  191,  191,  191,
      191,  191,   11,    6,    2,    0,    0,    0,    0,    0,
      191,  191,  191,  191,  191,  192,    0,    0,    0,  192,
      192,  192,  192,  192,  192,    0,    0,    0,    0,    0,
        0,    0,    0,  192,  192,  192,  192,  192,  193,    0,
        0,    0,  193,  193,  193,  193,  193,  193,    0,    0,
        0,    0,    0,    0,    0,    0,  193,  193,  193,  193,
      193,  194,    0,    0,    0,  194,  194,  194,  194,  194,
      194,    0,    0,    0,    0,    0,    0,    0,    0,  194,
      194,  194,  194,  194,  195,    0,    0,    0,  195,  195,

      195,  195,  195,  195,    0,    0,    0,    0,    0,    0,
        0,    0,  195,  195,  195,  195,  195,  196,    0,    0,
        0,  196,  196,  196,  196,  196,  196,    0,    0,    0,
        0,    0,    0,    0,    0,  196,  196,  196,  196,  196,
      197,    0,    0,    0,  197,  197,  197,  197,  197,  197,
        0,    0,    0,    0,    0,    0,    0,    0,  197,  197,
      197,  197,  197,  198,    0,    0,    0,  198,  198,  198,
      198,  198,  198,    0,    0,    0,    0,    0,    0,    0,
        0,  198,  198,  198,  198,  198,  199,    0,    0,    0,
      199,  199,  199,  199,  199,  199,    0,    0,    0,    0,

        0,    0,    0,    0,  199,  199,  199,  199,  199,  200,
        0,    0,    0,  200,  200,  200,  200,  200,  200,    0,
        0,    0,    0,    0,    0,    0,    0,  200,  200,  200,
      200,  200,  201,    0,    0,    0,  201,  201,  201,  201,
      201,  201,    0,    0,    0,    0,    0,    0,    0,    0,
      201,  201,  201,  201,  201,  202,    0,    0,    0,  202,
      202,  202,  202,  202,  202,    0,    0,    0,    0,    0,
        0,    0,    0,  202,  202,  202,  202,  202,  203,    0,
        0,    0,  203,  203,  203,  203,  203,  203,    0,    0,
        0,    0,    0,    0,    0,    0,  203,  203,  203,  203,

      203,  204,    0,    0,    0,  204,  204,  204,  204,  204,
      204,    0,    0,    0,    0,    0,    0,    0,    0,  204,
      204,  204,  204,  204,  205,    0,    0,    0,  205,  205,
      205,  205,  205,  205,    0,    0,    0,    0,    0,    0,
        0,    0,  205,  205,  205,  205,  205,  206,    0,    0,
        0,  206,  206,  206,  206,  206,  206,    0,    0,    0,
        0,    0,    0,    0,    0,  206,  206,  206,  206,  206,
      207,    0,    0,    0,  207,  207,  207,  207,  207,  207,
        0,    0,    0,    0,    0,    0,    0,    0,  207,  207,
      207,  207,  207,  208,    0,    0,    0,  208,  208,  208,

      208,  208,  208,    0,    0,    0,    0,    0,    0,    0,
        0,  208,  208,  208,  208,  208,  209,    0,    0,    0,
      209,  209,  209,  209,  209,  209,    0,    0,    0,    0,
        0,    0,    0,    0,  209,  209,  209,  209,  209,  210,
        0,    0,    0,  210,  210,  210,  210,  210,  210,    0,
        0,    0,    0,    0,    0,    0,    0,  210,  210,  210,
      210,  210,  211,    0,    0,    0,  211,  211,  211,  211,
      211,  211,    0,    0,    0,    0,    0,    0,    0,    0,
      211,  211,  211,  211,  211,  212,    0,    0,    0,  212,
      212,  212,  212,  212,  212,    0,    0,    0,    0,    0,

        0,    0,    0,  212,  212,  212,  212,  212,  213,    0,
        0,    0,  213,  213,  213,  213,  213,  213,    0,    0,
        0,    0,    0,    0,    0,    0,  213,  213,  213,  213,
      213,  214,    0,    0,    0,  214,  214,  214,  214,  214,
      214,    0,    0,    0,    0,    0,    0,    0,    0,  214,
      214,  214,  214,  214,  215,    0,    0,    0,  215,  215,
      215,  215,  215,  215,    0,    0,    0,    0,    0,    0,
        0,    0,  215,  215,  215,  215,  215,  216,    0,    0,
        0,  216,  216,  216,  216,  216,  216,    0,    0,    0,
        0,    0,    0,    0,    0,  216,  216,  216,  216,  216,

      217,    0,    0,    0,  217,  217,  217,  217,  217,  217,
        0,    0,    0,    0,    0,    0,    0,    0,  217,  217,
      217,  217,  217,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
      179,  179,  179,  179,  179
    } ;

static yyconst flex_int16_t yy_rule_linenum[29] =
    {   0,
      139,  147,  157,  167,  177,  187,  197,  207,  217,  227,
      237,  247,  257,  271,  279,  289,  302,  311,  326,  342,
      358,  362,  370,  371,  372,  374,  378,  385
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "../parser/extractFile.l"
/*=======================================================================
 * Version: $Id: extractFile.l,v 1.2 2014/11/13 16:36:58 nroche Exp $
 * Project: Mediatex
 * Module : extraction meta-data scanner

 * extraction meta-data scanner

 MediaTex is an Electronic Records Management System
 Copyright (C) 2014  Nicolas Roche
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 =======================================================================*/
/* definitions: ====================================================*/
/* Options for Specifing Filenames: */
/* Options Affecting Scanner Behavior: */
/* option batch OU interactive */
/* Code-Level And API Options: */
/* Options for Scanner Speed and Size: */
/* Debugging Options: */
/* Miscellaneous Options: */

#line 124 "../parser/extractFile.l"
  /* no local variables: reentrant */
/* scaner states */




#line 963 "extractFile.c"

#define INITIAL 0
#define COMMENT 1
#define CONTAINERS 2
#define CONTENTS 3
#define PATH 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

/* %if-c-only */

static int yy_init_globals (yyscan_t yyscanner );

/* %endif */

/* %if-reentrant */

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int extr_lex_init (yyscan_t* scanner);

int extr_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* %endif */

/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int extr_lex_destroy (yyscan_t yyscanner );

int extr_get_debug (yyscan_t yyscanner );

void extr_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE extr_get_extra (yyscan_t yyscanner );

void extr_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *extr_get_in (yyscan_t yyscanner );

void extr_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *extr_get_out (yyscan_t yyscanner );

void extr_set_out  (FILE * out_str ,yyscan_t yyscanner );

int extr_get_leng (yyscan_t yyscanner );

char *extr_get_text (yyscan_t yyscanner );

int extr_get_lineno (yyscan_t yyscanner );

void extr_set_lineno (int line_number ,yyscan_t yyscanner );

/* %if-bison-bridge */

YYSTYPE * extr_get_lval (yyscan_t yyscanner );

void extr_set_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int extr_wrap (yyscan_t yyscanner );
#else
extern int extr_wrap (yyscan_t yyscanner );
#endif
#endif

/* %not-for-header */

/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int extr_lex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int extr_lex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

/* %% [7.0] user's declarations go here */
#line 133 "../parser/extractFile.l"

   /* rules: ==========================================================*/
 /* first rule: */

#line 1276 "extractFile.c"

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			extr_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				extr__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		extr__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 179 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 29 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 29 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 30 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 139 "../parser/extractFile.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: OPEN", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(extOPEN);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 147 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: REC", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = REC;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 157 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: ISO", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = ISO;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 167 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: CAT", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = CAT;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 177 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TGZ", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = TGZ;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 187 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TBZ", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = TBZ;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 197 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: AFIO", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = AFIO;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 207 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: TAR", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = TAR;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 217 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: CPIO", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = CPIO;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 227 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: GZIP", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = GZIP;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 237 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: BZIP", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = BZIP;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 247 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: ZIP", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = ZIP;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 257 "../parser/extractFile.l"
{
    BEGIN(CONTAINERS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: RAR", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    yylval->type = RAR;
    return(extTYPE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 14:
YY_RULE_SETUP
#line 271 "../parser/extractFile.l"
{
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: COLON", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(extCOLON);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 279 "../parser/extractFile.l"
{
#ifdef utMAIN
    logEmit(LOG_INFO, "line %i: HASH = %s", ((ExtrExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    strncpy(yylval->hash, yytext, 32); // must-be
    yylval->hash[MAX_SIZE_HASH] = (char)0;
    return(extHASH);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 289 "../parser/extractFile.l"
{
    BEGIN(INITIAL);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: CLOSE", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(extCLOSE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 17:
YY_RULE_SETUP
#line 302 "../parser/extractFile.l"
{
    BEGIN(CONTENTS);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: IMPLIES", ((ExtrExtra*)yyextra)->lineNo);
#else	/*	: utMAIN	*/
    return(extIMPLIES);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 311 "../parser/extractFile.l"
{
    off_t size = 0;
    size = strtoul(yytext, (char**)0, 10);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: SIZE=%i", ((ExtrExtra*)yyextra)->lineNo, size); 
#else	/*	: utMAIN	*/
    yylval->size = size;
    return(extSIZE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 19:
YY_RULE_SETUP
#line 326 "../parser/extractFile.l"
{
     BEGIN(PATH);
    off_t size = 0;
    size = strtoul(yytext, (char**)0, 10);
#ifdef utMAIN
    logEmit(LOG_DEBUG, "line %i: SIZE=%i", ((ExtrExtra*)yyextra)->lineNo, size); 
#else	/*	: utMAIN	*/
    yylval->size = size;
    return(extSIZE);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 20:
YY_RULE_SETUP
#line 342 "../parser/extractFile.l"
{
    BEGIN(CONTENTS);
#ifdef utMAIN
    logEmit(LOG_INFO, "line %i: STRING = \%s", 
	    ((ExtrExtra*)yyextra)->lineNo, yytext);
#else	/*	: utMAIN	*/
    strncpy(yylval->string, yytext, yyleng); // must-be
    yylval->string[yyleng] = (char)0;
    return(extSTRING);
#endif	/*	: utMAIN	*/
  }
	YY_BREAK


case 21:
YY_RULE_SETUP
#line 358 "../parser/extractFile.l"
{  /* : eat up any unmatched character */
    ++((ExtrExtra*)yyextra)->lineNo;
  }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 362 "../parser/extractFile.l"
{
    BEGIN(INITIAL);
  }
	YY_BREAK


case 23:
YY_RULE_SETUP
#line 370 "../parser/extractFile.l"
/* : eat up any blank character */
	YY_BREAK
case 24:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 371 "../parser/extractFile.l"
/* : eat up comments */
	YY_BREAK
case 25:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 372 "../parser/extractFile.l"
/* : eat up comments */
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 374 "../parser/extractFile.l"
{
    BEGIN(COMMENT);
  }
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 378 "../parser/extractFile.l"
{
    ++((ExtrExtra*)yyextra)->lineNo;
#ifndef utMAIN
    ++env.progBar.cur;
#endif
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 385 "../parser/extractFile.l"
{ /* : Eat up any unmatched character */
    logEmit(LOG_ERR, "line %i: exit on scanner error: %s",
	    ((ExtrExtra*)yyextra)->lineNo, yytext);
    /* generate a parsor error (unexpected $end) */
#ifdef utMAIN
    return -1;
#else
    return extERROR;
#endif
  }
	YY_BREAK

case 29:
YY_RULE_SETUP
#line 398 "../parser/extractFile.l"
ECHO;
	YY_BREAK
#line 1731 "extractFile.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(CONTAINERS):
case YY_STATE_EOF(CONTENTS):
case YY_STATE_EOF(PATH):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * extr_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( extr_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of extr_lex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					extr_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			extr_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) extr_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
/* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 179);

	return yy_is_jam ? 0 : yy_current_state;
}

/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					extr_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( extr_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

/* %% [19.0] update BOL and yylineno */
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void extr_restart  (FILE * input_file , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        extr_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            extr__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	extr__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	extr__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void extr__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		extr_pop_buffer_state();
	 *		extr_push_buffer_state(new_buffer);
     */
	extr_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	extr__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (extr_wrap()) processing, but the only time this flag
	 * is looked at is after extr_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/* %if-c-only */
static void extr__load_buffer_state  (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE extr__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) extr_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in extr__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) extr_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in extr__create_buffer()" );

	b->yy_is_our_buffer = 1;

	extr__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with extr__create_buffer()
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void extr__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		extr_free((void *) b->yy_ch_buf ,yyscanner );

	extr_free((void *) b ,yyscanner );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a extr_restart() or at EOF.
 */
/* %if-c-only */
    static void extr__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	extr__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then extr__init_buffer was _probably_
     * called from extr_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
/* %if-c-only */
    void extr__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		extr__load_buffer_state(yyscanner );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
/* %if-c-only */
void extr_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	extr_ensure_buffer_stack(yyscanner);

	/* This block is copied from extr__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from extr__switch_to_buffer. */
	extr__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
/* %if-c-only */
void extr_pop_buffer_state (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	extr__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		extr__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void extr_ensure_buffer_stack (yyscan_t yyscanner)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)extr_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in extr_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)extr_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in extr_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE extr__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) extr_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in extr__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	extr__switch_to_buffer(b ,yyscanner );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to extr_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       extr__scan_bytes() instead.
 */
YY_BUFFER_STATE extr__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return extr__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to extr_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE extr__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) extr_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in extr__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = extr__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in extr__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE extr_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/* %endif */

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int extr_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int extr_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *extr_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *extr_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int extr_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *extr_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/* %if-reentrant */

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void extr_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/* %endif */

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void extr_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "extr_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void extr_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "extr_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see extr__switch_to_buffer
 */
void extr_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void extr_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int extr_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void extr_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* Accessor methods for yylval and yylloc */

/* %if-bison-bridge */

YYSTYPE * extr_get_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void extr_set_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* %endif */

/* User-visible API */

/* extr_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int extr_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) extr_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* extr_lex_init_extra has the same functionality as extr_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to extr_alloc in
 * the yyextra field.
 */

int extr_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    extr_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) extr_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    extr_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from extr_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * extr_lex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* extr_lex_destroy is for both reentrant and non-reentrant scanners. */
int extr_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		extr__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		extr_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	extr_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        extr_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * extr_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

/* %if-reentrant */
    /* Destroy the main struct (reentrant only). */
    extr_free ( yyscanner , yyscanner );
    yyscanner = NULL;
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *extr_alloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *extr_realloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void extr_free (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see extr_realloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 398 "../parser/extractFile.l"


   /* user code (literally copied to the generated source) :
      ==========*/

/************************************************************************/

#ifdef utMAIN
#include "../misc/command.h"
   //#include <sys/types.h>
   //#include <sys/stat.h>
   //#include <fcntl.h>
GLOBAL_STRUCT_DEF;

/*=======================================================================
 * Function   : usage
 * Description: Print the usage.
 * Synopsis   : static void usage(char* programName)
 * Input      : programName = the name of the program; usually argv[0].
 * Output     : N/A
 =======================================================================*/
static void 
usage(char* programName)
{
  parserUsage(programName);
  fprintf(stderr, " [ -i inputPath ]");
  
  parserOptions();
  fprintf(stderr, "  ---\n"
	  "  -i, --input\t\tinput file to parse\n");
  return;
}


/*=======================================================================
 * Function   : main 
 * Author     : Nicolas ROCHE
 * modif      : 2012/05/01
 * Description: Extract lexer unit test
 * Synopsis   : ./utextractFile
 * Input      : stdin
 * Output     : stdout
 =======================================================================*/
int 
main(int argc, char** argv)
{
  char* inputPath = NULL;
  FILE* inputStream = stdin;
  ExtrExtra extra;
  yyscan_t scanner;
  // ---
  int rc = 0;
  int cOption = EOF;
  char* programName = *argv;
  char* options = PARSER_SHORT_OPTIONS"i:";
  struct option longOptions[] = {
     {"input", required_argument, NULL, 'i'},
    PARSER_LONG_OPTIONS,
    {0, 0, 0, 0}
  };

  // import mdtx environment
  getEnv(&env);

  // parse the command line
  while((cOption = getopt_long(argc, argv, options, longOptions, NULL)) 
	!= EOF) {
    switch(cOption) {
      
    case 'i':
      if(isEmptyString(optarg)) {
	fprintf(stderr, 
		"%s: nil or empty argument for the input stream\n",
		programName);
	rc = 2;
      }
      else {
	if ((inputPath = (char*)malloc(sizeof(char) * strlen(optarg) + 1))
	    == NULL) {
	  fprintf(stderr, 
		  "%s: cannot allocate memory for the input stream name\n", 
		  programName);
	  rc = 3;
	}
	else {
	  strcpy(inputPath, optarg);
	}
      }
      break;
		
      GET_PARSER_OPTIONS; // generic options
    }
    if (rc) goto optError;
  }

  // export mdtx environment
  if (!setEnv(programName, &env)) goto optError;

  /************************************************************************/
  if (extr_lex_init(&scanner)) {
    logEmit(LOG_ERR, "%s", "error initializing scanner");
    goto error;
  }

  extr_set_debug(env.debugLexer, scanner);
  logEmit(LOG_DEBUG, "extr_set_debug = %i", extr_get_debug(scanner));
 
  
  // scan input file if defined
  if (inputPath != NULL) {
    if ((inputStream = fopen(inputPath, "r")) == NULL) {
      logEmit(LOG_ERR, "cannot open input stream: %s", inputPath); 
      goto error;
    }
  }

  // call scanner 
  extra.lineNo = 1;
  extr_set_extra (&extra, scanner);
  extr_set_in(inputStream, scanner);
  if (extr_lex(NULL, scanner)) goto error;
  extr_lex_destroy(scanner);
  fclose(inputStream);
  /************************************************************************/

  destroyString(inputPath);
  rc = TRUE;
 error:
  ENDINGS;
  rc=!rc;
 optError:
  exit(rc);
}
 
#endif // utMAIN

/* Local Variables: */
/* mode: c */
/* mode: font-lock */
/* mode: auto-fill */
/* End: */

