// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef WINDOWCONTENTS_H
#define WINDOWCONTENTS_H

#include <wx/string.h>
#include <wx/wxexpr.h>
#include <wx/app.h>
#include <wx/panel.h>
#include <new>

#include <config.h>
#include "checksetup.h"

#include "exceptions.h"

class EXPORT WindowContents
{
public:
  WindowContents(): expr(NULL), main_panel(NULL) {}
  virtual ~WindowContents() { if(expr != NULL) delete expr; }

  // When Init() is called, we take control of the main window.
  virtual void Init(const wxExpr *e, wxPanel *panel)
    throw(Exception)
  try { expr = e->Copy(); main_panel = panel; }
  catch(std::bad_alloc &ex) { throw NoisyBadAlloc(); }

  // This destroys all the UI stuff. Derived classes _could_ wait until
  // destruction time to destroy other stuff. But after Destroy() is called
  // the derived class should not try to communicate with the user.
  virtual void Destroy() throw() = 0;

  void GoThroughDoor(const wxString& door) throw(Exception);

  virtual wxExpr* cHibernate() throw(Exception) = 0;

public:
  wxPanel *main_panel;

protected:
  const wxExpr *expr;
};

#endif // WINDOWCONTENTS_H

// 
// Local Variables:
// mode: c++
// End:
