// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/layout.h>
#include <wx/intl.h>
#include <wx/statbmp.h>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../windowcontents.h"
#include "sayone.h"
#include "sayonedata.h"
#include "sayonepanel.h"


SayOnePanel::SayOnePanel(SayOne *co, SayOneData *cod)
  throw(Exception) try:
  OnePanel(co, cod)
{
  wxLogTrace("One", "Constructing SayOnePanel.");
  Start();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}


wxWindow *SayOnePanel::cMakeAnswerCtrl(::One::Screen *ocurrent) throw(Exception) try
{
  wxLogTrace("SayOne", "Entering cMakeAnswerCtrl()");

  /////////////////////////////////////////////////////////////////////
  // We currently don't use the passed screen object, but should we
  // ever want to do so, this is the code to do it.
  //
  //    Screen *current = dynamic_cast<Screen*>(ocurrent);
  //    wxASSERT(current != NULL);
  /////////////////////////////////////////////////////////////////////



  wxTextCtrl *tc = new wxTextCtrl(this, ONEPANEL_ANSWERCTRL, wxEmptyString,
				  wxDefaultPosition, wxDefaultSize,
				  wxTE_PROCESS_ENTER, wxDefaultValidator);
  // FIXME: Validator support.
  
  tc->SetFocus();

  return tc;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

SayOnePanel::~SayOnePanel()
{
  wxLogTrace("One", "Destructing SayOnePanel");
}



void SayOnePanel::OnTextEnter(wxCommandEvent &event) throw()
{
  wxTextCtrl *tc = dynamic_cast<wxTextCtrl*>(FindWindow(ONEPANEL_ANSWERCTRL));
  wxASSERT(tc != NULL);

  wxLogTrace("SayOne",
	     "OnTextEnter received text event (\"%s\").",
	     tc->GetValue().c_str());

  try
  {
    SayOneData *data = dynamic_cast<SayOneData*>(m_data);
    wxASSERT(data != NULL);

    data->UserAnswers(tc->GetValue());
    GetTopWindow()->DoSoon(m_one->m_restarter);
  }
  catch(SilentException &ex)
  {
    // Probably means that we go through a door instead.
  }
}

BEGIN_EVENT_TABLE(SayOnePanel, One::OnePanel)
  EVT_TEXT_ENTER(ONEPANEL_ANSWERCTRL, SayOnePanel::OnTextEnter)
END_EVENT_TABLE()
