// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/memory.h>
#include <new>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../htmlpanel.h"
#include "../introwc.h"
#include "../one/one.h"
#include "sayone.h"
#include "sayonepanel.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

void SayOne::Init(const wxExpr *ex,
		  wxPanel *panel) throw(Exception)
try
{
  One::Init(ex, panel);
  wxLogTrace("entering", "SayOne::Init()");

  m_data = new SayOneData(m_filename, this);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void SayOne::EnterRoom() throw(Exception)
try
{
  wxLogTrace("entering", "SayOne::EnterRoom()");

  m_panel = new SayOnePanel(this, dynamic_cast<SayOneData*>(m_data));
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogTrace("entering", "SayOne factory.");
  return new(std::nothrow) SayOne();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogTrace("entering", "WindowContents destruction callback");
  delete w;
}
