// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/wx.h>

#include "roomguard_datacontrol.h"

RGDataControl *RGDataControl::current = NULL;

RGDataControl::RGDataControl()
{
  if(current != NULL)
    throw NoisyException("More than one RGDatacontrol");
  else 
    current = this;
}

RGDataControl::~RGDataControl()
{
  current = NULL;
  
  for(ExprHash::iterator iter = m_hash.begin(); iter != m_hash.end(); ++iter)
  {
    delete iter->second;
    iter->second = NULL;
  }
}

void RGDataControl::AddLabelledData(const wxString &label, wxExpr *value)
  throw(Exception)
try
{
  if(value == NULL)
    throw NullException("AddLabelledData(label, NULL)");

  m_hash[label] = value->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

wxExpr* RGDataControl::cGetData(const wxString &label)
  throw(Exception)
try
{
  ExprHash::iterator i = m_hash.find(label);

  if(i == m_hash.end())
    throw NullException("GetData(label) = NULL");
  else if(i->second == NULL)
    throw NullException("GetData(label) = i->second = NULL");
  else
    return i->second->Copy();
}
catch(std::bad_alloc &es)
{
  throw NoisyBadAlloc();
}

void RGDataControl::ForgetData(const wxString &label) throw()
{
  ExprHash::iterator i = m_hash.find(label);
  
  if(i != m_hash.end())
  {
    if(i->second != NULL)
    {
      delete i->second;
      i->second = NULL;
    }
    m_hash.erase(i);
  }
}

void RGDataControl::Replace(wxExpr *new_room) throw(Exception)
{
  // WC objects should use GetData(label) instead.
}

void RGDataControl::Init(const wxExpr *expr) throw(Exception)
try
{
  const wxExpr *el = expr->AttributeValue("data_labels");
  // el is a wxExpr list
  

  if(el == NULL)
    throw NoisyException("RGDataControl wants a list called \"data_labels\"");

  if(el->Type() != wxExprList)
  {
    throw NoisyException("RGDataControl wants a list called \"data_labels\"");
  }
 
  wxString key;
  for(wxExpr *item = el->GetFirst(); item != NULL; item = item->GetNext())
  {
    if(item->Type() != wxExprString)
    {
      throw NoisyException(_("Each item in a \"data_labels\" list must be a string."));
    }

    key = item->StringValue();
    AddLabelledData(key, expr->AttributeValue(key)); // data is automatically copied.
  }
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

wxExpr* RGDataControl::cHibernate() throw(Exception)
try
{
  wxExpr *expr = new wxExpr("data_control");
  wxExpr *el = new wxExpr(wxExprList);

  for(ExprHash::iterator iter = m_hash.begin(); iter != m_hash.end(); ++iter)
  {
    el->Append(new wxExpr(wxExprString, iter->first));
    expr->AddAttributeValue(iter->first, iter->second->Copy());
  }
  expr->AddAttributeValue("data_labels", el);
  return expr;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}
