// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef MULTSIMDATA_H
#define MULTSIMDATA_H

#include <wx/object.h>
#include <wx/wxexpr.h>

#include <config.h>
#include "../checksetup.h"

#include "multsim.h"

class MultSimData
{
public:
  MultSimData(MultSim *ms, const wxExpr *expr) throw(Exception);

  int GetRows() const throw() { return m_rows; }
  int GetColumns() const throw() { return m_columns; }

  wxString GetQuestion(int n) const throw() { return m_questions[n]; }
  wxString GetAnswer(int n) const throw() { return m_answers[n]; }

private:
  int m_columns, m_rows;
  wxArrayString m_questions;
  wxArrayString m_answers;
  MultSim *m_ms;
};

#endif // MULTSIMDATA_H

// 
// Local Variables:
// mode: c++
// End:
