// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef MULTSIM_H
#define MULTSIM_H

#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <config.h>
#include "../checksetup.h"

class MultSim;

#include "../application.h"
#include "../introwc.h"
#include "../theme.h"
#include "multsimpanel.h"
#include "multsimdata.h"

// The MultSim class is a WindowContents class that asks the user
// multiple questions, and where all questions are visible
// simultaneously.

class MultSim: public IntroWC
{
public:
  MultSim() throw(): m_panel(NULL), m_data(NULL),
		     m_correct(0) {}

  virtual void Init(const wxExpr *expr,
		    wxPanel *panel) throw(Exception);

  virtual void EnterRoom() throw(Exception);

  virtual MultSimPanel* GetPanel() throw()
  { wxASSERT(m_panel != NULL); return m_panel; }

  virtual void Destroy() throw();

  virtual wxExpr* cHibernate() throw(Exception);

  void OneMoreCorrect() throw();

  friend class MultSimPanel;
private:
  MultSimPanel *m_panel;
  MultSimData *m_data;
  int m_correct;

  Theme *m_theme;
};

#endif // MULTSIM_H

// 
// Local Variables:
// mode: c++
// End:
