// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/textctrl.h>

#include <iostream>

#include <config.h>
#include "../checksetup.h"

#include "../windowcontents.h"
#include "../application.h"
#include "../htmlpanel.h"
#include "final.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

namespace
{
  void OnExit() throw()
  try
  {
    wxLogDebug("\"Exit\" button chosen");
    GetTopWindow()->Close();
  }
  catch(NullException &ex)
  {
    abort();			// If we can't close, we're in serious trouble
  }
}

void Final::Init(const wxExpr *ex,
		 wxPanel *panel) throw(Exception)
try
{
  wxLogTrace("entering", "Final::Init()");
  WindowContents::Init(ex, panel);

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &ex) {} 	// harmless, there is no current wc.

  wxLogDebug("Done destroying the current WC. Now doing other stuff.");
  
  m_button_clicked = new Function(OnExit);

  wxString html_file, button_text, button_help;
  try
  {
    GetLocalizedAttribute(expr, "html_file", html_file); 
    GetLocalizedAttribute(expr, "button_text", button_text);
    GetLocalizedAttribute(expr, "button_help", button_help);
    html_file = from_utf8(html_file);
    button_text = from_utf8(button_text);
    button_help = from_utf8(button_help);
  }
  catch(Exception &ex)
  {
    throw NoisyException(_("Malformed item in room list: the final "
			   "module requires the attributes "
			   "\"html_file\", \"button_text\" and "
			   "\"button_help\"."));
  }

  try
  {
    html_file = GetApp()->config->GetModuleDataFile(html_file);
  }
  catch(...)
  {
    wxLogDebug("Could not find the HTML file, the HtmlPanel will complain...");
  }

  m_panel = new HtmlPanel(this, html_file, button_text, button_help, *m_button_clicked);

}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void Final::Destroy() throw()
{
  wxLogDebug("Final::Destroy(): clearing window.");
  main_panel->DestroyChildren();
}

Final::~Final() throw()
{
  if(m_button_clicked)
  {
    delete m_button_clicked;
    m_button_clicked = NULL;
  }
}

wxExpr* Final::cHibernate() throw(Exception)
try
{
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogDebug("Creating an Final object.");
  return new(std::nothrow) Final();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogDebug("Deleting a WindowContents object (i.e. an Final object)");
  delete w;
}
