// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef EXCEPTIONS_H
#define EXCEPTIONS_H

#include <wx/string.h>

#include <config.h>
#include "checksetup.h"

class Exception
{
public:
  Exception(const wxString &what) throw();

  const char* what() const throw() { return m_what.c_str(); }

  bool Close() throw();

private:
  wxString m_what;
};

// When a silent exception is thrown, the user has already been notified.
class SilentException: public Exception
{
public:
  SilentException(const wxString &what) throw(): Exception(what) {}
};


// When a noisy exception is thrown, the user is notified when the
// exception is created.
class NoisyException: public Exception
{
public:
  NoisyException(const wxString &what) throw();
};

class NoisyBadAlloc: public NoisyException
{
public:
  NoisyBadAlloc() throw();
};

class NullException: public SilentException
{
public:
  NullException(const wxString &which) throw():
    SilentException("Null pointer, " + which) {}
};

#endif // EXCEPTIONS_H

// 
// Local Variables:
// mode: c++
// End:
