// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/layout.h>
#include <wx/intl.h>
#include <wx/statbmp.h>
#include <wx/listctrl.h>

#include <climits>

#include <config.h>
#include "../checksetup.h"

#include "../application.h"
#include "../windowcontents.h"
#include "chooseone.h"
#include "chooseonedata.h"
#include "chooseonepanel.h"


ChooseOnePanel::ChooseOnePanel(ChooseOne *co, ChooseOneData *cod)
  throw(Exception) try:
  OnePanel(co, cod)
{
  wxLogTrace("One", "Constructing ChooseOnePanel.");
  Start();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}


wxWindow *ChooseOnePanel::cMakeAnswerCtrl(::One::Screen *ocurrent) throw(Exception) try
{
  wxLogTrace("ChooseOne", "Entering cMakeAnswerCtrl()");
  Screen *current = dynamic_cast<Screen*>(ocurrent);
  wxASSERT(current != NULL);

  int length = 10;
  for(Screen::choice_iterator iter = current->choices.begin();
      iter != current->choices.end();
      ++iter)
  {
    if(iter->Length() > length)
      length = iter->Length();
  }

  // Preparing the wxListCtrl lc:
  wxListCtrl *lc = new wxListCtrl(this, ONEPANEL_ANSWERCTRL, wxDefaultPosition,
				  wxDefaultSize, wxLC_REPORT | wxLC_NO_HEADER);
  lc->InsertColumn(0, "Answer"); // The header of the column will never be displayed.
  lc->SetColumnWidth(0, length * lc->GetCharWidth() + 2);
  
  for(Screen::choice_iterator iter = current->choices.begin();
      iter != current->choices.end();
      ++iter)
  {
    lc->InsertItem(static_cast<long>(iter - current->choices.begin()), *iter);
  }
  int lcwidth, lcheight;
  lc->GetSize(&lcwidth, &lcheight);
  if(lc->GetCountPerPage() < current->choices.size())
    lcheight *= lc->GetItemCount() / 
      ((lc->GetCountPerPage() != 0) ? lc->GetCountPerPage() : 1);

  lc->SetClientSize(lc->GetColumnWidth(0), lcheight);

  while(lc->GetCountPerPage() > current->choices.size())
  {
    lcheight -= 2;
    lc->SetClientSize(lc->GetColumnWidth(0), lcheight);
  }
  lcheight += 2;
  lc->SetClientSize(lc->GetColumnWidth(0)+10, lcheight);

  return lc;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

ChooseOnePanel::~ChooseOnePanel()
{
  wxLogTrace("One", "Destructing ChooseOnePanel");
}

void ChooseOnePanel::OnItemActivated(wxListEvent &event) throw()
{
  wxLogTrace("ChooseOne",
	     "OnItemActivated received list event. Item number %ld (index %ld) selected.",
	     event.GetIndex() + 1, event.GetIndex());

  // GetIndex() returns a long, but there _should_ not be any problems
  // converting it to an int.
  wxASSERT(event.GetIndex() >= 0);
  wxASSERT(event.GetIndex() < INT_MAX);
  
  try
  {
    ChooseOneData *data = dynamic_cast<ChooseOneData*>(m_data);
    wxASSERT(data != NULL);

    data->SetSelection(static_cast<int>(event.GetIndex()));
    GetTopWindow()->DoSoon(m_one->m_restarter);
  }
  catch(SilentException &ex)
  {
    // Probably means that we go through a door instead.
  }
}

void ChooseOnePanel::OnChar(wxKeyEvent &event) throw()
{
  wxLogTrace("ChooseOne", "OnChar received character.");
  wxWindow *lc = FindWindow(ONEPANEL_ANSWERCTRL);
  if(lc != NULL)
    lc->SetFocus();
}

BEGIN_EVENT_TABLE(ChooseOnePanel, One::OnePanel)
  EVT_LIST_ITEM_ACTIVATED(ONEPANEL_ANSWERCTRL, ChooseOnePanel::OnItemActivated)
  EVT_CHAR(ChooseOnePanel::OnChar)
END_EVENT_TABLE()
