// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef SAYONEDATA_H
#define SAYONEDATA_H

#include <wx/object.h>
#include <wx/bitmap.h>
#include <wx/wxexpr.h>
#include <wx/panel.h>

#include <vector>
using namespace std;

#include <config.h>
#include "../checksetup.h"

class SayOneData;

#include "../application.h"
#include "../exceptions.h"
#include "../introwc.h"
#include "../theme.h"
#include "../one/onedata.h"
#include "sayone.h"
#include "sayonepanel.h"

// The CooseOneData class is for the SayOne what the RoomList is
// for the Application.

using ::One::Screen;

class SayOneData: public One::OneData
{
public:
  SayOneData(const wxString &filename, SayOne *co) throw(Exception);
  virtual ~SayOneData() throw();

  void UserAnswers(const wxString &answer) throw(Exception);
  Screen *cGetScreen() throw(Exception);
protected:
  virtual void AddAnswersToScreen(wxExpr *e_screen, One::Screen *screen);
  virtual Screen *cScreen() throw(Exception) try { return new Screen; }
            catch(std::bad_alloc &exception) { throw NoisyBadAlloc(); }


public:
  void SaveData(const wxString &title) const throw();
};

#endif // SAYONEDATA_H

// 
// Local Variables:
// mode: c++
// End:
