// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/log.h>
#include <wx/image.h>

#include <new>

#include <config.h>
#include "../checksetup.h"

#include "sayonedata.h"

bool myErrorHandler(int err, char *msg)
{
  if(err == WXEXPR_ERROR_SYNTAX)
  {
    wxLogError(_("Syntax error in SayOne file: %s"), msg);
  }
  else
  {
    wxLogError(_("Error while processing SayOne file: %s"), msg);
  }
  return true;			// Continue anyway
}


SayOneData::SayOneData(const wxString &filename, SayOne *co)
  throw(Exception) try:
  OneData(filename, co)
{
  wxLogTrace("One", "Constructing SayOneData");
  wxASSERT(co != NULL);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

SayOneData::~SayOneData() throw()
{
  wxLogTrace("One", "Destructing SayOneData");
}

void SayOneData::UserAnswers(const wxString &answer) throw(Exception)
{
  wxLogTrace("SayOne", "SayOne::UserAnswers(\"%s\")", answer.c_str());

  wxASSERT(this != NULL);
  wxASSERT(m_db != NULL);

  m_db->BeginFind();
  wxExpr *e_screen = m_db->FindClauseByFunctor(m_current_screen);

  if(e_screen == NULL)
    throw NoisyException(wxString::Format
			 (_("Error in SayOne file. Could not retrieve "
			   "the clause named \"%s\"."),
			  m_current_screen.c_str()));

  wxExpr *el = e_screen->AttributeValue("answers");

  bool good = false;

  if(el->Type() == wxExprList)
  {
     wxExpr *item = el->GetFirst();
     for(; item != NULL; item = item->GetNext())
     {
       if(item->Type() == wxExprString)
       {
	 if(from_utf8(item->StringValue()) == answer)
	   good = true;
       }
       else
       {
	 wxLogWarning(_("Non-string list item discovered in SayOne file."));
       }
     }
  }
  else
  {
    throw NoisyException
      (wxString::Format(_("There is no attribute called \"answers\" in the clause "
			  "\"%s\" in the SayOne file."), m_current_screen.c_str()));
  }

  if(good)
    e_screen->GetAttributeValue("correct_goto", m_current_screen);
  else
    e_screen->GetAttributeValue("incorrect_goto", m_current_screen);

  wxLogTrace("SayOne", "The current screen is now \"%s\"", m_current_screen.c_str());
  
  m_db->BeginFind();
  if(m_db->FindClauseByFunctor(m_current_screen) == NULL)
  {
    m_one->GoThroughDoor(m_current_screen);
    throw SilentException("Just relax, don't do anything, everything is under control.");
  }
}

void SayOneData::AddAnswersToScreen(wxExpr *e_screen, One::Screen *oscreen)
{
  // This function is not needed in this class, but used extensively in ChooseOne.
}


void SayOneData::SaveData(const wxString &title) const throw()
try
{
  // FIXME

//   wxExpr *el = new wxExpr(wxExprList);

//   for(list<SelfCorrecting*>::iterator iter = m_sc.begin();
//       iter != m_sc.end();
//       ++iter)
//   {
//     if(*iter != NULL)
//     {
//       el->Append(new wxExpr(wxExprString, (*iter)->GetValue()));
//     }
//     else
//     {
//       el->Append(new wxExpr(wxExprString, ""));
//     }
//   }

//   // AddLabelledData() makes a local copy.
//   GetApp()->AddLabelledData(title, el);

//   delete el;
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}


// void SayOnePanel::LoadData() throw()
// try
// {
//   wxExpr *el = GetApp()->cGetData(m_ms->expr->Functor() + "_data");

//   if(el->Type() == wxExprList)
//   {
//     wxExpr *item = el->GetFirst();
//     list<SelfCorrecting*>::iterator iter = m_sc.begin();
//     for(; item != NULL && iter != m_sc.end(); (item = item->GetNext()), ++iter)
//     {
//       if(item->Type() == wxExprString)
//       {
// 	if(*iter != NULL)
// 	{
// 	  (*iter)->SetValue(item->StringValue());
// 	}
//       }
//     }
//   }

//   delete el;

//   // If there was any data, it was probably in a file the user had
//   // saved, and should not be used again during this session.
//   GetApp()->ForgetData(m_ms->expr->Functor() + "_data");
// }
// catch(NullException &ex)
// {
//   wxLogDebug("There is no saved data for this object.");
// }
