// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <wx/object.h>
#include <wx/wxexpr.h>
#include <wx/log.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/layout.h>
#include <wx/textctrl.h>

#include <iostream>

#include <config.h>
#include "../checksetup.h"

#include "../windowcontents.h"
#include "initialscreen.h"
#include "initialpanel.h"
#include "../application.h"

extern "C" char *version(void)
{
  return PACKAGE_STRING;
}

extern "C" char *type(void)
{
  return "WindowContents";	// This is a WindowContents object
}

void InitialScreen::Init(const wxExpr *ex,
			 wxPanel *panel) throw(Exception)
try
{
  wxLogDebug("Entering InitialScreen::Init()");
  WindowContents::Init(ex, panel);

  try
  {
    GetApp()->GetCurrentWC()->Destroy();
  }
  catch(NullException &exception) {} 	// harmless, there is no current wc.
  
  wxString theme_name;
  expr->GetAttributeValue("theme", theme_name);
  if(theme_name != wxEmptyString)
    m_theme = new Theme(theme_name);
  else
    m_theme = NULL;

  m_panel = new InitialPanel(this);
}
catch(std::bad_alloc &exception)
{
  throw NoisyBadAlloc();
}

void InitialScreen::Destroy() throw()
{
  wxLogTrace("entering", "InitialScreen::Destroy(): clearing window.");
  
  if(m_panel != NULL)
  {
    m_panel->SetEvtHandlerEnabled(false);
    m_panel = NULL;
  }
  
  main_panel->DestroyChildren(); 

  if(m_theme != NULL)
  {
    delete m_theme;
    m_theme = NULL;
  }
}

wxExpr* InitialScreen::cHibernate() throw(Exception)
try
{
  return expr->Copy();
}
catch(std::bad_alloc &ex)
{
  throw NoisyBadAlloc();
}

// The class factories

extern "C" WindowContents* create(void)
{
  wxLogDebug("Creating an InitialScreen object.");
  return new(std::nothrow) InitialScreen();
}

extern "C" void destroy(WindowContents *w)
{
  wxLogDebug("Deleting a WindowContents object (i.e. an InitialScreen object)");
  delete w;
}
