// A mathematical game
// Copyright (C) 2004-2005 by Christian von Schultz <schultz@linux.nu>

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <wx/log.h>

#include "checksetup.h"

#include "mainwindow.h"
#include "application.h"
#include "exceptions.h"
#include "wordwrap.h"

Exception::Exception(const wxString &what) throw():
  m_what(what)
{
}

bool Exception::Close() throw()
{
  try
  {
    return GetTopWindow()->Close(true);	// no veto, force=true
  }
  catch(NullException &ex)
  {
    return false;
  }
}

NoisyException::NoisyException(const wxString &what) throw():
  Exception(what)
{
  wxLogError(WordWrap(what.c_str()));
  wxLog::FlushActive();
}

NoisyBadAlloc::NoisyBadAlloc() throw():
  NoisyException(_("Out of memory error. You seem to need more memory "
		   "in order to run this program."))
{
}
