/*
 * Make7Libre, free (as in freedom) implementation of the
 * unfamous game 'Make 7 Hexa Puzzle'
 * Copyright 2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Make7Libre.
 * 
 * Make7Libre is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Make7Libre is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Make7Libre.  If not, see <http://www.gnu.org/licenses/>.
 */
/***********
 * main.cc *
 * ~~~~~~~ *
 ***********/

#include <iostream>
#include <stdlib.h>
#include <gtkmm.h>
#include "../include/game.h"

int
main (int argc, char** argv)
{
  Gtk::Main kit (int argc, char** argv);
  Glib::RefPtr<Gtk::Application> app =
    Gtk::Application::create (argc, argv, "org.gtkmm.example");
  Game* game = new Game ();
  /* Seeding the random */
  // TODO
  //  std::seed (128);
  /* Importation */
  game->import_every_widget ();
  /* Connexion */
  game->connect_every_button ();
  /* First game */
  game->launch_game ();
  game->display (app);
  game->end_game ();
  return 0;
}

