;;;; encoding.lisp --- example for libxml-clisp tutorial

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-09-01
;;; 
;;; $Hg: encoding.lisp,v ae6366215b15 2009-09-03T20:01:35+05:30 raghu $

(in-package "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES")



(defun new-document-with-encoding (name content filename encoding)
  (with-new-document (document "1.0")
    (let ((node (new-node-in-document document name :content content)))
      (setf (document-element document) node)
      (document-to-file document filename :encoding encoding))))

(defun document-with-encoding-test-data (encoding)
  (format nil "<?xml version=\"1.0\" encoding=\"~A\"?>
<foo>bar</foo>
" (encoding-name encoding)))

(defun test-document-with-encoding (encoding)
  (with-temp-file (file)
    (new-document-with-encoding "foo" "bar" file encoding)
    (list (with-open-file (in file :element-type '(unsigned-byte 8))
              (loop for octet = (read-byte in nil nil)
                 while octet
                 collect octet))
            (coerce
             (ext:convert-string-to-bytes (document-with-encoding-test-data
                                           encoding) encoding)
             'list))))

(defun test-encoding ()
  (loop for encoding in
       (list charset:unicode-16-big-endian
             charset:unicode-16-little-endian
             charset:unicode-32-big-endian
             charset:unicode-32-little-endian
             ;; TODO.  Libxml2 treats UTF-16 as little-endian, whereas
             ;; CLISP treats it as big-endian.  When converting a
             ;; UTF-16 foreign string (i.e., octet-vector) returned by
             ;; Libxml2 to a Lisp string, this has to be taken care
             ;; of.  See RFC 2781.  Until this is done, we cannot add
             ;; `charset:utf-16' here.
             charset:utf-8
             charset:iso-8859-1
             charset:ascii)
     for result = (test-document-with-encoding encoding)
     always (equal (first result) (second result))))

(provide-example 'encoding)



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; encoding.lisp ends here