;;;; foreign.lisp --- FFI definitions for libxml-clisp

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-08-02
;;; 
;;; $Hg: foreign.lisp,v fa97b54d6d45 2009-09-28T18:22:09+05:30 raghu $

;;;; All foreign functions whose names have the prefix "lxcl_" are
;;;; defined in `libxml-clisp.c'.

(in-package "NET.RETROTEXTS.LIBXML-CLISP")

(default-foreign-language :stdc)
(default-foreign-library net.retrotexts.libxml-clisp.system:*libxml-clisp.so*)



;;;; Library version and initialization.

(def-call-out $lxcl-libxml-version (:name "lxcl_libxml_version")
  (:return-type int)
  (:arguments)
  (:documentation
   "Return the libxml2 version as an integer.
The version string \"1.2.3\" corresponds to the version number
10203."))

(def-call-out $xml-check-version (:name "xmlCheckVersion")
  ;; xmlversion.h
  (:return-type nil)
  (:arguments (version int))
  (:documentation
   "Check the compiled version of libxml2 against the `include' one.
This can warn or immediately kill the application."))



;;;; Memory management.

(def-call-out $lxcl-free (:name "lxcl_free")
  (:return-type nil)
  (:arguments (mem c-pointer))
  (:documentation
   "Free the block of memory at MEM allocated by libxml2."))

(def-call-out $xml-free-doc (:name "xmlFreeDoc")
  ;; tree.h
  (:return-type nil)
  (:arguments (cur $xml-doc-ptr))
  (:documentation
   "Free the memory allocated to CUR."))



;;;; An XML String.

(def-call-out address-as-foreign-string (:name "ffi_identity")
  ;; clisp/src/foreign.d and clisp/tests/ffi.tst
  (:return-type c-string)
  (:arguments (foreign-address c-pointer))
  (:library)
  (:documentation
   "Return the string encoded by the octet sequence at FOREIGN-ADDRESS.
The octet sequence is assumed to be terminated by the zero octet, and
is considered to be the encoding of the string according to
`custom:*foreign-encoding*'."))



;;;; A Namespace.

;;; Properties of a Namespace.

(def-call-out $lxcl-ns-next (:name "lxcl_ns_next")
  (:return-type $xml-ns-ptr)
  (:arguments (ns $xml-ns-ptr)))

(def-call-out $lxcl-ns-type (:name "lxcl_ns_type")
  (:return-type $xml-ns-type)
  (:arguments (ns $xml-ns-ptr)))

(def-call-out $lxcl-ns-href (:name "lxcl_ns_href")
  (:return-type $xml-char-ptr)
  (:arguments (ns $xml-ns-ptr)))

(def-call-out $lxcl-ns-prefix (:name "lxcl_ns_prefix")
  (:return-type $xml-char-ptr)
  (:arguments (ns $xml-ns-ptr)))

(def-call-out $lxcl-ns-private (:name "lxcl_ns_private")
  (:return-type c-pointer)
  (:arguments (ns $xml-ns-ptr)))

(def-call-out $lxcl-ns-context (:name "lxcl_ns_context")
  (:return-type $xml-doc-ptr)
  (:arguments (ns $xml-ns-ptr)))



;;;; A Dtd.

;;; Properties of a Dtd.

(def-call-out $lxcl-dtd-private (:name "lxcl_dtd_private")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-type (:name "lxcl_dtd_type")
  (:return-type $xml-element-type)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-name (:name "lxcl_dtd_name")
  (:return-type $xml-char-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-children (:name "lxcl_dtd_children")
  (:return-type $xml-node-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-last (:name "lxcl_dtd_last")
  (:return-type $xml-node-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-parent (:name "lxcl_dtd_parent")
  (:return-type $xml-doc-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-next (:name "lxcl_dtd_next")
  (:return-type $xml-node-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-prev (:name "lxcl_dtd_prev")
  (:return-type $xml-node-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-doc (:name "lxcl_dtd_doc")
  (:return-type $xml-doc-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-notations (:name "lxcl_dtd_notations")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-elements (:name "lxcl_dtd_elements")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-attributes (:name "lxcl_dtd_attributes")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-entities (:name "lxcl_dtd_entities")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-external-id (:name "lxcl_dtd_external_id")
  (:return-type $xml-char-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-system-id (:name "lxcl_dtd_system_id")
  (:return-type $xml-char-ptr)
  (:arguments (dtd $xml-dtd-ptr)))

(def-call-out $lxcl-dtd-pentities (:name "lxcl_dtd_pentities")
  (:return-type c-pointer)
  (:arguments (dtd $xml-dtd-ptr)))



;;;; An Attribute.

;;; Properties of an Attribute.

(def-call-out $lxcl-attr-private (:name "lxcl_attr_private")
  (:return-type c-pointer)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-type (:name "lxcl_attr_type")
  (:return-type $xml-element-type)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-name (:name "lxcl_attr_name")
  (:return-type $xml-char-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-children (:name "lxcl_attr_children")
  (:return-type $xml-node-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-last (:name "lxcl_attr_last")
  (:return-type $xml-node-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-parent (:name "lxcl_attr_parent")
  (:return-type $xml-node-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-next (:name "lxcl_attr_next")
  (:return-type $xml-attr-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-prev (:name "lxcl_attr_prev")
  (:return-type $xml-attr-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-doc (:name "lxcl_attr_doc")
  (:return-type $xml-doc-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-ns (:name "lxcl_attr_ns")
  (:return-type $xml-ns-ptr)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-atype (:name "lxcl_attr_atype")
  (:return-type $xml-attribute-type)
  (:arguments (attr $xml-attr-ptr)))

(def-call-out $lxcl-attr-psvi (:name "lxcl_attr_psvi")
  (:return-type c-pointer)
  (:arguments (attr $xml-attr-ptr)))



;;;; A Node.

;;; Properties of a Node.

(def-call-out $lxcl-node-private (:name "lxcl_node_private")
  (:return-type c-pointer)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-type (:name "lxcl_node_type")
  (:return-type $xml-element-type)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-name (:name "lxcl_node_name")
  (:return-type $xml-char-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-children (:name "lxcl_node_children")
  (:return-type $xml-node-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-last (:name "lxcl_node_last")
  (:return-type $xml-node-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-parent (:name "lxcl_node_parent")
  (:return-type $xml-node-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-next (:name "lxcl_node_next")
  (:return-type $xml-node-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-prev (:name "lxcl_node_prev")
  (:return-type $xml-node-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-doc (:name "lxcl_node_doc")
  (:return-type $xml-doc-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-ns (:name "lxcl_node_ns")
  (:return-type $xml-ns-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-content (:name "lxcl_node_content")
  (:return-type $xml-char-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-properties (:name "lxcl_node_properties")
  (:return-type $xml-attr-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-ns-def (:name "lxcl_node_ns_def")
  (:return-type $xml-ns-ptr)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-psvi (:name "lxcl_node_psvi")
  (:return-type c-pointer)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-line (:name "lxcl_node_line")
  (:return-type ushort)
  (:arguments (node $xml-node-ptr)))

(def-call-out $lxcl-node-extra (:name "lxcl_node_extra")
  (:return-type ushort)
  (:arguments (node $xml-node-ptr)))



;;;; A Document.

;;; Properties of a Document.

(def-call-out $lxcl-doc-private (:name "lxcl_doc_private")
  (:return-type c-pointer)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-type (:name "lxcl_doc_type")
  (:return-type $xml-element-type)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-name (:name "lxcl_doc_name")
  (:return-type c-string)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-children (:name "lxcl_doc_children")
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-last (:name "lxcl_doc_last")
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-parent (:name "lxcl_doc_parent")
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-next (:name "lxcl_doc_next")
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-prev (:name "lxcl_doc_prev")
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-doc (:name "lxcl_doc_doc")
  (:return-type $xml-doc-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-compression (:name "lxcl_doc_compression")
  (:return-type int)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-standalone (:name "lxcl_doc_standalone")
  (:return-type int)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-int-subset (:name "lxcl_doc_int_subset")
  (:return-type $xml-dtd-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-ext-subset (:name "lxcl_doc_ext_subset")
  (:return-type $xml-dtd-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-old-ns (:name "lxcl_doc_old_ns")
  (:return-type $xml-ns-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-version (:name "lxcl_doc_version")
  (:return-type $xml-char-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-encoding (:name "lxcl_doc_encoding")
  (:return-type $xml-char-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-ids (:name "lxcl_doc_ids")
  (:return-type c-pointer)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-refs (:name "lxcl_doc_refs")
  (:return-type c-pointer)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-url (:name "lxcl_doc_url")
  (:return-type $xml-char-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-charset (:name "lxcl_doc_charset")
  (:return-type int)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-dict (:name "lxcl_doc_dict")
  (:return-type $xml-dict-ptr)
  (:arguments (doc $xml-doc-ptr)))

(def-call-out $lxcl-doc-psvi (:name "lxcl_doc_psvi")
  (:return-type c-pointer)
  (:arguments (doc $xml-doc-ptr)))



;;;; Tree operations.

(def-call-out $xml-doc-get-root-element (:name "xmlDocGetRootElement")
  ;; tree.h
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr))
  (:documentation
   "Return the address of the root node of the document DOC.
Returns false if DOC does not contain a root node, i.e., if it is an
empty document."))

(def-call-out $xml-doc-set-root-element (:name "xmlDocSetRootElement")
  ;; tree.h
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr) (root $xml-node-ptr))
  (:documentation
   "Set the document element of the document DOC to ROOT.
Returns the address of the old document element of DOC if DOC already
had a document element, otherwise nil.  No action is taken if ROOT is
nil."))

(def-call-out $xml-new-text-child (:name "xmlNewTextChild")
  ;; tree.h
  (:return-type $xml-node-ptr)
  (:arguments (parent $xml-node-ptr) (ns $xml-ns-ptr)
              (name $xml-char-ptr) (content $xml-char-ptr))
  (:documentation
   "Create a fresh element named NAME as a child of PARENT.
The freshly created element is appended to the list of children of
PARENT. NS and CONTENT maybe nil. If NS is nil, the freshly created
element inherits the namespace of PARENT. If CONTENT is non-nil, a
child text node of the new element will also be created containing the
string CONTENT.  Reserved XML characters, such as the ampersand,
greater-than or less-than signs, that appear in CONTENT, are
automatically replaced by their XML escaped entity representations."))

(def-call-out $xml-node-list-get-string (:name "xmlNodeListGetString")
  ;; tree.h
  (:return-type $xml-char-ptr)
  (:arguments (doc $xml-doc-ptr)
              (list $xml-node-ptr)
              (in-line int))
  (:documentation
   "Return the concatenation of the text elements of LIST.
The context for the operation is provided by the document DOC.  If
IN-LINE is nonzero, then entity references will be replaced.  It is up
to the caller to free the returned address using `free-address'."))

(def-c-var $xml-indent-tree-output (:name "xmlIndentTreeOutput")
  ;; globals.h
  (:type int)
  (:documentation
   "If set, XML trees are indented upon output."))

(def-call-out $xml-save-format-file-to (:name "xmlSaveFormatFileTo")
  ;; tree.h
  (:return-type int)
  (:arguments (buf $xml-output-buffer-ptr) (cur $xml-doc-ptr)
              (encoding c-string) (format int))
  (:documentation
   "Write the document CUR to the IO buffer BUF using encoding ENCODING.
If FORMAT is set, then the output is indented.  Calls
xmlOutputBufferClose() on BUF after finishing the writing, so BUF will
not be available after this function is executed.  Returns the number
of octets written, or -1 in case of error."))

(def-call-out $xml-save-format-file-enc (:name "xmlSaveFormatFileEnc")
  ;; tree.h
  (:return-type int)
  (:arguments (filename c-string) (cur $xml-doc-ptr)
              (encoding c-string) (format int))
  (:documentation
   "Save the document CUR to a file using the encoding ENCODING.
Will use compression if compiled in and enabled.  If FILENAME is
\"-\", the stdout file is used.  If FORMAT is set, the document will
be indented on output.  Note that FORMAT = 1 provide node indenting
only if xmlIndentTreeOutput = 1 or xmlKeepBlanksDefault(0) was called.
Returns the number of octets written, or -1 in case of error."))

(def-call-out $xml-new-prop (:name "xmlNewProp")
  ;; tree.h
  (:return-type $xml-attr-ptr)
  (:arguments (node $xml-node-ptr) (name $xml-char-ptr) (value $xml-char-ptr))
  (:documentation
   "Add a fresh attribute to NODE with name NAME and value VALUE.
Returns the address of the freshly created attribute."))

(def-call-out $xml-get-prop (:name "xmlGetProp")
  ;; tree.h
  (:return-type $xml-char-ptr)
  (:arguments (node $xml-node-ptr) (name $xml-char-ptr))
  (:documentation
   "Return the value of the attribute of NODE with name NAME.
Entities in the values are replaced.  Ignores namespaces associated to
the attribute.  Use xmlGetNsProp() or xmlGetNoNsProp() for namespace
aware processing.  It is up to the caller to free the returned
address."))

(def-call-out $xml-new-doc (:name "xmlNewDoc")
  ;; tree.h
  (:return-type $xml-doc-ptr)
  (:arguments (version $xml-char-ptr))
  (:documentation
   "Create a new XML document with XML version VERSION.
VERSION must represent a string of the form \"1.0\".  Returns the
address of the newly created document."))

(def-call-out $xml-new-doc-node (:name "xmlNewDocNode")
  ;; tree.h
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr) (ns $xml-ns-ptr)
              (name $xml-char-ptr) (content $xml-char-ptr))
  (:documentation
   "Create a new node in the document DOCUMENT.
NS and CONTENT are optional, and can be null addresses.  CONTENT is
assumed to be a piece of XML CDATA, so it allows entities references,
but XML special characters need to be escaped first by using
xmlEncodeEntitiesReentrant().  Returns the address of the newly
created node."))

(def-call-out $xml-new-doc-raw-node (:name "xmlNewDocRawNode")
  ;; tree.h
  (:return-type $xml-node-ptr)
  (:arguments (doc $xml-doc-ptr) (ns $xml-ns-ptr)
              (name $xml-char-ptr) (content $xml-char-ptr))
  (:documentation
   "Create a new node in the document DOCUMENT.
NS and CONTENT are optional, and can be null addresses.  XML special
characters in CONTENT need to be escaped first by using
xmlEncodeEntitiesReentrant().  Returns the address of the newly
created node."))



;;;; Parser.

(def-call-out $xml-parse-file (:name "xmlParseFile")
  ;; parser.h
  (:return-type $xml-doc-ptr)
  (:arguments (filename c-string))
  (:documentation
   "Parse the XML file FILENAME and build a document tree.
Returns a pointer to the tree so built, if the file is wellformed, and
returns false otherwise.  Automatic support for ZLIB/Compress
compressed documents is provided by default if found at
compile-time."))

(def-call-out $xml-keep-blanks-default (:name "xmlKeepBlanksDefault")
  ;; parser.h
  (:return-type int)
  (:arguments (val int))
  (:documentation
   "Set the value for default blanks text nodes support.
Returns the previous value."))

(def-call-out $xml-read-file (:name "xmlReadFile")
  ;; parser.h
  (:return-type $xml-doc-ptr)
  (:arguments (filename c-string) (encoding c-string) (options int))
  (:documentation
   "Parse the XML file FILENAME and build a document tree using ENCODING.
Returns a pointer to the tree so built, if the file is wellformed, and
returns false otherwise."))

(def-call-out $xml-cleanup-parser (:name "xmlCleanupParser")
  ;; parser.h
  (:return-type nil)
  (:arguments)
  (:documentation
   "Clean up the memory allocated by libxml2.
Tries to reclaim all related global memory allocated for libxml
processing.  Does not deallocate any document-related memory.  This
function should be called only when the process has finished using the
libxml2 library, and all documents built with it."))



;;;; XPath.

(def-call-out $lxcl-xpath-node-set-get-length
    (:name "lxcl_xpath_node_set_get_length")
  (:return-type int)
  (:arguments (node-set $xml-node-set-ptr))
  (:documentation
   "Return the number of nodes in NODE-SET."))

(def-call-out $lxcl-xpath-node-set-item
    (:name "lxcl_xpath_node_set_item")
  (:return-type $xml-node-ptr)
  (:arguments (node-set $xml-node-set-ptr) (index int))
  (:documentation
   "Return the INDEX-th node in NODE-SET."))

(def-call-out $lxcl-xpath-node-set-is-empty
    (:name "lxcl_xpath_node_set_is_empty")
  (:return-type int)
  (:arguments (xpath-object $xml-node-set-ptr))
  (:documentation
   "Return a non-zero integer if NODE-SET contains no nodes."))

(def-call-out $lxcl-xpath-object-type (:name "lxcl_xpath_object_type")
  (:return-type $xml-xpath-object-type)
  (:arguments (node-set $xml-xpath-object-ptr)))

(def-call-out $lxcl-xpath-object-nodesetval
    (:name "lxcl_xpath_object_nodesetval")
  (:return-type $xml-node-set-ptr)
  (:arguments (xpath-object $xml-xpath-object-ptr)))

(def-call-out $xml-xpath-free-object (:name "xmlXPathFreeObject")
  ;; xpath.h
  (:return-type nil)
  (:arguments (obj $xml-xpath-object-ptr))
  (:documentation
   "Free the memory occupied by OBJ."))

(def-call-out $xml-xpath-new-context (:name "xmlXPathNewContext")
  ;; xpath.h
  (:return-type $xml-xpath-context-ptr)
  (:arguments (doc $xml-doc-ptr))
  (:documentation
   "Create a new XPath Context.  The caller will need to free it."))

(def-call-out $xml-xpath-free-context (:name "xmlXPathFreeContext")
  ;; xpath.h
  (:return-type nil)
  (:arguments (ctxt $xml-xpath-context-ptr))
  (:documentation
   "Free the memory occupied by CTXT."))

(def-call-out $xml-xpath-eval-expression (:name "xmlXPathEvalExpression")
  ;; xpath.h
  (:return-type $xml-xpath-object-ptr)
  (:arguments (str $xml-char-ptr) (ctxt $xml-xpath-context-ptr))
  (:documentation
   "Evaluate the XPath expression STR in the XPath context CTXT.
Returns the XPath object resulting from the evaluation, or nil.  The
caller has to free the object."))



;;;; XML IO.

(def-call-out $xml-output-buffer-create-io (:name "xmlOutputBufferCreateIO")
  ;; xmlIO.h
  (:return-type $xml-output-buffer-ptr)
  (:arguments (iowrite $xml-output-write-callback)
              (ioclose c-pointer) (ioctx c-pointer)
              (encoder $xml-char-encoding-handler-ptr))
  (:documentation
   "Return a pointer to a buffer for streamed output.
IOWRITE must be a function for writing to the stream.  IOCLOSE must be
a function for closing the stream.  IOCTX is an IO handler.  ENCODER
is a pointer to an encoding handler."))



;;;; Character Encodings.

(def-call-out $xml-find-char-encoding-handler (:name
                                               "xmlFindCharEncodingHandler")
  ;; encoding.h
  (:return-type $xml-char-encoding-handler-ptr)
  (:arguments (name c-string))
  (:documentation
   "Return a pointer to a character encoding handler for the encoding NAME.
Searches the registered set of character encoding handlers."))



;;;; Entities.

(def-call-out $xml-encode-entities-reentrant
    (:name "xmlEncodeEntitiesReentrant")
  ;; entities.h
  (:return-type $xml-char-ptr)
  (:arguments (doc $xml-doc-ptr) (input $xml-char-ptr))
  (:documentation
   "Replace entity references in INPUT with their values in the context DOC.
Also replaces non-ASCII characters in INPUT with the corresponding
character entity references.  Returns the address of the resulting XML
String.  It is up to the caller to free that XML String."))



;;;; Text Reader operations.

(def-call-out $xml-reader-for-file (:name "xmlReaderForFile")
  ;; xmlreader.h
  (:return-type $xml-text-reader-ptr)
  (:arguments (filename c-string) (encoding c-string) (options int))
  (:documentation
   "Create an XML Text Reader to process FILENAME using ENCODING.
Returns a pointer to the reader so built if the file is wellformed,
and returns false otherwise."))

(def-call-out $xml-text-reader-read (:name "xmlTextReaderRead")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Move the position of READER to the next node in the stream.
Returns 1 if the node was read successfully, 0 if there are no more
nodes to read, and -1 in case of error."))

(def-call-out $xml-free-text-reader (:name "xmlFreeTextReader")
  ;; xmlreader.h
  (:return-type nil)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Deallocate all the resources associated with the reader READER."))

(def-call-out $xml-text-reader-node-type (:name "xmlTextReaderNodeType")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the type of the node at the current position of READER.
The node type is as in `$xml-reader-types'."))

(def-call-out $xml-text-reader-depth (:name "xmlTextReaderDepth")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the tree-depth of the node at the current position of READER.
Returns -1 in case of error."))

(def-call-out $xml-text-reader-const-name (:name "xmlTextReaderConstName")
  ;; xmlreader.h
  (:return-type $xml-char-ptr)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the qualified name of the node at the current position of READER.
The qualified name is of the form `prefix:local-name'.  The returned
XML String address is freed when the reader is freed."))

(def-call-out $xml-text-reader-move-to-next-attribute
    (:name "xmlTextReaderMoveToNextAttribute")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Move the position of READER to the next attribute of the current node.
Returns 1 in case of success, 0 if there was no such attribute, and -1
in case of error."))

(def-call-out $xml-text-reader-move-to-element
    (:name "xmlTextReaderMoveToElement")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Move the READER to the element containing the current attribute.
Returns 1 in case of success, 0 if the position of READER was not
moved, and -1 in case of error."))

(def-call-out $xml-text-reader-is-empty-element
    (:name "xmlTextReaderIsEmptyElement")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return 1 if the current node of READER is an empty element.
Returns 0 if the current node of READER is not an empty element, and
-1 in case of error."))

(def-call-out $xml-text-reader-const-local-name
    (:name "xmlTextReaderConstLocalName")
  ;; xmlreader.h
  (:return-type $xml-char-ptr)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the local name of the node at the current position of READER.
The returned XML String address is freed when the reader is freed."))

(def-call-out $xml-text-reader-const-namespace-uri
    (:name "xmlTextReaderConstNamespaceUri")
  ;; xmlreader.h
  (:return-type $xml-char-ptr)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the URI of the namespace associated with the current node.
The returned XML String address is freed when the reader is freed."))

(def-call-out $xml-text-reader-namespace-uri
    (:name "xmlTextReaderNamespaceUri")
  ;; xmlreader.h
  (:return-type $xml-char-ptr)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the URI of the namespace associated with the current node."))

(def-call-out $xml-text-reader-is-namespace-decl
    (:name "xmlTextReaderIsNamespaceDecl")
  ;; xmlreader.h
  (:return-type int)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return 1 if the current node of READER is a namespace declaration.
Returns 0 if the current node of READER is not a namespace
declaration, and -1 in case of error."))

(def-call-out $xml-text-reader-const-value (:name "xmlTextReaderConstValue")
  ;; xmlreader.h
  (:return-type $xml-char-ptr)
  (:arguments (reader $xml-text-reader-ptr))
  (:documentation
   "Return the value of the text property of the current node.
The returned XML String address is freed with the next read operation
on READER."))



;;;; XML Catalogs.

(def-call-out $xml-initialize-catalog (:name "xmlInitializeCatalog")
  ;; catalog.h
  (:return-type nil)
  (:arguments)
  (:documentation "Initialze catalogs."))

(def-call-out $xml-load-catalog (:name "xmlLoadCatalog")
  ;; catalog.h
  (:return-type int)
  (:arguments (filename c-string))
  (:documentation
   "Load the catalog FILENAME.
Returns 0 in case of success, and -1 otherwise."))



;;;; XML Writer.

(def-call-out $xml-new-text-writer (:name "xmlNewTextWriter")
  ;; xmlwriter.h
  (:return-type $xml-text-writer-ptr)
  (:arguments (out $xml-output-buffer-ptr))
  (:documentation
   "Create an XML Text Writer sending its output to OUT.
Returns a pointer to the writer so built."))

(def-call-out $xml-free-text-writer (:name "xmlFreeTextWriter")
  ;; xmlwriter.h
  (:return-type nil)
  (:arguments (writer $xml-text-writer-ptr))
  (:documentation
   "Deallocate all the resources associated with the writer WRITER."))

(def-call-out $xml-text-writer-set-indent (:name "xmlTextWriterSetIndent")
  ;; xmlwriter.h
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (indent int))
  (:documentation
   "Indent the output of WRITER if INDENT is positive.
If INDENT is 0, the output of WRITER is not indented.  Returns 0 on
success and -1 otherwise."))

(def-call-out $xml-text-writer-start-document
    (:name "xmlTextWriterStartDocument")
  ;; xmlwriter.h
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (version c-string)
              (encoding c-string) (standalone c-string))
  (:documentation
   "Write the start of a new XML document with WRITER using ENCODING.
VERSION must be \"1.0\" or NULL.  If ENCODING is NULL, then UTF-8 is
used.  STANDALONE must be \"yes\", \"no\", or NULL.  Returns the
number of octets written (may be 0 because of buffering), or -1 in
case of error."))

(def-call-out $xml-text-writer-start-element
    (:name "xmlTextWriterStartElement")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (name $xml-char-ptr))
  (:documentation
   "Write the start of an element named NAME with WRITER.
Returns the number of octets written (may be 0 because of buffering),
or -1 in case of error"))

(def-call-out $xml-text-writer-start-element-ns
    (:name "xmlTextWriterStartElementNS")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (prefix $xml-char-ptr)
              (name $xml-char-ptr) (namespace-uri $xml-char-ptr))
  (:documentation
   "Write the start of an element named NAME with WRITER.
NAMESPACE-URI is the namespace name of the element.  PREFIX is the
namespace prefix of the element.  Returns the number of octets
written (may be 0 because of buffering), or -1 in case of error"))

(def-call-out $xml-text-writer-write-attribute-ns
    (:name "xmlTextWriterWriteAttributeNS")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (prefix $xml-char-ptr)
              (name $xml-char-ptr) (namespace-uri $xml-char-ptr)
              (content $xml-char-ptr))
  (:documentation
   "Write an attribute named NAME with WRITER.
NAMESPACE-URI is the namespace name of the element.  PREFIX is the
namespace prefix of the element.  CONTENT is the value of the
attribute.  Returns the number of octets written (may be 0 because of
buffering), or -1 in case of error."))

(def-call-out $xml-text-writer-end-element
    (:name "xmlTextWriterEndElement")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr))
  (:documentation
   "Write the end of the current element with WRITER.
Returns the number of octets written (may be 0 because of buffering),
or -1 in case of error."))

(def-call-out $xml-text-writer-write-comment
    (:name "xmlTextWriterWriteComment")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr) (content $xml-char-ptr))
  (:documentation
   "Write a comment with text CONTENT using WRITER.
Returns the number of octets written (may be 0 because of buffering),
or -1 in case of error."))

(def-call-out $xml-text-writer-end-document
    (:name "xmlTextWriterEndDocument")
  (:return-type int)
  (:arguments (writer $xml-text-writer-ptr))
  (:documentation
   "Write the end of the current document with WRITER.
Returns the number of octets written (may be 0 because of buffering),
or -1 in case of error."))



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; foreign.lisp ends here