;;;; common.lisp --- example for libxml-clisp tutorial

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-07-15
;;; 
;;; $Hg: common.lisp,v a5b014b13f84 2009-09-22T13:30:29+05:30 raghu $

(in-package "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES")



(defun default-test (function object result &key (test #'equal))
  "Return true if FUNCTION tests successfully.
FUNCTION must be a function that takes a single argument.  The result
of applying FUNCTION to OBJECT is compared with RESULT using TEST."
  (funcall test (funcall function object) result))

(defvar *test-function* #'default-test
  "A test function for libxml-clisp.")

(defun test-libxml-clisp (&rest rest)
  (apply *test-function* rest))

(defvar *test-directory*
  (merge-pathnames
   (make-pathname 
    :directory '(:relative "othervc" "libxml-clisp" "examples"))
   (user-homedir-pathname))
  "Directory containing the test files for libxml-clisp.")

(defvar *tmp-directory*
  (make-pathname :directory '(:absolute "tmp"))
  "Directory for temporary files.")

(defmacro with-temp-file ((pathname &key (prefix "temp.")) &body body)
  (let ((name (format nil "~A" (gensym prefix))))
    `(let ((,pathname (make-pathname :name ,name :directory *tmp-directory*)))
       (unwind-protect
         (progn ,@body)
         (when (probe-file ,pathname)
           (delete-file ,pathname))))))

(defvar *examples* '()
  "Examples to be tested.")

(defun provide-example (example)
  "Add examples to the list of examples to be tested."
  (sort (pushnew example *examples*) #'string<))

(defun test-examples (&rest examples)
  "Test EXAMPLES.
Returns true if all the examples pass their tests.  If one of them
fails, execution stops, and false is returned."
  (loop for example in examples
     for result = (funcall (symbol-function
                            (intern (format nil "TEST-~A" example))))
     do (format t "~A: test ~A~%" example (if result "PASSED" "FAILED"))
     always result))

(defun test-all-examples ()
  "Test all the examples in the list of examples to be tested."
  (apply #'test-examples *examples*))
  


;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; common.lisp ends here