/*
    This file is part of libtermui.

    libtermui is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    libtermui is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with libtermui.  If not, see <http://www.gnu.org/licenses/>.

    Copyright 2006, Alexandre Becoulet <alexandre.becoulet@free.fr>

*/

#ifndef TERM_UI_CONSOLE_H_
#define TERM_UI_CONSOLE_H_

#include <unistd.h>

struct				command_args_s;
struct				console_ctx_s;
struct				command_entry_s;

#define CONSOLE_LINE_MAXLEN	512

/* 
 * console_main.c
 */

/* Initialise console context */

struct console_ctx_s * console_alloc(struct command_entry_s **root,
				     int in, int out, const char *type);

/* Free console resources */

void console_free(struct console_ctx_s *con);

/* Set console prompt string */

void console_set_prompt(struct console_ctx_s *con,
			const char *prompt);

/* Append a command tree at end of current root list */

void console_register(struct console_ctx_s *con,
		      struct command_entry_s *list);

/* find a command entry from full path */

struct command_entry_s *console_find_command(struct console_ctx_s *con,
					     char *path);

/* Wait for user entry and process a single command */

int console_process(struct console_ctx_s *con);

/* Wait for user entry and return line content */

const char * console_input(struct console_ctx_s *con,
			   const char *prompt);

/* Return console output stream */

int console_output(struct console_ctx_s *con);

/* Return console private data */

void * console_get_private(struct console_ctx_s *con);

/* Set console private data */

void console_set_private(struct console_ctx_s *con, void *pv);

void console_set_acl(struct console_ctx_s *con,
		     int acl_mask);

int console_printf(struct console_ctx_s *con, const char *fmt, ...);

/*
 * console_telnet.c
 */

/* send initialisation IAC commands to telnet client */

void console_telnet_setup(struct console_ctx_s *con);

#endif /* CONSOLE_H_ */

