/*
    This file is part of libtermui.

    libtermui is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    libtermui is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with libtermui.  If not, see <http://www.gnu.org/licenses/>.

    Copyright 2006, Alexandre Becoulet <alexandre.becoulet@free.fr>

*/

/*
 * This example show how to use libtermui standalone getline feature.
 */

#include <stdlib.h>
#include <string.h>

#include <termui/term.h>
#include <termui/getline.h>

struct		private_s
{
  int		counter;
};

static GETLINE_FCN_PROMPT(prompt)
{
  struct private_s	*pv = private;

  return term_printf(tm, "[%31Aexample %1A%u%A] ", pv->counter);
}

int main()
{
  struct term_s			*tm;
  struct term_behavior_s	*bhv;
  struct private_s		pv;

  /* initialize terminal */
  if (!(tm = term_alloc(0, 1, &pv)))
    return -1;

  /* set capabilities */
  term_set(tm, getenv("TERM"));

  term_printf(tm, "libtermui getline example, use Ctrl-D to quit\n\n");

  pv.counter = 0;

  /* initialize getline behavior according to term capabilities */
  if (!(bhv = getline_alloc(tm, 256)))	/* max line len = 256 */
    return -1;

  getline_history_init(bhv, 64); /* 64 entries max */

  getline_setprompt(bhv, prompt);

  while (1)
    {
      const char *line;

      if (!(line = getline_process(bhv)))
	break;

      /* skip blank line */
      if (!*(line += strspn(line, "\n\r\t ")))
	continue;

      getline_history_addlast(bhv);

      pv.counter++;

      term_printf(tm, "entered line is: `%s'\n\n", line);
    }

  /* free resources allocated by getline behavior */
  getline_free(bhv);

  /* free resources and restore terminal attributes */
  term_free(tm);

  return 0;
}

