/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007, 2008 Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/** @file Debug.H                                                            *
 *                                                                           *
 *  Ogg::Debug for blocked printing of debugging information                 *
 *                                                                           */
/*===========================================================================*/
#ifndef	OggDebug
#define	OggDebug

#ifdef __GNUG__
#pragma interface
#endif

#include	<iostream>

extern	"C"
{
#include	<pthread.h>
}


namespace	Ogg
{
  using	std::ostream;
    
  class Debug
  {
  private:
    pthread_mutexattr_t	lockType;
    pthread_mutex_t	lock;

  public:
    Debug() throw()
    {
      pthread_mutexattr_init(&lockType);
      // using a non-POSIX type
      pthread_mutexattr_settype(&lockType, PTHREAD_MUTEX_RECURSIVE);
      pthread_mutex_init(&lock, &lockType);
    }

    virtual
    ~Debug() throw ()
    {}

    void
    init()
    {
      pthread_mutexattr_init(&lockType);
      pthread_mutexattr_settype(&lockType, PTHREAD_MUTEX_RECURSIVE);
      pthread_mutex_init(&lock, &lockType);
    }

    void
    begin()
    {
      pthread_mutex_lock(&lock);
      std::cerr << std::endl << "[";
    }

    void
    end()
    {
      std::cerr << "]" << std::endl;
      pthread_mutex_unlock(&lock);
    }
  }
  ;

  extern Debug	Dbg;

  inline
  Debug& operator<<(ostream & os, Debug & dbg)
  {
    dbg.end();
    return(dbg);
  }

  inline
  ostream& operator<<(Debug & dbg, ostream & os)
  {
    dbg.begin();
    return(os);
  }

  inline void debug()
  {
    Dbg.init();
  }

  inline void debug(bool test)
  {
    if ( _GEN_DEBUG_CODE && test )
      ;
  }

  template<class X>
  inline void debug(bool test
		    ,const X & x
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	    << x
	    << Dbg;
      }
  }

  template<class X1
	   , class X2
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	  << x1
	  << x2
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	  << x1
	  << x2
	  << x3
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	    << x1
	    << x2
	    << x3
	    << x4
	    << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	    << x1
	    << x2
	    << x3
	    << x4
	    << x5
	    << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg << std::cerr
	    << x1
	    << x2
	    << x3
	    << x4
	    << x5
	    << x6
	    << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   , class X7
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    ,const X7 & x7
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg
	  <<std::cerr
	  << x1
	  << x2
	  << x3
	  << x4
	  << x5
	  << x6
	  << x7
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   , class X7
	   , class X8
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    ,const X7 & x7
		    ,const X8 & x8
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg
	  <<std::cerr
	  << x1
	  << x2
	  << x3
	  << x4
	  << x5
	  << x6
	  << x7
	  << x8
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   , class X7
	   , class X8
	   , class X9
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    ,const X7 & x7
		    ,const X8 & x8
		    ,const X9 & x9
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg
	  <<std::cerr
	  << x1
	  << x2
	  << x3
	  << x4
	  << x5
	  << x6
	  << x7
	  << x8
	  << x9
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   , class X7
	   , class X8
	   , class X9
	   , class X10
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    ,const X7 & x7
		    ,const X8 & x8
		    ,const X9 & x9
		    ,const X10 & x10
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg
	  <<std::cerr
	  << x1
	  << x2
	  << x3
	  << x4
	  << x5
	  << x6
	  << x7
	  << x8
	  << x9
	  << x10
	  << Dbg;
      }
  }

  template<class X1
	   , class X2
	   , class X3
	   , class X4
	   , class X5
	   , class X6
	   , class X7
	   , class X8
	   , class X9
	   , class X10
	   , class X11
	   >
  inline void debug(bool test
		    ,const X1 & x1
		    ,const X2 & x2
		    ,const X3 & x3
		    ,const X4 & x4
		    ,const X5 & x5
		    ,const X6 & x6
		    ,const X7 & x7
		    ,const X8 & x8
		    ,const X9 & x9
		    ,const X10 & x10
		    ,const X11 & x11
		    )
  {
    if ( _GEN_DEBUG_CODE && test )
      {
	Dbg
	  <<std::cerr
	  << x1
	  << x2
	  << x3
	  << x4
	  << x5
	  << x6
	  << x7
	  << x8
	  << x9
	  << x10
	  << x11
	  << Dbg;
      }
  }

}

#endif
