/********************************************************************************
	eddml toolset - parses eddml files to extract error information
	Copyright (C) 2004 by Pete Rowley
	pete@openrowley.com

    This file is part of the eddml toolset.

    The eddml toolset is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The eddml toolset is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*********************************************************************************/

#include <stdio.h>
#include "eddml.h"

int main(void)
{
	int ret = -1;
	eddml_translator *t;

	if(0 == eddml_init())
	{
		if(0 == eddml_get_translator(&t))
		{
			const char *file[] = {"../src/test/ldap.xml", 0};
			char *bad_files[2];

			if(0 == eddml_use_translation_files(t, file, bad_files))
			{
				char *sets[] = {"ldap",0};

				if(0 == eddml_translate( t, "0x61", 0, (const char**)sets))
				{
					ret = eddml_first_error(t);
					while(ret == 0)
					{
						char *set, *ver, *auth, *doc;
						char *code, *desc, *sev;
						char **titles, **bodies, **stitles, **sbodies;
						int i;

						eddml_get_name(t, &set);
						eddml_get_version(t, &ver);
						eddml_get_authority(t, &auth);
						eddml_get_docs(t, &doc);

						eddml_get_error_code(t, &code);
						eddml_get_error_desc(t, &desc);
						eddml_get_error_severity(t, &sev);

						printf("%s v%s: %s (%s) %s\nAuthority: %s\nDocuments: %s\n", set, ver, code, sev, desc, auth, doc);

						eddml_get_error_note_titles(t, &titles);
						eddml_get_error_note_bodies(t, &bodies);

						for(i=0; titles[i]; i++)
						{
							printf("\n%s : %s\n", titles[i], bodies[i]);
						}

						eddml_get_error_symbol_languages(t, &stitles);
						eddml_get_error_symbol_bodies(t, &sbodies);

						for(i=0; stitles[i]; i++)
						{
							printf("\n%s : %s", stitles[i], sbodies[i]);
						}

						ret = eddml_next_error(t);
					}
					printf("\n");
					ret = 0;
				}
				else
				{
					printf("Can't initialize translation\n");
					goto done;
				}
			}
			else
			{
				printf("Can't set translation file %s\n", bad_files[0]);
				goto done;
			}
		}
		else
		{
			printf("Can't get translator\n");
		}

		done:
		eddml_done();
	}
	else
	{
		printf("Can't init\n");
	}

	return ret;
}
