#ifndef OUTPUTMAP_H
#define OUTPUTMAP_H
/*

    Copyright (C) 2002, 2003  John Darrington 

    $Id: outputMap.h,v 1.6 2003/05/14 05:50:16 john Exp $

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string>
#include <map>
#include "ann.h"

namespace ann {     

  class FeatureMap ;

  //  A map of the names of classes to their expected network ouputs
  class OutputMap : public std::map<ann::vector,std::string> { 
  public:
    // Default constructor.  Create an empty one
    OutputMap():std::map<ann::vector,std::string>(){};
    

    // Create an output map from  a feature map
    OutputMap(const FeatureMap &fm, bool bipolar = false, int size = -1);


    // Look up in the `wrong' direction
    // --- Get a vector, given a string
    const ann::vector & reverseLookup(const std::string &s) const ; 

  private:
    std::map<std::string,ann::vector> reverseMap;

  };
};

#endif /* OUTPUTMAP_H */
