/* -*- c++ -*-
 *
 * donkeyhost.h
 *
 * Copyright (C) 2003, 2004 Petter E. Stokke <gibreel@gibreel.net>
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_donkeyhost_h__
#define __libkmldonkey_donkeyhost_h__

#include <hostiface.h>

#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qobject.h>
#include <kaction.h>

//! Representation of an MLDonkey host.
class DonkeyHost : public HostInterface
{

public:
    DonkeyHost(const QString& h_name, const QString& h_address, int h_port,
	       const QString& h_username, const QString& h_password,
	       HostInterface::HostType h_type,
               const KURL& temp = KURL(), const KURL& incoming = KURL(),
	       const KURL& h_binaryPath = KURL(), const KURL& h_rootPath = KURL(),
	       HostInterface::StartupMode h_startupMode = AtKDEStart);
    DonkeyHost(DonkeyHost&);
    DonkeyHost();
    ~DonkeyHost() {}

    //! The username to authenticate with.
    const QString& username() const;
    //! The password to authenticate with.
    const QString& password() const;
    //! The path to this host's temp directory.
    const KURL& tempDirectory() const;
    //! The path to this host's incoming directory.
    const KURL& incomingDirectory() const;

private:
    QString m_username,
            m_password;
    KURL m_temp,
         m_incoming;
};

#endif
