/* -*- c++ -*-
 *
 * search.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_search_h__
#define __kmldonkey_search_h__

#include "infolist.h"
#include "page.h"
#include "clipboard.h"

#include <qvbox.h>
#include <qintdict.h>
#include <qstringlist.h>
#include <qtooltip.h>

#include <kdeversion.h>

class KListView;
class KComboBox;
class KLineEdit;

#if KDE_IS_VERSION(3,1,90)
class KTabWidget;
#else
class ClosableTabWidget;
#endif

class SearchResultItem : public InfoItem
{
public:
    SearchResultItem(KListView *parent, int num, const ResultInfo *searchinfo);
    ~SearchResultItem();

    virtual double numeric(int col) const;
    virtual bool isNumeric(int col) const;
    void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);

    QString xtext( int column ) const;

    inline int getNum();
    inline QStringList getNames();
    inline int64 getSize();

private:
    int number;
    QString name, nwName, format, comment, md4;
    QStringList names;
    int64 filesize;
    int32 availability;
    bool alreadydone;
};

class SearchResultView : public InfoList, QToolTip
{
    Q_OBJECT
public:
    SearchResultView(QWidget *parent = 0, const char *name = 0);
protected:
    virtual void maybeTip(const QPoint&);
};

class SearchResult : public QVBox
{
    Q_OBJECT
public:
    SearchResult(int sno, const QString &tabLabel, QWidget *parent);
    ~SearchResult();

    inline int searchNo();
    inline const QString& getTabLabel();
    inline void setSearchLabel(const QString &text);
    inline void setListFont(const QFont& font);

    void AddItem(const ResultInfo* searchinfo);
    void DownloadSelectedItems(bool force, bool askForFilename);

    SearchResultView *resultView;

private:
    int id;
    QString tabLabel;
    int visibleCount;

    QHBox *statusBox;
    QStringList filters;
    KLineEdit *filterEdit;
    QTimer *filterTimer;
    QLabel *searchLabel;
    QLabel *statusLabel;

    inline void setStatusLabel();
    bool filterItem(SearchResultItem *item);

protected slots:
    void filterChanged();
    void filterTimerDone();
    void contextSearchResult(KListView*,QListViewItem*,const QPoint&);
    void doubleClick(QListViewItem*);
};

class SearchPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    SearchPage(QWidget *parent);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void configurePrefsDialog(KMLDonkeyPreferences*);
    virtual void applyPreferences(KMLDonkeyPreferences*);
    virtual void saveState(KConfig*);
    virtual void restoreState(KConfig*);
    virtual void clear();

    // Don't call this function! It's only used to clean up
    // previous searches at KMLDonkey::close()!
    void stopAllSearches();

private:
#if KDE_IS_VERSION(3,1,90)
    KTabWidget *resultTabs;
#else
    ClosableTabWidget *resultTabs;
#endif
    QSplitter *splitter;
    KLineEdit *keywordsEdit;
    KComboBox *minsizeCombo;
    KComboBox *maxsizeCombo;
    KComboBox *mediaCombo;
    KComboBox *formatCombo;
    KLineEdit *mp3ArtistEdit;
    KLineEdit *mp3TitleEdit;
    KLineEdit *mp3AlbumEdit;
    KComboBox *mp3BitrateCombo;
    KLineEdit *maxhitsEdit;
    KComboBox *searchtypeCombo;
    KComboBox *searchnetCombo;

    QHBox* ed2kBox;
    KLineEdit* ed2kEntry;

    int searchNum;
    QIntDict<SearchResult> Results;
    int maxHits;
    int searchType;
    QString searchNetwork;

    bool activateNewTabs;
    bool closeTabsOnDisconnect;
    bool showNumbersOnTabs;
    bool showSubmitURL;

    inline QString getTabLabel(SearchResult *tab);
    inline void stopSearch(int);

signals:
    void genericActionsChanged(KMLDonkeyPage*);

protected:
    void copySearchToClipboard(ClipFormat format);

protected slots:
    void setNetworks(int);
    void startSearch();
    void closeSearch(QWidget*);
    void searchUpdated(int, const ResultInfo*);
    void closeAllSearches();
    void pleaseUpdateActions();
    void submitED2K();

public slots:
    void actionDownload();
    void actionDownloadAs();
    void actionForceDownload();

    void actionActivatePage();
};

#endif // __kmldonkey_search_h__
