/***************************************************************************
                          khttrackstruct.cpp  -  description
                             -------------------
    begin                : Thu Jun 20 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly@ifrance.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h> // printf

#include <string.h>
#include "khttrackstruct.h"

  char httrackCmd[500][1024];

KhttrackStruct::KhttrackStruct(){
initProject() ;
}
KhttrackStruct::~KhttrackStruct(){
}
/** Affectation des valeurs par defaut aux membres de la structure s_project, ou bien les valeurs indefinies. */
void KhttrackStruct::initProject(){

  s_project.gene_action = INT_UNKNOWN;
  strcpy( s_project.gene_projectInfo, CHAR_UNKNOWN); // MultiLineEdit2   QMultiLineEdit
  strcpy( s_project.gene_projectName, CHAR_UNKNOWN); // ProjectName      Qlabel
  strcpy( s_project.gene_projectPath, DEFAULT_PATH); // EditProjectPath  QLineEdit
  s_project.gene_start = INT_UNKNOWN;
  s_project.gene_timeHour = INT_UNKNOWN;
  s_project.gene_timeMin = INT_UNKNOWN;
  s_project.gene_timeSec = INT_UNKNOWN;
  strcpy( s_project.gene_url, CHAR_UNKNOWN);         // URLEdit          QMultiLineEdit

  /** Window Options
  option.ui
  */
  // Proxy

  strcpy( s_project.browserID_footer, CHAR_UNKNOWN);
  strcpy( s_project.browserID_identity, CHAR_UNKNOWN);    // QComboBox34      QComboBox
  s_project.build_dosName = INT_UNKNOWN;
  s_project.build_hidePasswords = INT_UNKNOWN;
  s_project.build_hideQueryString = INT_UNKNOWN;
  s_project.build_noErrorPages = INT_UNKNOWN;
  s_project.build_noExternalPages = INT_UNKNOWN;
  s_project.build_notPurges = INT_UNKNOWN;
  s_project.build_personnalStruct = INT_UNKNOWN;
  strcpy( s_project.build_siteStructureTypePerso, CHAR_UNKNOWN);
  s_project.build_siteStructureType = INT_UNKNOWN;
  s_project.experts_debug = INT_UNKNOWN;
  s_project.experts_primaryScanRule = INT_UNKNOWN;
  s_project.experts_rewriteLinks = INT_UNKNOWN;
  s_project.experts_travelMode = INT_UNKNOWN;
  s_project.experts_globalTravelMode = INT_UNKNOWN;
  s_project.experts_useCache = INT_UNKNOWN;
  strcpy(   s_project.flow_minTransfert, CHAR_UNKNOWN);
  strcpy(   s_project.flow_numConnections, CHAR_UNKNOWN);
  strcpy(   s_project.flow_retries, CHAR_UNKNOWN);
  strcpy(   s_project.flow_timeOut, CHAR_UNKNOWN);
  s_project.flow_removeHostLow = INT_UNKNOWN;
  s_project.flow_removeTimeOut = INT_UNKNOWN;
  strcpy( s_project.limits_maxConnexion, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxExtDepth, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxLinks, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxMirrorDepth, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxSizeHTML, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxSizeNonHTML, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxTime, CHAR_UNKNOWN);
  strcpy( s_project.limits_maxTransfer, CHAR_UNKNOWN);
  strcpy( s_project.limits_pauseDownload, CHAR_UNKNOWN);
  strcpy( s_project.limits_siteSize, CHAR_UNKNOWN);
  s_project.links_detectAllLinks = INT_UNKNOWN;
  s_project.links_getHTMLFirst = INT_UNKNOWN;
  s_project.links_getNonHTML = INT_UNKNOWN;
  s_project.links_test = INT_UNKNOWN;
  s_project.log_createLog = INT_UNKNOWN;
  s_project.log_makeIndex = INT_UNKNOWN;
  s_project.log_redownload = INT_UNKNOWN;
  s_project.log_storeAllCache = INT_UNKNOWN;
  s_project.log_wordDatabase = INT_UNKNOWN;
  s_project.log_logLevel = INT_UNKNOWN;
  strcpy( s_project.proxy_address, CHAR_UNKNOWN);       // ComboBox1    ComboBox
  s_project.proxy_hidePassword = INT_UNKNOWN;
  //s_project.  proxy_login;
  //s_project.  proxy_password;
  strcpy( s_project.proxy_port, CHAR_UNKNOWN);            // LineEdit1    QLineEdit
  s_project.proxy_useFtp = INT_UNKNOWN;
  strcpy( s_project.scanRules_filter, CHAR_UNKNOWN);    // MultiLineEdit3 QMultiLineEdit
  s_project.scanRules_gif = INT_UNKNOWN;
  s_project.scanRules_zip = INT_UNKNOWN;
  s_project.scanRules_mov = INT_UNKNOWN;
  s_project.spider_acceptCookies = INT_UNKNOWN;
  s_project.spider_checkType = INT_UNKNOWN;
  s_project.spider_notPuges = INT_UNKNOWN;
  s_project.spider_parseJava = INT_UNKNOWN;
  s_project.spider_spider = INT_UNKNOWN;
  s_project.spider_tolerantRequest = INT_UNKNOWN;
  s_project.spider_updateHacks = INT_UNKNOWN;
  s_project.spider_http1 = INT_UNKNOWN;
  //s_project.  mimeType_file01;
  //s_project.  mimeType_file02;
  //s_project.  mimeType_file03;
  //s_project.  mimeType_file04;
  //s_project.  mimeType_file05;
  //s_project.  mimeType_file06;
  //s_project.  mimeType_file07;
  //s_project.  mimeType_file08;
  //s_project.  mimeType_file09;
  //s_project.  mimeType_file10;
  //s_project.  mimeType_mime01;
  //s_project.  mimeType_mime02;
  //s_project.  mimeType_mime03;
  //s_project.  mimeType_mime04;
  //s_project.  mimeType_mime05;
  //s_project.  mimeType_mime06;
  //s_project.  mimeType_mime07;
  //s_project.  mimeType_mime08;
  //s_project.  mimeType_mime09;
  //s_project.  mimeType_mime10;

}
/** Lit un "s_project"  partir d'un fichier et charge la structure */
int KhttrackStruct::loadProject(){
  return 0 ;
}
/** Enregistre le s_project dans un fichier, spcifi dans la structure (Path). */
int KhttrackStruct::saveProject(){
  return 0 ;
}
/** Genere la commande  envoyer au moteur httrack */
int KhttrackStruct::generateCmd(){

  int index=0;
  int host=0;
  char chainetmp[10];
  char filter[1024];

  unsigned int old_i = 0;
  unsigned int i = 0;


  strcpy( filter, "");
  strcpy(httrackCmd[index], "httrack");

  /*** use directly URL as first arg */
  if (!(strcmp( s_project.gene_url, CHAR_UNKNOWN) == 0 )){

  // Cut the list of url in argument for httrack
    for ( i = 0  ; i < strlen( s_project.gene_url) ; i++ )
    {
       if (( s_project.gene_url[i] == ' ' ) || ( s_project.gene_url[i] == ',' ))
       {
          index++;
          strncpy(httrackCmd[index], s_project.gene_url+old_i, i - old_i);
          printf("\nhttrackCmd[index]=%s",httrackCmd[index]);
          i++;
          old_i = i ;
       }
    }
    index++;
    strncpy(httrackCmd[index], s_project.gene_url+old_i, i - old_i);
    printf("\nhttrackCmd[index]=%s",httrackCmd[index]);


  }

  /*** Scan rules */
  /*** Project path */
  // Chemin de destination du mirroir : "DEFAULT_PATH/s_project.gene_projectName" par defaut
  index++ ;
  strcpy(httrackCmd[index], "-O");
  index++ ;
  strcpy(httrackCmd[index], s_project.gene_projectPath);
  strcat(httrackCmd[index], "/");
  strcat(httrackCmd[index], s_project.gene_projectName);
/*
  //if (!( strcmp( s_project.gene_projectName, CHAR_UNKNOWN) == 0 )){ }

  //if (!( s_project.gene_action == INT_UNKNOWN ))
  //{
  //}

  //if (!( strcmp( s_project.gene_projectInfo, CHAR_UNKNOWN) == 0 )){ }





  //if (!(s_project.gene_start == INT_UNKNOWN)){ }

  //if (!(s_project.gene_timeHour == INT_UNKNOWN)){ }

  //if (!(s_project.gene_timeMin == INT_UNKNOWN)){ }

  //if (!(s_project.gene_timeSec == INT_UNKNOWN)){ }
*/

  /*** Browser ID */
  if (!(strcmp( s_project.browserID_identity, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-F");
    index++ ;
    strcpy(httrackCmd[index],"\"");
    strcat(httrackCmd[index], s_project.browserID_identity);
    strcat(httrackCmd[index],"\"");
  }
  if (!(strcmp( s_project.browserID_footer, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-%F ");
    index++ ;
    strcpy(httrackCmd[index],"\"");
    strcat(httrackCmd[index], s_project.browserID_footer);
    strcat(httrackCmd[index],"\"");
  }
  /*** Links */
  if ( s_project.links_detectAllLinks != INT_UNKNOWN )
  {
    if ( !s_project.links_detectAllLinks )
    {
    index++ ;
    strcpy(httrackCmd[index],"-%P"); //
    }
  }
  if ( s_project.links_getHTMLFirst != INT_UNKNOWN )
  {
    if ( s_project.links_getHTMLFirst)
    {
    index++ ;
    strcpy(httrackCmd[index],"-p");
    }
  }
  if ( s_project.links_getNonHTML != INT_UNKNOWN )
  {
    if ( s_project.links_getNonHTML)
    {
    index++ ;
    strcpy(httrackCmd[index],"-n");
    }
  }
  if ( s_project.links_test != INT_UNKNOWN )
  {
    if ( s_project.links_test)
    {
    index++ ;
    strcpy(httrackCmd[index],"-t");
    }
  }
  /*** Limits options */
  if (!(strcmp( s_project.limits_maxConnexion, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-%c");
    strcat(httrackCmd[index],s_project.limits_maxConnexion);
  }
  if (!(strcmp( s_project.limits_maxExtDepth, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"--ext-depth=");
    strcat(httrackCmd[index],s_project.limits_maxExtDepth);
  }
  if (!(strcmp( s_project.limits_maxLinks, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-#L");
    strcat(httrackCmd[index],s_project.limits_maxLinks);
  }
  if (!(strcmp( s_project.limits_maxMirrorDepth, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"--depth=");
    strcat(httrackCmd[index],s_project.limits_maxMirrorDepth);
  }
  if (!(strcmp( s_project.limits_maxSizeHTML, CHAR_UNKNOWN) == 0 )){
  }
  else if (!(strcmp( s_project.limits_maxSizeNonHTML, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-%c");
    strcat(httrackCmd[index],s_project.limits_maxSizeHTML);
    strcat(httrackCmd[index],",");
    strcat(httrackCmd[index],s_project.limits_maxSizeNonHTML);
  }
  if (!(strcmp( s_project.limits_maxTime, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-E");
    strcat(httrackCmd[index],s_project.limits_maxTime);
  }
  if (!(strcmp( s_project.limits_maxTransfer, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-A");
    strcat(httrackCmd[index],s_project.limits_maxTransfer);
  }
  if (!(strcmp( s_project.limits_pauseDownload, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-G");
    strcat(httrackCmd[index],s_project.limits_pauseDownload);
  }
  if (!(strcmp( s_project.limits_siteSize, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-M");
    strcat(httrackCmd[index],s_project.limits_siteSize);
  }
  /*** Build Option */
/*
  // NON IMPL2MENT2E :
  int    build_personnalStruct;
  char    build_siteStructureTypePerso[CH_TL];
*/
  if ( s_project.build_dosName != INT_UNKNOWN )
  {
    if ( s_project.build_dosName)
    {
    index++ ;
    strcpy(httrackCmd[index],"-L0");
    }
  }
  if ( s_project.build_hidePasswords != INT_UNKNOWN )
  {
    if ( s_project.build_hidePasswords)
    {
    index++ ;
    strcpy(httrackCmd[index],"-%x");
    }
  }
  if ( s_project.build_hideQueryString != INT_UNKNOWN )
  {
    if ( s_project.build_hideQueryString)
    {
    index++ ;
    strcpy(httrackCmd[index],"-%q0");
    }
  }
  if ( s_project.build_noErrorPages != INT_UNKNOWN )
  {
    if ( s_project.build_noErrorPages)
    {
    index++ ;
    strcpy(httrackCmd[index],"-o0");
    }
  }
  if ( s_project.build_notPurges != INT_UNKNOWN )
  {
    if ( s_project.build_notPurges)
    {
    index++ ;
    strcpy(httrackCmd[index],"-X0");
    }
  }
  if ( s_project.build_siteStructureType != INT_UNKNOWN )
  {
   index++;
   switch( s_project.build_siteStructureType)
   {
      case 0:
          strcpy(httrackCmd[index], "-N0");
          break;
      case 1:
          strcpy(httrackCmd[index], "-N1");
          break;
      case 2:
          strcpy(httrackCmd[index], "-N2");
          break;
      case 3:
          strcpy(httrackCmd[index], "-N3");
          break;
      case 4:
          strcpy(httrackCmd[index], "-N4");
          break;
      case 5:
          strcpy(httrackCmd[index], "-N5");
          break;
      case 6:
          strcpy(httrackCmd[index], "-N100");
          break;
      case 7:
          strcpy(httrackCmd[index], "-N101");
          break;
      case 8:
          strcpy(httrackCmd[index], "-N102");
          break;
      case 9:
          strcpy(httrackCmd[index], "-N103");
          break;
      case 10:
          strcpy(httrackCmd[index], "-N104");
          break;
      case 11:
          strcpy(httrackCmd[index], "-N105");
          break;
      case 12:
          strcpy(httrackCmd[index], "-N99");
          break;
      default:
          break;
   }
  }
  /*** Spider */
  if ( s_project.spider_checkType != INT_UNKNOWN )
  {
   index++;
   switch( s_project.spider_checkType)
   {
      case 0:
          strcpy(httrackCmd[index], "-u2");
          break;
      case 1:
          strcpy(httrackCmd[index], "-u1");
          break;
      case 2:
          strcpy(httrackCmd[index], "-u0");
          break;
      default:
          strcpy(httrackCmd[index], "-u1");
          break;
   }
  }
  if ( s_project.spider_spider != INT_UNKNOWN )
  {
   index++;
   switch( s_project.spider_spider)
   {
      case 0:
          strcpy(httrackCmd[index], "-s2");
          break;
      case 1:
          strcpy(httrackCmd[index], "-s1");
          break;
      case 2:
          strcpy(httrackCmd[index], "-s0");
          break;
      default:
          strcpy(httrackCmd[index], "-s2");
          break;
   }
  }
  if ( s_project.spider_acceptCookies != INT_UNKNOWN )
  {
    if ( s_project.spider_acceptCookies == 0)
    {
    index++ ;
    strcpy(httrackCmd[index],"-b0");
    }
  }
  if ( s_project.spider_parseJava != INT_UNKNOWN )
  {
    if ( s_project.spider_parseJava == 0)
    {
    index++ ;
    strcpy(httrackCmd[index],"-j0");
    }
  }
  if ( s_project.spider_updateHacks != INT_UNKNOWN )
  {
    if ( s_project.spider_updateHacks == 0)
    {
    index++ ;
    strcpy(httrackCmd[index],"--updatehack");
    }
  }
  if ( s_project.spider_tolerantRequest != INT_UNKNOWN )
  {
    if ( s_project.spider_tolerantRequest)
    {
    index++ ;
    strcpy(httrackCmd[index],"--tolerant");
    }
  }
  if ( s_project.spider_http1 != INT_UNKNOWN )
  {
    if ( s_project.spider_http1)
    {
    index++ ;
    strcpy(httrackCmd[index],"--http-10");
    }
  }
  /*** Log, index, Cache */
  if ( s_project.log_storeAllCache != INT_UNKNOWN )
  {
    if ( s_project.log_storeAllCache)
    {
    index++ ;
    strcpy(httrackCmd[index],"-k");
    }
  }
  if ( s_project.log_redownload != INT_UNKNOWN )
  {
    if ( s_project.log_redownload)
    {
    index++ ;
    strcpy(httrackCmd[index],"--do-not-recatch");
    }
  }
  if ( s_project.log_createLog != INT_UNKNOWN )
  {
    if ( s_project.log_createLog || s_project.log_logLevel != INT_UNKNOWN)
    {
      if ( s_project.log_createLog)
      {
        if ( s_project.log_logLevel != INT_UNKNOWN )
        {
         index++;
         switch( s_project.log_logLevel)
         {
            case 0:
                break;
            case 1:
                index++;
                strcpy(httrackCmd[index], "--extra-log");
                break;
            case 2:
                index++;
                strcpy(httrackCmd[index], "--debug-log");
                break;
            default:
                break;
         }
        }
      }
      else
      {
        index++ ;
        strcpy(httrackCmd[index],"--do-not-log");
      }
    }
  }
  if ( s_project.log_makeIndex != INT_UNKNOWN )
  {
    if ( s_project.log_makeIndex)
    {
    index++ ;
    strcpy(httrackCmd[index],"--index");
    }
  }
  if ( s_project.log_wordDatabase != INT_UNKNOWN )
  {
    if ( s_project.log_wordDatabase)
    {
    index++ ;
    strcpy(httrackCmd[index],"--search-index");
    }
  }
  /*** Expert only */
  if ( s_project.experts_useCache != INT_UNKNOWN )
  {
    if ( s_project.experts_useCache == 0)
    {
    index++ ;
    strcpy(httrackCmd[index],"-C0");
    }
  }
  if ( s_project.experts_primaryScanRule != INT_UNKNOWN )
  {
   index++;
   switch( s_project.experts_primaryScanRule)
   {
      case 0:
          strcpy(httrackCmd[index], "-p3");
          break;
      case 1:
          strcpy(httrackCmd[index], "-p0");
          break;
      case 2:
          strcpy(httrackCmd[index], "-p1");
          break;
      case 3:
          strcpy(httrackCmd[index], "-p2");
          break;
      case 4:
          strcpy(httrackCmd[index], "-p7");
          break;
      default:
          strcpy(httrackCmd[index], "-p3");
          break;
   }
  }
  if ( s_project.experts_travelMode != INT_UNKNOWN )
  {
   index++;
   switch( s_project.experts_travelMode)
   {
      case 0:
          strcpy(httrackCmd[index], "-D");
          break;
      case 1:
          strcpy(httrackCmd[index], "-S");
          break;
      case 2:
          strcpy(httrackCmd[index], "-U");
          break;
      case 3:
          strcpy(httrackCmd[index], "-B");
          break;
      default:
          strcpy(httrackCmd[index], "-D");
          break;
     }
    }
  if ( s_project.experts_globalTravelMode != INT_UNKNOWN )
  {
   index++;
   switch( s_project.experts_globalTravelMode)
   {
      case 0:
          strcpy(httrackCmd[index], "-a");
          break;
      case 1:
          strcpy(httrackCmd[index], "-d");
          break;
      case 2:
          strcpy(httrackCmd[index], "-l");
          break;
      case 3:
          strcpy(httrackCmd[index], "-e");
          break;
      default:
          strcpy(httrackCmd[index], "-a");
          break;
   }
  }
  if ( s_project.experts_rewriteLinks != INT_UNKNOWN )
  {
   index++;
   switch( s_project.experts_rewriteLinks)
   {
      case 0:
          strcpy(httrackCmd[index], "-K0");
          break;
      case 1:
          strcpy(httrackCmd[index], "-K");
          break;
      case 2:
          strcpy(httrackCmd[index], "-K3");
          break;
      case 3:
          strcpy(httrackCmd[index], "-K4");
          break;
      default:
          strcpy(httrackCmd[index], "-K0");
          break;
    }
   }
  /*** Flow */
  if (!(strcmp( s_project.flow_minTransfert, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-J");
    strcat(httrackCmd[index],s_project.flow_minTransfert);
  }
  if (!(strcmp( s_project.flow_numConnections, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-c");
    strcat(httrackCmd[index],s_project.flow_numConnections);
  }
  if (!(strcmp( s_project.flow_retries, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-R");
    strcat(httrackCmd[index],s_project.flow_retries);
  }
  if (!(strcmp( s_project.flow_timeOut, CHAR_UNKNOWN) == 0 )){
    index++ ;
    strcpy(httrackCmd[index],"-T");
    strcat(httrackCmd[index],s_project.flow_timeOut);
  }
  if (( s_project.flow_removeHostLow != INT_UNKNOWN ) || ( s_project.flow_removeTimeOut != INT_UNKNOWN ))
  {
    if ( ( s_project.flow_removeHostLow != INT_UNKNOWN ))
        host = host + 2 ;
    if ( ( s_project.flow_removeTimeOut != INT_UNKNOWN ))
        host = host + 1 ;
    index++ ;
    strcpy(httrackCmd[index],"-H");
    sprintf(chainetmp,"%d",host);
    strcat(httrackCmd[index],chainetmp);
  }

  /*** Utilisation du proxy */
  if (!(strcmp( s_project.proxy_address, CHAR_UNKNOWN) == 0 )){
    if (!(strcmp( s_project.proxy_port, CHAR_UNKNOWN) == 0 ))
    {
       index++ ;
       strcpy(httrackCmd[index],"--P");
       index++ ;
       strcpy(httrackCmd[index],s_project.proxy_address);
       strcat(httrackCmd[index],":");
       strcat(httrackCmd[index],s_project.proxy_port);

       if ( s_project.proxy_useFtp )
       {
           index++ ;
           strcpy(httrackCmd[index],"-%f");
       }


    }
  }

  /*** mode verbeux */
  index++ ;
  strcpy(httrackCmd[index], "-%v");

  /*** Action generale */
   index++ ;
   switch( s_project.gene_action)
  {
      case 0:
          strcpy(httrackCmd[index], "--mirror");
          break;
      case 1:
          strcpy(httrackCmd[index], "--mirror");
          break;
      case 2:
          strcpy(httrackCmd[index], "--get");
          break;
      case 3:
          strcpy(httrackCmd[index], "--mirror");
          index++ ;
          strcpy(httrackCmd[index], "-e");
          break;
      case 4:
          strcpy(httrackCmd[index], "--testlinks");
          break;
      case 5:
          strcpy(httrackCmd[index], "--continue");
          break;
      case 6:
          strcpy(httrackCmd[index], "--update");
          break;
      default:
          strcpy(httrackCmd[index], "--mirror");
          break;
  }
  /*** Filter ! */
  if (!(strcmp( s_project.scanRules_filter, CHAR_UNKNOWN) == 0 )){
     strcat(filter,s_project.scanRules_filter);
  }
  if ( s_project.scanRules_gif != INT_UNKNOWN){
   if ( s_project.scanRules_gif )
    {
     strcat(filter,"+*.gif +*.jpg +*.png +*.tif +*.bmp");
    }
  }
  if ( s_project.scanRules_zip != INT_UNKNOWN){
   if ( s_project.scanRules_zip )
    {
     strcat(filter,"+*.zip +*.tar +*.gz +*.rar +*.z +*.exe");
    }
  }
  if ( s_project.scanRules_mov != INT_UNKNOWN){
   if ( s_project.scanRules_mov )
    {
     strcat(filter,"+*.mov +*.mpg +*.mpeg +*.avi +*.asf +*.mp3 +*.ogg +*.ogm +*.mp2 +*.rm +*.ram +*.wav +*.vob +*.qt +*.vid +*.ac3 +*.wma +*.wmv");
    }
  }
  if ( strlen(filter) != 0 )
  {
     index++;
     strcpy(httrackCmd[index], filter);
  }
  /*** rajoute une commande vide pour compatibililit */
  index++ ;
  strcpy(httrackCmd[index], "");

  for (int i=0; i< index-1 ; i++ )
      printf("\nhttrackCmd[%i]=%s",i,httrackCmd[i]);
  puts("");
  return 0 ;
}
