%define prefix       /usr
%define cpu          i586 
%define system       linux

Summary:   Khttrack allows you to download a WWW site to a local directory with a Kde Gui.
Name:      khttrack
Version:   0.9
Release:   1
Copyright: GPL
Vendor:    Stephane Chapeau <nuscly@ifrance.com>, Xavier Roche and other contributors <xroche@httrack.com>
Url:       http://freesoftware.fsf.org/khttrack

Packager:  Stephane Chapeau <nuscly@ifrance.com>
Group:     Networking/WWW
Source:    %{name}-%{version}.tar.gz
BuildRoot: /tmp/%{name}-%{version}.root

%description
Khttrack is a free sofware and easy-to-use offline browser utility based
on GPL Httrack used as libary. The Khttrack project will give a Kde GUI
to the Httrack library to be used by more people in an more simple and
friendly way : a simple wizard ask you all needed questions and it
start automatically,It allows you to download a World Wide Web site
from the Internet to a local directory, building recursively all
directories, getting HTML, images, and other files from the server
to your computer. Khttrack arranges the original site
relative link-structure. Simply open a page of the "mirrored"
website in your browser, and you can browse the site from link
to link, as if you were viewing it online. Khttrack can also
update an existing mirrored site, and resume interrupted downloads.
Khttrack is fully configurable, and has an integrate help system.
The Kde Gui will allow all option of HTTrack library.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
                 --build=%{cpu}-%{system} --host=%{cpu}-%{system} --target=%{cpu}-%{system} --prefix=%{prefix} \
                $LOCALFLAGS
%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
  numprocs=1
fi

make -j$numprocs

%install
make install-strip DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.khttrack
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.khttrack
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.khttrack

%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/khttrack
rm -rf ../file.list.khttrack


%files -f ../file.list.khttrack
