/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : lun jun 10 19:13:24 CEST 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly-devel@laposte.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "khttrack.h"

static const char *description =
	I18N_NOOP("Khttrack\n\
Khttrack is a free sofware and easy-to-use offline browser utility based on GPL\n\
Httrack used as libary. The Khttrack project will give a Kde GUI to the Httrack\n\
library to be used by more people in an more simple and friendly way : a simple\n\
wizard ask you all needed questions and it start automatically.\n\n\
It allows you to download a World Wide Web site from the Internet to a local\n\
directory, building recursively all directories, getting HTML, images, and other\n\
files from the server to your computer.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions optionscmdline[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "khttrack", I18N_NOOP("Khttrack"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2002, Stephane Chapeau", 0, 0, "nuscly-devel@laposte.net");
	aboutData.addAuthor("Stephane Chapeau",0, "nuscly-devel@laposte.net");
	aboutData.addAuthor("Xavier Roche and Co",0, "httrack@httrack.com");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( optionscmdline ); // Add our own optionscmdline.

  KApplication app;
 
  if (app.isRestored())
  {
    RESTORE(KhttrackApp);
  }
  else 
  {
    KhttrackApp *khttrack = new KhttrackApp();
    khttrack->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count())
		{
        khttrack->openDocumentFile(args->arg(0));
		}
		else
		{
		  khttrack->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}  
