/***************************************************************************
                          khttrackdoc.cpp  -  description
                             -------------------
    begin                : lun jun 10 19:13:24 CEST 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly-devel@laposte.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "khttrackdoc.h"
#include "khttrack.h"
#include "khttrackview.h"

QList<KhttrackView> *KhttrackDoc::pViewList = 0L;

KhttrackDoc::KhttrackDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  if(!pViewList)
  {
    pViewList = new QList<KhttrackView>();
  }

  pViewList->setAutoDelete(true);
}

KhttrackDoc::~KhttrackDoc()
{
}

void KhttrackDoc::addView(KhttrackView *view)
{
  pViewList->append(view);
}

void KhttrackDoc::removeView(KhttrackView *view)
{
  pViewList->remove(view);
}
void KhttrackDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& KhttrackDoc::URL() const
{
  return doc_url;
}

void KhttrackDoc::slotUpdateAllViews(KhttrackView *sender)
{
  KhttrackView *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool KhttrackDoc::saveModified()
{
  bool completed=true;

  if(modified)
  {
    KhttrackApp *win=(KhttrackApp *) parent();
    int want_save = KMessageBox::warningYesNoCancel(win,
                                         i18n("The current file has been modified.\n"
                                              "Do you want to save it?"),
                                         i18n("Warning"));
    switch(want_save)
    {
      case KMessageBox::Yes:
           if (doc_url.fileName() == i18n("Untitled"))
           {
             win->slotFileSaveAs();
           }
           else
           {
             saveDocument(URL());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case KMessageBox::No:
           setModified(false);
           deleteContents();
           completed=true;
           break;

      case KMessageBox::Cancel:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

void KhttrackDoc::closeDocument()
{
  deleteContents();
}

bool KhttrackDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  doc_url.setFileName(i18n("Untitled"));

  return true;
}

bool KhttrackDoc::openDocument(const KURL& url, const char *format /*=0*/)
{
  QString tmpfile;
  KIO::NetAccess::download( url, tmpfile );
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  KIO::NetAccess::removeTempFile( tmpfile );

  modified=false;
  return true;
}

bool KhttrackDoc::saveDocument(const KURL& url, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

void KhttrackDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}
