/* ------------------------------------------------------------ */
/*
HTTrack Website Copier, Offline Browser for Windows and Unix
Copyright (C) Xavier Roche and other contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


Important notes:

- We hereby ask people using this source NOT to use it in purpose of grabbing
emails addresses, or collecting any other private information on persons.
This would disgrace our work, and spoil the many hours we spent on it.


Please visit our Website: http://www.httrack.com
*/


/* ------------------------------------------------------------ */
/* File: HTTrack definition file for library usage              */
/* Author: Xavier Roche                                         */
/* ------------------------------------------------------------ */


#ifndef HTTRACK_DEFLIB
#define HTTRACK_DEFLIB

#include "htsglobal.h"
#include "htsopt.h"
#include "htswrap.h"

/* Main functions */
HTSEXT_API int hts_init(void);
HTSEXT_API int hts_uninit(void);
HTSEXT_API int hts_main(int argc, char **argv);

/* Wrapper functions */
HTSEXT_API int htswrap_init(void);
HTSEXT_API int htswrap_add(char* name,void* fct);
HTSEXT_API int htswrap_free(void);
HTSEXT_API unsigned long int htswrap_read(char* name);
HTSEXT_API const char* hts_is_available(void);

/* Other functions */
HTSEXT_API int hts_resetvar(void);
HTSEXT_API int hts_buildtopindex(char* path,char* binpath);

/* Catch-URL */
HTSEXT_API T_SOC catch_url_init_std(int* port_prox,char* adr_prox);
HTSEXT_API T_SOC catch_url_init(int* port,char* adr);
HTSEXT_API int catch_url(T_SOC soc,char* url,char* method,char* data);

/* State */
HTSEXT_API int hts_is_parsing(int flag);
HTSEXT_API int hts_is_testing(void);
HTSEXT_API int hts_is_exiting(void);
HTSEXT_API int hts_setopt(httrackp* opt);
HTSEXT_API int hts_addurl(char** url);
HTSEXT_API int hts_resetaddurl(void);
HTSEXT_API int copy_htsopt(httrackp* from, httrackp* to);
HTSEXT_API char* hts_errmsg(void);
HTSEXT_API int hts_setpause(int);      // pause transfer
HTSEXT_API int hts_request_stop(int force);
HTSEXT_API char* hts_cancel_file(char * s);
HTSEXT_API void hts_cancel_test(void);
HTSEXT_API void hts_cancel_parsing(void);
HTSEXT_API char* hts_cancel_file(char * s);
HTSEXT_API void hts_cancel_test(void);
HTSEXT_API void hts_cancel_parsing(void);

/* Tools */
HTSEXT_API int structcheck(char* s);
HTSEXT_API void infostatuscode(char* msg,int statuscode);
HTSEXT_API HTS_INLINE TStamp mtime_local(void);
HTSEXT_API void qsec2str(char *st,TStamp t);
HTSEXT_API char* int2char(int n);
HTSEXT_API char* int2bytes(LLint n);
HTSEXT_API char* int2bytessec(long int n);
HTSEXT_API char** int2bytes2(LLint n);
HTSEXT_API char* jump_identification(char*);
HTSEXT_API char* jump_toport(char*);
HTSEXT_API char* hts_rootdir(char* file);

/* Escaping URLs */
HTSEXT_API void unescape_amp(char* s);
HTSEXT_API void escape_spc_url(char* s);
HTSEXT_API void escape_in_url(char* s);
HTSEXT_API void escape_uri(char* s);
HTSEXT_API void escape_uri_utf(char* s);
HTSEXT_API void escape_check_url(char* s);
HTSEXT_API char* escape_check_url_addr(char* s);
HTSEXT_API void  x_escape_http(char* s,int mode);
HTSEXT_API char* unescape_http(char* s);
HTSEXT_API char* unescape_http_unharm(char* s, int no_high);
HTSEXT_API char* antislash_unescaped(char* s);
HTSEXT_API void  escape_remove_control(char* s);

#endif
